/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.model.dstu2.resource;

import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.model.api.BaseIdentifiableElement;
import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.IResource;
import ca.uhn.fhir.model.api.IResourceBlock;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.TemporalPrecisionEnum;
import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Compartment;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.model.dstu2.composite.AnnotationDt;
import ca.uhn.fhir.model.dstu2.composite.CodeableConceptDt;
import ca.uhn.fhir.model.dstu2.composite.IdentifierDt;
import ca.uhn.fhir.model.dstu2.composite.ResourceReferenceDt;
import ca.uhn.fhir.model.dstu2.resource.BaseResource;
import ca.uhn.fhir.model.dstu2.resource.Condition;
import ca.uhn.fhir.model.dstu2.resource.Device;
import ca.uhn.fhir.model.dstu2.resource.DocumentReference;
import ca.uhn.fhir.model.dstu2.resource.Encounter;
import ca.uhn.fhir.model.dstu2.resource.Group;
import ca.uhn.fhir.model.dstu2.resource.Location;
import ca.uhn.fhir.model.dstu2.resource.Observation;
import ca.uhn.fhir.model.dstu2.resource.Patient;
import ca.uhn.fhir.model.dstu2.resource.Practitioner;
import ca.uhn.fhir.model.dstu2.resource.Specimen;
import ca.uhn.fhir.model.dstu2.valueset.DiagnosticOrderPriorityEnum;
import ca.uhn.fhir.model.dstu2.valueset.DiagnosticOrderStatusEnum;
import ca.uhn.fhir.model.primitive.BoundCodeDt;
import ca.uhn.fhir.model.primitive.CodeDt;
import ca.uhn.fhir.model.primitive.DateTimeDt;
import ca.uhn.fhir.rest.gclient.CompositeClientParam;
import ca.uhn.fhir.rest.gclient.DateClientParam;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@ResourceDef(name="DiagnosticOrder", profile="http://hl7.org/fhir/profiles/DiagnosticOrder", id="diagnosticorder")
public class DiagnosticOrder
extends BaseResource
implements IResource {
    @SearchParamDefinition(name="actor", path="DiagnosticOrder.event.actor | DiagnosticOrder.item.event.actor", description="", type="reference", providesMembershipIn={@Compartment(name="RelatedPerson"), @Compartment(name="Practitioner")})
    public static final String SP_ACTOR = "actor";
    public static final ReferenceClientParam ACTOR = new ReferenceClientParam("actor");
    @SearchParamDefinition(name="bodysite", path="DiagnosticOrder.item.bodySite", description="", type="token")
    public static final String SP_BODYSITE = "bodysite";
    public static final TokenClientParam BODYSITE = new TokenClientParam("bodysite");
    @SearchParamDefinition(name="code", path="DiagnosticOrder.item.code", description="", type="token")
    public static final String SP_CODE = "code";
    public static final TokenClientParam CODE = new TokenClientParam("code");
    @SearchParamDefinition(name="event-date", path="DiagnosticOrder.event.dateTime", description="", type="date")
    public static final String SP_EVENT_DATE = "event-date";
    public static final DateClientParam EVENT_DATE = new DateClientParam("event-date");
    @SearchParamDefinition(name="encounter", path="DiagnosticOrder.encounter", description="", type="reference", providesMembershipIn={@Compartment(name="Encounter")})
    public static final String SP_ENCOUNTER = "encounter";
    public static final ReferenceClientParam ENCOUNTER = new ReferenceClientParam("encounter");
    @SearchParamDefinition(name="identifier", path="DiagnosticOrder.identifier", description="", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="item-date", path="DiagnosticOrder.item.event.dateTime", description="", type="date")
    public static final String SP_ITEM_DATE = "item-date";
    public static final DateClientParam ITEM_DATE = new DateClientParam("item-date");
    @SearchParamDefinition(name="item-past-status", path="DiagnosticOrder.item.event.status", description="", type="token")
    public static final String SP_ITEM_PAST_STATUS = "item-past-status";
    public static final TokenClientParam ITEM_PAST_STATUS = new TokenClientParam("item-past-status");
    @SearchParamDefinition(name="item-status", path="DiagnosticOrder.item.status", description="", type="token")
    public static final String SP_ITEM_STATUS = "item-status";
    public static final TokenClientParam ITEM_STATUS = new TokenClientParam("item-status");
    @SearchParamDefinition(name="orderer", path="DiagnosticOrder.orderer", description="", type="reference", providesMembershipIn={@Compartment(name="RelatedPerson")})
    public static final String SP_ORDERER = "orderer";
    public static final ReferenceClientParam ORDERER = new ReferenceClientParam("orderer");
    @SearchParamDefinition(name="event-status", path="DiagnosticOrder.event.status", description="", type="token")
    public static final String SP_EVENT_STATUS = "event-status";
    public static final TokenClientParam EVENT_STATUS = new TokenClientParam("event-status");
    @SearchParamDefinition(name="specimen", path="DiagnosticOrder.specimen | DiagnosticOrder.item.specimen", description="", type="reference")
    public static final String SP_SPECIMEN = "specimen";
    public static final ReferenceClientParam SPECIMEN = new ReferenceClientParam("specimen");
    @SearchParamDefinition(name="status", path="DiagnosticOrder.status", description="", type="token")
    public static final String SP_STATUS = "status";
    public static final TokenClientParam STATUS = new TokenClientParam("status");
    @SearchParamDefinition(name="subject", path="DiagnosticOrder.subject", description="", type="reference", providesMembershipIn={@Compartment(name="Patient"), @Compartment(name="Practitioner")})
    public static final String SP_SUBJECT = "subject";
    public static final ReferenceClientParam SUBJECT = new ReferenceClientParam("subject");
    @SearchParamDefinition(name="patient", path="DiagnosticOrder.subject", description="", type="reference", target={Patient.class})
    public static final String SP_PATIENT = "patient";
    public static final ReferenceClientParam PATIENT = new ReferenceClientParam("patient");
    @SearchParamDefinition(name="item-past-status-item-date", path="item-past-status & item-date", description="A combination of item-past-status and item-date", type="composite", compositeOf={"item-past-status", "item-date"})
    public static final String SP_ITEM_PAST_STATUS_ITEM_DATE = "item-past-status-item-date";
    public static final CompositeClientParam<TokenClientParam, DateClientParam> ITEM_PAST_STATUS_ITEM_DATE = new CompositeClientParam("item-past-status-item-date");
    @SearchParamDefinition(name="event-status-event-date", path="event-status & event-date", description="A combination of past-status and date", type="composite", compositeOf={"event-status", "event-date"})
    public static final String SP_EVENT_STATUS_EVENT_DATE = "event-status-event-date";
    public static final CompositeClientParam<TokenClientParam, DateClientParam> EVENT_STATUS_EVENT_DATE = new CompositeClientParam("event-status-event-date");
    public static final Include INCLUDE_ACTOR = new Include("DiagnosticOrder:actor");
    public static final Include INCLUDE_ENCOUNTER = new Include("DiagnosticOrder:encounter");
    public static final Include INCLUDE_ORDERER = new Include("DiagnosticOrder:orderer");
    public static final Include INCLUDE_PATIENT = new Include("DiagnosticOrder:patient");
    public static final Include INCLUDE_SPECIMEN = new Include("DiagnosticOrder:specimen");
    public static final Include INCLUDE_SUBJECT = new Include("DiagnosticOrder:subject");
    @Child(name="subject", order=0, min=1, max=1, summary=true, modifier=false, type={Patient.class, Group.class, Location.class, Device.class})
    @Description(shortDefinition="who.focus", formalDefinition="Who or what the investigation is to be performed on. This is usually a human patient, but diagnostic tests can also be requested on animals, groups of humans or animals, devices such as dialysis machines, or even locations (typically for environmental scans)")
    private ResourceReferenceDt mySubject;
    @Child(name="orderer", order=1, min=0, max=1, summary=true, modifier=false, type={Practitioner.class})
    @Description(shortDefinition="who.actor", formalDefinition="The practitioner that holds legal responsibility for ordering the investigation")
    private ResourceReferenceDt myOrderer;
    @Child(name="identifier", type={IdentifierDt.class}, order=2, min=0, max=-1, summary=true, modifier=false)
    @Description(shortDefinition="id", formalDefinition="Identifiers assigned to this order instance by the orderer and/or  the receiver and/or order fulfiller.")
    private List<IdentifierDt> myIdentifier;
    @Child(name="encounter", order=3, min=0, max=1, summary=true, modifier=false, type={Encounter.class})
    @Description(shortDefinition="context", formalDefinition="An encounter that provides additional information about the healthcare context in which this request is made")
    private ResourceReferenceDt myEncounter;
    @Child(name="reason", type={CodeableConceptDt.class}, order=4, min=0, max=-1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="An explanation or justification for why this diagnostic investigation is being requested.   This is often for billing purposes.  May relate to the resources referred to in supportingInformation.")
    private List<CodeableConceptDt> myReason;
    @Child(name="supportingInformation", order=5, min=0, max=-1, summary=false, modifier=false, type={Observation.class, Condition.class, DocumentReference.class})
    @Description(shortDefinition="", formalDefinition="Additional clinical information about the patient or specimen that may influence test interpretations.  This includes observations explicitly requested by the producer(filler) to provide context or supporting information needed to complete the order.")
    private List<ResourceReferenceDt> mySupportingInformation;
    @Child(name="specimen", order=6, min=0, max=-1, summary=false, modifier=false, type={Specimen.class})
    @Description(shortDefinition="", formalDefinition="One or more specimens that the diagnostic investigation is about")
    private List<ResourceReferenceDt> mySpecimen;
    @Child(name="status", type={CodeDt.class}, order=7, min=0, max=1, summary=true, modifier=true)
    @Description(shortDefinition="status", formalDefinition="The status of the order")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/diagnostic-order-status")
    private BoundCodeDt<DiagnosticOrderStatusEnum> myStatus;
    @Child(name="priority", type={CodeDt.class}, order=8, min=0, max=1, summary=true, modifier=false)
    @Description(shortDefinition="grade", formalDefinition="The clinical priority associated with this order")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/diagnostic-order-priority")
    private BoundCodeDt<DiagnosticOrderPriorityEnum> myPriority;
    @Child(name="event", order=9, min=0, max=-1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="A summary of the events of interest that have occurred as the request is processed; e.g. when the order was made, various processing steps (specimens received), when it was completed")
    private List<Event> myEvent;
    @Child(name="item", order=10, min=0, max=-1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="The specific diagnostic investigations that are requested as part of this request. Sometimes, there can only be one item per request, but in most contexts, more than one investigation can be requested")
    private List<Item> myItem;
    @Child(name="note", type={AnnotationDt.class}, order=11, min=0, max=-1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="Any other notes associated with this patient, specimen or order (e.g. \"patient hates needles\")")
    private List<AnnotationDt> myNote;

    public boolean isEmpty() {
        return super.isBaseEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.mySubject, this.myOrderer, this.myIdentifier, this.myEncounter, this.myReason, this.mySupportingInformation, this.mySpecimen, this.myStatus, this.myPriority, this.myEvent, this.myItem, this.myNote});
    }

    public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
        return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.mySubject, this.myOrderer, this.myIdentifier, this.myEncounter, this.myReason, this.mySupportingInformation, this.mySpecimen, this.myStatus, this.myPriority, this.myEvent, this.myItem, this.myNote});
    }

    public ResourceReferenceDt getSubject() {
        if (this.mySubject == null) {
            this.mySubject = new ResourceReferenceDt();
        }
        return this.mySubject;
    }

    public DiagnosticOrder setSubject(ResourceReferenceDt theValue) {
        this.mySubject = theValue;
        return this;
    }

    public ResourceReferenceDt getOrderer() {
        if (this.myOrderer == null) {
            this.myOrderer = new ResourceReferenceDt();
        }
        return this.myOrderer;
    }

    public DiagnosticOrder setOrderer(ResourceReferenceDt theValue) {
        this.myOrderer = theValue;
        return this;
    }

    public List<IdentifierDt> getIdentifier() {
        if (this.myIdentifier == null) {
            this.myIdentifier = new ArrayList<IdentifierDt>();
        }
        return this.myIdentifier;
    }

    public DiagnosticOrder setIdentifier(List<IdentifierDt> theValue) {
        this.myIdentifier = theValue;
        return this;
    }

    public IdentifierDt addIdentifier() {
        IdentifierDt newType = new IdentifierDt();
        this.getIdentifier().add(newType);
        return newType;
    }

    public DiagnosticOrder addIdentifier(IdentifierDt theValue) {
        if (theValue == null) {
            throw new NullPointerException("theValue must not be null");
        }
        this.getIdentifier().add(theValue);
        return this;
    }

    public IdentifierDt getIdentifierFirstRep() {
        if (this.getIdentifier().isEmpty()) {
            return this.addIdentifier();
        }
        return this.getIdentifier().get(0);
    }

    public ResourceReferenceDt getEncounter() {
        if (this.myEncounter == null) {
            this.myEncounter = new ResourceReferenceDt();
        }
        return this.myEncounter;
    }

    public DiagnosticOrder setEncounter(ResourceReferenceDt theValue) {
        this.myEncounter = theValue;
        return this;
    }

    public List<CodeableConceptDt> getReason() {
        if (this.myReason == null) {
            this.myReason = new ArrayList<CodeableConceptDt>();
        }
        return this.myReason;
    }

    public DiagnosticOrder setReason(List<CodeableConceptDt> theValue) {
        this.myReason = theValue;
        return this;
    }

    public CodeableConceptDt addReason() {
        CodeableConceptDt newType = new CodeableConceptDt();
        this.getReason().add(newType);
        return newType;
    }

    public DiagnosticOrder addReason(CodeableConceptDt theValue) {
        if (theValue == null) {
            throw new NullPointerException("theValue must not be null");
        }
        this.getReason().add(theValue);
        return this;
    }

    public CodeableConceptDt getReasonFirstRep() {
        if (this.getReason().isEmpty()) {
            return this.addReason();
        }
        return this.getReason().get(0);
    }

    public List<ResourceReferenceDt> getSupportingInformation() {
        if (this.mySupportingInformation == null) {
            this.mySupportingInformation = new ArrayList<ResourceReferenceDt>();
        }
        return this.mySupportingInformation;
    }

    public DiagnosticOrder setSupportingInformation(List<ResourceReferenceDt> theValue) {
        this.mySupportingInformation = theValue;
        return this;
    }

    public ResourceReferenceDt addSupportingInformation() {
        ResourceReferenceDt newType = new ResourceReferenceDt();
        this.getSupportingInformation().add(newType);
        return newType;
    }

    public List<ResourceReferenceDt> getSpecimen() {
        if (this.mySpecimen == null) {
            this.mySpecimen = new ArrayList<ResourceReferenceDt>();
        }
        return this.mySpecimen;
    }

    public DiagnosticOrder setSpecimen(List<ResourceReferenceDt> theValue) {
        this.mySpecimen = theValue;
        return this;
    }

    public ResourceReferenceDt addSpecimen() {
        ResourceReferenceDt newType = new ResourceReferenceDt();
        this.getSpecimen().add(newType);
        return newType;
    }

    public BoundCodeDt<DiagnosticOrderStatusEnum> getStatusElement() {
        if (this.myStatus == null) {
            this.myStatus = new BoundCodeDt(DiagnosticOrderStatusEnum.VALUESET_BINDER);
        }
        return this.myStatus;
    }

    public String getStatus() {
        return (String)this.getStatusElement().getValue();
    }

    public DiagnosticOrder setStatus(BoundCodeDt<DiagnosticOrderStatusEnum> theValue) {
        this.myStatus = theValue;
        return this;
    }

    public DiagnosticOrder setStatus(DiagnosticOrderStatusEnum theValue) {
        this.setStatus((BoundCodeDt<DiagnosticOrderStatusEnum>)new BoundCodeDt(DiagnosticOrderStatusEnum.VALUESET_BINDER, (Enum)theValue));
        return this;
    }

    public BoundCodeDt<DiagnosticOrderPriorityEnum> getPriorityElement() {
        if (this.myPriority == null) {
            this.myPriority = new BoundCodeDt(DiagnosticOrderPriorityEnum.VALUESET_BINDER);
        }
        return this.myPriority;
    }

    public String getPriority() {
        return (String)this.getPriorityElement().getValue();
    }

    public DiagnosticOrder setPriority(BoundCodeDt<DiagnosticOrderPriorityEnum> theValue) {
        this.myPriority = theValue;
        return this;
    }

    public DiagnosticOrder setPriority(DiagnosticOrderPriorityEnum theValue) {
        this.setPriority((BoundCodeDt<DiagnosticOrderPriorityEnum>)new BoundCodeDt(DiagnosticOrderPriorityEnum.VALUESET_BINDER, (Enum)theValue));
        return this;
    }

    public List<Event> getEvent() {
        if (this.myEvent == null) {
            this.myEvent = new ArrayList<Event>();
        }
        return this.myEvent;
    }

    public DiagnosticOrder setEvent(List<Event> theValue) {
        this.myEvent = theValue;
        return this;
    }

    public Event addEvent() {
        Event newType = new Event();
        this.getEvent().add(newType);
        return newType;
    }

    public DiagnosticOrder addEvent(Event theValue) {
        if (theValue == null) {
            throw new NullPointerException("theValue must not be null");
        }
        this.getEvent().add(theValue);
        return this;
    }

    public Event getEventFirstRep() {
        if (this.getEvent().isEmpty()) {
            return this.addEvent();
        }
        return this.getEvent().get(0);
    }

    public List<Item> getItem() {
        if (this.myItem == null) {
            this.myItem = new ArrayList<Item>();
        }
        return this.myItem;
    }

    public DiagnosticOrder setItem(List<Item> theValue) {
        this.myItem = theValue;
        return this;
    }

    public Item addItem() {
        Item newType = new Item();
        this.getItem().add(newType);
        return newType;
    }

    public DiagnosticOrder addItem(Item theValue) {
        if (theValue == null) {
            throw new NullPointerException("theValue must not be null");
        }
        this.getItem().add(theValue);
        return this;
    }

    public Item getItemFirstRep() {
        if (this.getItem().isEmpty()) {
            return this.addItem();
        }
        return this.getItem().get(0);
    }

    public List<AnnotationDt> getNote() {
        if (this.myNote == null) {
            this.myNote = new ArrayList<AnnotationDt>();
        }
        return this.myNote;
    }

    public DiagnosticOrder setNote(List<AnnotationDt> theValue) {
        this.myNote = theValue;
        return this;
    }

    public AnnotationDt addNote() {
        AnnotationDt newType = new AnnotationDt();
        this.getNote().add(newType);
        return newType;
    }

    public DiagnosticOrder addNote(AnnotationDt theValue) {
        if (theValue == null) {
            throw new NullPointerException("theValue must not be null");
        }
        this.getNote().add(theValue);
        return this;
    }

    public AnnotationDt getNoteFirstRep() {
        if (this.getNote().isEmpty()) {
            return this.addNote();
        }
        return this.getNote().get(0);
    }

    public String getResourceName() {
        return "DiagnosticOrder";
    }

    public FhirVersionEnum getStructureFhirVersionEnum() {
        return FhirVersionEnum.DSTU2;
    }

    @Block
    public static class Event
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="status", type={CodeDt.class}, order=0, min=1, max=1, summary=true, modifier=false)
        @Description(shortDefinition="", formalDefinition="The status for the event")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/diagnostic-order-status")
        private BoundCodeDt<DiagnosticOrderStatusEnum> myStatus;
        @Child(name="description", type={CodeableConceptDt.class}, order=1, min=0, max=1, summary=true, modifier=false)
        @Description(shortDefinition="", formalDefinition="Additional information about the event that occurred - e.g. if the status remained unchanged")
        private CodeableConceptDt myDescription;
        @Child(name="dateTime", type={DateTimeDt.class}, order=2, min=1, max=1, summary=true, modifier=false)
        @Description(shortDefinition="", formalDefinition="The date/time at which the event occurred")
        private DateTimeDt myDateTime;
        @Child(name="actor", order=3, min=0, max=1, summary=false, modifier=false, type={Practitioner.class, Device.class})
        @Description(shortDefinition="", formalDefinition="The person responsible for performing or recording the action")
        private ResourceReferenceDt myActor;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.myStatus, this.myDescription, this.myDateTime, this.myActor});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myStatus, this.myDescription, this.myDateTime, this.myActor});
        }

        public BoundCodeDt<DiagnosticOrderStatusEnum> getStatusElement() {
            if (this.myStatus == null) {
                this.myStatus = new BoundCodeDt(DiagnosticOrderStatusEnum.VALUESET_BINDER);
            }
            return this.myStatus;
        }

        public String getStatus() {
            return (String)this.getStatusElement().getValue();
        }

        public Event setStatus(BoundCodeDt<DiagnosticOrderStatusEnum> theValue) {
            this.myStatus = theValue;
            return this;
        }

        public Event setStatus(DiagnosticOrderStatusEnum theValue) {
            this.setStatus((BoundCodeDt<DiagnosticOrderStatusEnum>)new BoundCodeDt(DiagnosticOrderStatusEnum.VALUESET_BINDER, (Enum)theValue));
            return this;
        }

        public CodeableConceptDt getDescription() {
            if (this.myDescription == null) {
                this.myDescription = new CodeableConceptDt();
            }
            return this.myDescription;
        }

        public Event setDescription(CodeableConceptDt theValue) {
            this.myDescription = theValue;
            return this;
        }

        public DateTimeDt getDateTimeElement() {
            if (this.myDateTime == null) {
                this.myDateTime = new DateTimeDt();
            }
            return this.myDateTime;
        }

        public Date getDateTime() {
            return (Date)this.getDateTimeElement().getValue();
        }

        public Event setDateTime(DateTimeDt theValue) {
            this.myDateTime = theValue;
            return this;
        }

        public Event setDateTimeWithSecondsPrecision(Date theDate) {
            this.myDateTime = new DateTimeDt(theDate);
            return this;
        }

        public Event setDateTime(Date theDate, TemporalPrecisionEnum thePrecision) {
            this.myDateTime = new DateTimeDt(theDate, thePrecision);
            return this;
        }

        public ResourceReferenceDt getActor() {
            if (this.myActor == null) {
                this.myActor = new ResourceReferenceDt();
            }
            return this.myActor;
        }

        public Event setActor(ResourceReferenceDt theValue) {
            this.myActor = theValue;
            return this;
        }
    }

    @Block
    public static class Item
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="code", type={CodeableConceptDt.class}, order=0, min=1, max=1, summary=true, modifier=false)
        @Description(shortDefinition="", formalDefinition="A code that identifies a particular diagnostic investigation, or panel of investigations, that have been requested")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/valueset-diagnostic-requests")
        private CodeableConceptDt myCode;
        @Child(name="specimen", order=1, min=0, max=-1, summary=false, modifier=false, type={Specimen.class})
        @Description(shortDefinition="", formalDefinition="If the item is related to a specific specimen")
        private List<ResourceReferenceDt> mySpecimen;
        @Child(name="bodySite", type={CodeableConceptDt.class}, order=2, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="Anatomical location where the request test should be performed.  This is the target site.")
        private CodeableConceptDt myBodySite;
        @Child(name="status", type={CodeDt.class}, order=3, min=0, max=1, summary=true, modifier=false)
        @Description(shortDefinition="", formalDefinition="The status of this individual item within the order")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/diagnostic-order-status")
        private BoundCodeDt<DiagnosticOrderStatusEnum> myStatus;
        @Child(name="event", type={Event.class}, order=4, min=0, max=-1, summary=true, modifier=false)
        @Description(shortDefinition="", formalDefinition="A summary of the events of interest that have occurred as this item of the request is processed")
        private List<Event> myEvent;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.myCode, this.mySpecimen, this.myBodySite, this.myStatus, this.myEvent});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myCode, this.mySpecimen, this.myBodySite, this.myStatus, this.myEvent});
        }

        public CodeableConceptDt getCode() {
            if (this.myCode == null) {
                this.myCode = new CodeableConceptDt();
            }
            return this.myCode;
        }

        public Item setCode(CodeableConceptDt theValue) {
            this.myCode = theValue;
            return this;
        }

        public List<ResourceReferenceDt> getSpecimen() {
            if (this.mySpecimen == null) {
                this.mySpecimen = new ArrayList<ResourceReferenceDt>();
            }
            return this.mySpecimen;
        }

        public Item setSpecimen(List<ResourceReferenceDt> theValue) {
            this.mySpecimen = theValue;
            return this;
        }

        public ResourceReferenceDt addSpecimen() {
            ResourceReferenceDt newType = new ResourceReferenceDt();
            this.getSpecimen().add(newType);
            return newType;
        }

        public CodeableConceptDt getBodySite() {
            if (this.myBodySite == null) {
                this.myBodySite = new CodeableConceptDt();
            }
            return this.myBodySite;
        }

        public Item setBodySite(CodeableConceptDt theValue) {
            this.myBodySite = theValue;
            return this;
        }

        public BoundCodeDt<DiagnosticOrderStatusEnum> getStatusElement() {
            if (this.myStatus == null) {
                this.myStatus = new BoundCodeDt(DiagnosticOrderStatusEnum.VALUESET_BINDER);
            }
            return this.myStatus;
        }

        public String getStatus() {
            return (String)this.getStatusElement().getValue();
        }

        public Item setStatus(BoundCodeDt<DiagnosticOrderStatusEnum> theValue) {
            this.myStatus = theValue;
            return this;
        }

        public Item setStatus(DiagnosticOrderStatusEnum theValue) {
            this.setStatus((BoundCodeDt<DiagnosticOrderStatusEnum>)new BoundCodeDt(DiagnosticOrderStatusEnum.VALUESET_BINDER, (Enum)theValue));
            return this;
        }

        public List<Event> getEvent() {
            if (this.myEvent == null) {
                this.myEvent = new ArrayList<Event>();
            }
            return this.myEvent;
        }

        public Item setEvent(List<Event> theValue) {
            this.myEvent = theValue;
            return this;
        }

        public Event addEvent() {
            Event newType = new Event();
            this.getEvent().add(newType);
            return newType;
        }

        public Item addEvent(Event theValue) {
            if (theValue == null) {
                throw new NullPointerException("theValue must not be null");
            }
            this.getEvent().add(theValue);
            return this;
        }

        public Event getEventFirstRep() {
            if (this.getEvent().isEmpty()) {
                return this.addEvent();
            }
            return this.getEvent().get(0);
        }
    }
}

