/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.model.dstu2.resource;

import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.model.api.BaseIdentifiableElement;
import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.IResource;
import ca.uhn.fhir.model.api.IResourceBlock;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.TemporalPrecisionEnum;
import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.model.dstu2.composite.SignatureDt;
import ca.uhn.fhir.model.dstu2.resource.BaseResource;
import ca.uhn.fhir.model.dstu2.resource.Composition;
import ca.uhn.fhir.model.dstu2.resource.MessageHeader;
import ca.uhn.fhir.model.dstu2.valueset.BundleTypeEnum;
import ca.uhn.fhir.model.dstu2.valueset.HTTPVerbEnum;
import ca.uhn.fhir.model.dstu2.valueset.SearchEntryModeEnum;
import ca.uhn.fhir.model.primitive.BoundCodeDt;
import ca.uhn.fhir.model.primitive.CodeDt;
import ca.uhn.fhir.model.primitive.DecimalDt;
import ca.uhn.fhir.model.primitive.InstantDt;
import ca.uhn.fhir.model.primitive.StringDt;
import ca.uhn.fhir.model.primitive.UnsignedIntDt;
import ca.uhn.fhir.model.primitive.UriDt;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.Validate;
import org.hl7.fhir.instance.model.api.IBaseBundle;

@ResourceDef(name="Bundle", profile="http://hl7.org/fhir/profiles/Bundle", id="bundle")
public class Bundle
extends BaseResource
implements IResource,
IBaseBundle {
    @SearchParamDefinition(name="type", path="Bundle.type", description="", type="token")
    public static final String SP_TYPE = "type";
    public static final TokenClientParam TYPE = new TokenClientParam("type");
    @SearchParamDefinition(name="message", path="Bundle.entry.resource(0)", description="The first resource in the bundle, if the bundle type is \"message\" - this is a message header, and this parameter provides access to search its contents", type="reference", target={MessageHeader.class})
    public static final String SP_MESSAGE = "message";
    public static final ReferenceClientParam MESSAGE = new ReferenceClientParam("message");
    @SearchParamDefinition(name="composition", path="Bundle.entry.resource(0)", description="The first resource in the bundle, if the bundle type is \"document\" - this is a composition, and this parameter provides access to searches its contents", type="reference", target={Composition.class})
    public static final String SP_COMPOSITION = "composition";
    public static final ReferenceClientParam COMPOSITION = new ReferenceClientParam("composition");
    public static final Include INCLUDE_COMPOSITION = new Include("Bundle:composition");
    public static final Include INCLUDE_MESSAGE = new Include("Bundle:message");
    @Child(name="type", type={CodeDt.class}, order=0, min=1, max=1, summary=true, modifier=false)
    @Description(shortDefinition="", formalDefinition="Indicates the purpose of this bundle- how it was intended to be used")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/bundle-type")
    private BoundCodeDt<BundleTypeEnum> myType;
    @Child(name="total", type={UnsignedIntDt.class}, order=1, min=0, max=1, summary=true, modifier=false)
    @Description(shortDefinition="", formalDefinition="If a set of search matches, this is the total number of matches for the search (as opposed to the number of results in this bundle)")
    private UnsignedIntDt myTotal;
    @Child(name="link", order=2, min=0, max=-1, summary=true, modifier=false)
    @Description(shortDefinition="", formalDefinition="A series of links that provide context to this bundle")
    private List<Link> myLink;
    @Child(name="entry", order=3, min=0, max=-1, summary=true, modifier=false)
    @Description(shortDefinition="", formalDefinition="An entry in a bundle resource - will either contain a resource, or information about a resource (transactions and history only)")
    private List<Entry> myEntry;
    @Child(name="signature", type={SignatureDt.class}, order=4, min=0, max=1, summary=true, modifier=false)
    @Description(shortDefinition="", formalDefinition="Digital Signature - base64 encoded. XML DigSIg or a JWT")
    private SignatureDt mySignature;

    public boolean isEmpty() {
        return super.isBaseEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.myType, this.myTotal, this.myLink, this.myEntry, this.mySignature});
    }

    public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
        return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myType, this.myTotal, this.myLink, this.myEntry, this.mySignature});
    }

    public BoundCodeDt<BundleTypeEnum> getTypeElement() {
        if (this.myType == null) {
            this.myType = new BoundCodeDt(BundleTypeEnum.VALUESET_BINDER);
        }
        return this.myType;
    }

    public String getType() {
        return (String)this.getTypeElement().getValue();
    }

    public Bundle setType(BoundCodeDt<BundleTypeEnum> theValue) {
        this.myType = theValue;
        return this;
    }

    public Bundle setType(BundleTypeEnum theValue) {
        this.setType((BoundCodeDt<BundleTypeEnum>)new BoundCodeDt(BundleTypeEnum.VALUESET_BINDER, (Enum)theValue));
        return this;
    }

    public UnsignedIntDt getTotalElement() {
        if (this.myTotal == null) {
            this.myTotal = new UnsignedIntDt();
        }
        return this.myTotal;
    }

    public Integer getTotal() {
        return (Integer)this.getTotalElement().getValue();
    }

    public Bundle setTotal(UnsignedIntDt theValue) {
        this.myTotal = theValue;
        return this;
    }

    public Bundle setTotal(int theInteger) {
        this.myTotal = new UnsignedIntDt(theInteger);
        return this;
    }

    public List<Link> getLink() {
        if (this.myLink == null) {
            this.myLink = new ArrayList<Link>();
        }
        return this.myLink;
    }

    public Bundle setLink(List<Link> theValue) {
        this.myLink = theValue;
        return this;
    }

    public Link addLink() {
        Link newType = new Link();
        this.getLink().add(newType);
        return newType;
    }

    public Bundle addLink(Link theValue) {
        if (theValue == null) {
            throw new NullPointerException("theValue must not be null");
        }
        this.getLink().add(theValue);
        return this;
    }

    public Link getLinkFirstRep() {
        if (this.getLink().isEmpty()) {
            return this.addLink();
        }
        return this.getLink().get(0);
    }

    public List<Entry> getEntry() {
        if (this.myEntry == null) {
            this.myEntry = new ArrayList<Entry>();
        }
        return this.myEntry;
    }

    public Bundle setEntry(List<Entry> theValue) {
        this.myEntry = theValue;
        return this;
    }

    public Entry addEntry() {
        Entry newType = new Entry();
        this.getEntry().add(newType);
        return newType;
    }

    public Bundle addEntry(Entry theValue) {
        if (theValue == null) {
            throw new NullPointerException("theValue must not be null");
        }
        this.getEntry().add(theValue);
        return this;
    }

    public Entry getEntryFirstRep() {
        if (this.getEntry().isEmpty()) {
            return this.addEntry();
        }
        return this.getEntry().get(0);
    }

    public SignatureDt getSignature() {
        if (this.mySignature == null) {
            this.mySignature = new SignatureDt();
        }
        return this.mySignature;
    }

    public Bundle setSignature(SignatureDt theValue) {
        this.mySignature = theValue;
        return this;
    }

    public String getResourceName() {
        return "Bundle";
    }

    public FhirVersionEnum getStructureFhirVersionEnum() {
        return FhirVersionEnum.DSTU2;
    }

    public Link getLink(String theRelation) {
        Validate.notBlank((CharSequence)theRelation, (String)"theRelation may not be null or empty", (Object[])new Object[0]);
        for (Link next : this.getLink()) {
            if (!theRelation.equals(next.getRelation())) continue;
            return next;
        }
        return null;
    }

    public Link getLinkOrCreate(String theRelation) {
        Validate.notBlank((CharSequence)theRelation, (String)"theRelation may not be null or empty", (Object[])new Object[0]);
        for (Link next : this.getLink()) {
            if (!theRelation.equals(next.getRelation())) continue;
            return next;
        }
        Link retVal = new Link();
        retVal.setRelation(theRelation);
        this.getLink().add(retVal);
        return retVal;
    }

    @Block
    public static class Link
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="relation", type={StringDt.class}, order=0, min=1, max=1, summary=true, modifier=false)
        @Description(shortDefinition="", formalDefinition="A name which details the functional use for this link - see [[http://www.iana.org/assignments/link-relations/link-relations.xhtml]]")
        private StringDt myRelation;
        @Child(name="url", type={UriDt.class}, order=1, min=1, max=1, summary=true, modifier=false)
        @Description(shortDefinition="", formalDefinition="The reference details for the link")
        private UriDt myUrl;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.myRelation, this.myUrl});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myRelation, this.myUrl});
        }

        public StringDt getRelationElement() {
            if (this.myRelation == null) {
                this.myRelation = new StringDt();
            }
            return this.myRelation;
        }

        public String getRelation() {
            return (String)this.getRelationElement().getValue();
        }

        public Link setRelation(StringDt theValue) {
            this.myRelation = theValue;
            return this;
        }

        public Link setRelation(String theString) {
            this.myRelation = new StringDt(theString);
            return this;
        }

        public UriDt getUrlElement() {
            if (this.myUrl == null) {
                this.myUrl = new UriDt();
            }
            return this.myUrl;
        }

        public String getUrl() {
            return (String)this.getUrlElement().getValue();
        }

        public Link setUrl(UriDt theValue) {
            this.myUrl = theValue;
            return this;
        }

        public Link setUrl(String theUri) {
            this.myUrl = new UriDt(theUri);
            return this;
        }
    }

    @Block
    public static class Entry
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="link", type={Link.class}, order=0, min=0, max=-1, summary=true, modifier=false)
        @Description(shortDefinition="", formalDefinition="A series of links that provide context to this entry")
        private List<Link> myLink;
        @Child(name="fullUrl", type={UriDt.class}, order=1, min=0, max=1, summary=true, modifier=false)
        @Description(shortDefinition="", formalDefinition="The Absolute URL for the resource. This must be provided for all resources. The fullUrl SHALL not disagree with the id in the resource. The fullUrl is a version independent reference to the resource")
        private UriDt myFullUrl;
        @Child(name="resource", type={IResource.class}, order=2, min=0, max=1, summary=true, modifier=false)
        @Description(shortDefinition="", formalDefinition="The Resources for the entry")
        private IResource myResource;
        @Child(name="search", order=3, min=0, max=1, summary=true, modifier=false)
        @Description(shortDefinition="", formalDefinition="Information about the search process that lead to the creation of this entry")
        private EntrySearch mySearch;
        @Child(name="request", order=4, min=0, max=1, summary=true, modifier=false)
        @Description(shortDefinition="", formalDefinition="Additional information about how this entry should be processed as part of a transaction")
        private EntryRequest myRequest;
        @Child(name="response", order=5, min=0, max=1, summary=true, modifier=false)
        @Description(shortDefinition="", formalDefinition="Additional information about how this entry should be processed as part of a transaction")
        private EntryResponse myResponse;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.myLink, this.myFullUrl, this.myResource, this.mySearch, this.myRequest, this.myResponse});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myLink, this.myFullUrl, this.myResource, this.mySearch, this.myRequest, this.myResponse});
        }

        public List<Link> getLink() {
            if (this.myLink == null) {
                this.myLink = new ArrayList<Link>();
            }
            return this.myLink;
        }

        public Entry setLink(List<Link> theValue) {
            this.myLink = theValue;
            return this;
        }

        public Link addLink() {
            Link newType = new Link();
            this.getLink().add(newType);
            return newType;
        }

        public Entry addLink(Link theValue) {
            if (theValue == null) {
                throw new NullPointerException("theValue must not be null");
            }
            this.getLink().add(theValue);
            return this;
        }

        public Link getLinkFirstRep() {
            if (this.getLink().isEmpty()) {
                return this.addLink();
            }
            return this.getLink().get(0);
        }

        public UriDt getFullUrlElement() {
            if (this.myFullUrl == null) {
                this.myFullUrl = new UriDt();
            }
            return this.myFullUrl;
        }

        public String getFullUrl() {
            return (String)this.getFullUrlElement().getValue();
        }

        public Entry setFullUrl(UriDt theValue) {
            this.myFullUrl = theValue;
            return this;
        }

        public Entry setFullUrl(String theUri) {
            this.myFullUrl = new UriDt(theUri);
            return this;
        }

        public IResource getResource() {
            return this.myResource;
        }

        public Entry setResource(IResource theValue) {
            this.myResource = theValue;
            return this;
        }

        public EntrySearch getSearch() {
            if (this.mySearch == null) {
                this.mySearch = new EntrySearch();
            }
            return this.mySearch;
        }

        public Entry setSearch(EntrySearch theValue) {
            this.mySearch = theValue;
            return this;
        }

        public EntryRequest getRequest() {
            if (this.myRequest == null) {
                this.myRequest = new EntryRequest();
            }
            return this.myRequest;
        }

        public Entry setRequest(EntryRequest theValue) {
            this.myRequest = theValue;
            return this;
        }

        public EntryResponse getResponse() {
            if (this.myResponse == null) {
                this.myResponse = new EntryResponse();
            }
            return this.myResponse;
        }

        public Entry setResponse(EntryResponse theValue) {
            this.myResponse = theValue;
            return this;
        }
    }

    @Block
    public static class EntryResponse
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="status", type={StringDt.class}, order=0, min=1, max=1, summary=true, modifier=false)
        @Description(shortDefinition="", formalDefinition="The status code returned by processing this entry")
        private StringDt myStatus;
        @Child(name="location", type={UriDt.class}, order=1, min=0, max=1, summary=true, modifier=false)
        @Description(shortDefinition="", formalDefinition="The location header created by processing this operation")
        private UriDt myLocation;
        @Child(name="etag", type={StringDt.class}, order=2, min=0, max=1, summary=true, modifier=false)
        @Description(shortDefinition="", formalDefinition="The etag for the resource, it the operation for the entry produced a versioned resource")
        private StringDt myEtag;
        @Child(name="lastModified", type={InstantDt.class}, order=3, min=0, max=1, summary=true, modifier=false)
        @Description(shortDefinition="", formalDefinition="The date/time that the resource was modified on the server")
        private InstantDt myLastModified;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.myStatus, this.myLocation, this.myEtag, this.myLastModified});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myStatus, this.myLocation, this.myEtag, this.myLastModified});
        }

        public StringDt getStatusElement() {
            if (this.myStatus == null) {
                this.myStatus = new StringDt();
            }
            return this.myStatus;
        }

        public String getStatus() {
            return (String)this.getStatusElement().getValue();
        }

        public EntryResponse setStatus(StringDt theValue) {
            this.myStatus = theValue;
            return this;
        }

        public EntryResponse setStatus(String theString) {
            this.myStatus = new StringDt(theString);
            return this;
        }

        public UriDt getLocationElement() {
            if (this.myLocation == null) {
                this.myLocation = new UriDt();
            }
            return this.myLocation;
        }

        public String getLocation() {
            return (String)this.getLocationElement().getValue();
        }

        public EntryResponse setLocation(UriDt theValue) {
            this.myLocation = theValue;
            return this;
        }

        public EntryResponse setLocation(String theUri) {
            this.myLocation = new UriDt(theUri);
            return this;
        }

        public StringDt getEtagElement() {
            if (this.myEtag == null) {
                this.myEtag = new StringDt();
            }
            return this.myEtag;
        }

        public String getEtag() {
            return (String)this.getEtagElement().getValue();
        }

        public EntryResponse setEtag(StringDt theValue) {
            this.myEtag = theValue;
            return this;
        }

        public EntryResponse setEtag(String theString) {
            this.myEtag = new StringDt(theString);
            return this;
        }

        public InstantDt getLastModifiedElement() {
            if (this.myLastModified == null) {
                this.myLastModified = new InstantDt();
            }
            return this.myLastModified;
        }

        public Date getLastModified() {
            return (Date)this.getLastModifiedElement().getValue();
        }

        public EntryResponse setLastModified(InstantDt theValue) {
            this.myLastModified = theValue;
            return this;
        }

        public EntryResponse setLastModifiedWithMillisPrecision(Date theDate) {
            this.myLastModified = new InstantDt(theDate);
            return this;
        }

        public EntryResponse setLastModified(Date theDate, TemporalPrecisionEnum thePrecision) {
            this.myLastModified = new InstantDt(theDate, thePrecision);
            return this;
        }
    }

    @Block
    public static class EntryRequest
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="method", type={CodeDt.class}, order=0, min=1, max=1, summary=true, modifier=false)
        @Description(shortDefinition="", formalDefinition="The HTTP verb for this entry in either a update history, or a transaction/ transaction response")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/http-verb")
        private BoundCodeDt<HTTPVerbEnum> myMethod;
        @Child(name="url", type={UriDt.class}, order=1, min=1, max=1, summary=true, modifier=false)
        @Description(shortDefinition="", formalDefinition="The URL for this entry, relative to the root (the address to which the request is posted)")
        private UriDt myUrl;
        @Child(name="ifNoneMatch", type={StringDt.class}, order=2, min=0, max=1, summary=true, modifier=false)
        @Description(shortDefinition="", formalDefinition="If the ETag values match, return a 304 Not modified status. See the API documentation for [\"Conditional Read\"](http.html#cread)")
        private StringDt myIfNoneMatch;
        @Child(name="ifModifiedSince", type={InstantDt.class}, order=3, min=0, max=1, summary=true, modifier=false)
        @Description(shortDefinition="", formalDefinition="Only perform the operation if the last updated date matches. See the API documentation for [\"Conditional Read\"](http.html#cread)")
        private InstantDt myIfModifiedSince;
        @Child(name="ifMatch", type={StringDt.class}, order=4, min=0, max=1, summary=true, modifier=false)
        @Description(shortDefinition="", formalDefinition="Only perform the operation if the Etag value matches. For more information, see the API section [\"Managing Resource Contention\"](http.html#concurrency)")
        private StringDt myIfMatch;
        @Child(name="ifNoneExist", type={StringDt.class}, order=5, min=0, max=1, summary=true, modifier=false)
        @Description(shortDefinition="", formalDefinition="Instruct the server not to perform the create if a specified resource already exists. For further information, see the API documentation for [\"Conditional Create\"](http.html#ccreate). This is just the query portion of the URL - what follows the \"?\" (not including the \"?\")")
        private StringDt myIfNoneExist;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.myMethod, this.myUrl, this.myIfNoneMatch, this.myIfModifiedSince, this.myIfMatch, this.myIfNoneExist});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myMethod, this.myUrl, this.myIfNoneMatch, this.myIfModifiedSince, this.myIfMatch, this.myIfNoneExist});
        }

        public BoundCodeDt<HTTPVerbEnum> getMethodElement() {
            if (this.myMethod == null) {
                this.myMethod = new BoundCodeDt(HTTPVerbEnum.VALUESET_BINDER);
            }
            return this.myMethod;
        }

        public String getMethod() {
            return (String)this.getMethodElement().getValue();
        }

        public EntryRequest setMethod(BoundCodeDt<HTTPVerbEnum> theValue) {
            this.myMethod = theValue;
            return this;
        }

        public EntryRequest setMethod(HTTPVerbEnum theValue) {
            this.setMethod((BoundCodeDt<HTTPVerbEnum>)new BoundCodeDt(HTTPVerbEnum.VALUESET_BINDER, (Enum)theValue));
            return this;
        }

        public UriDt getUrlElement() {
            if (this.myUrl == null) {
                this.myUrl = new UriDt();
            }
            return this.myUrl;
        }

        public String getUrl() {
            return (String)this.getUrlElement().getValue();
        }

        public EntryRequest setUrl(UriDt theValue) {
            this.myUrl = theValue;
            return this;
        }

        public EntryRequest setUrl(String theUri) {
            this.myUrl = new UriDt(theUri);
            return this;
        }

        public StringDt getIfNoneMatchElement() {
            if (this.myIfNoneMatch == null) {
                this.myIfNoneMatch = new StringDt();
            }
            return this.myIfNoneMatch;
        }

        public String getIfNoneMatch() {
            return (String)this.getIfNoneMatchElement().getValue();
        }

        public EntryRequest setIfNoneMatch(StringDt theValue) {
            this.myIfNoneMatch = theValue;
            return this;
        }

        public EntryRequest setIfNoneMatch(String theString) {
            this.myIfNoneMatch = new StringDt(theString);
            return this;
        }

        public InstantDt getIfModifiedSinceElement() {
            if (this.myIfModifiedSince == null) {
                this.myIfModifiedSince = new InstantDt();
            }
            return this.myIfModifiedSince;
        }

        public Date getIfModifiedSince() {
            return (Date)this.getIfModifiedSinceElement().getValue();
        }

        public EntryRequest setIfModifiedSince(InstantDt theValue) {
            this.myIfModifiedSince = theValue;
            return this;
        }

        public EntryRequest setIfModifiedSinceWithMillisPrecision(Date theDate) {
            this.myIfModifiedSince = new InstantDt(theDate);
            return this;
        }

        public EntryRequest setIfModifiedSince(Date theDate, TemporalPrecisionEnum thePrecision) {
            this.myIfModifiedSince = new InstantDt(theDate, thePrecision);
            return this;
        }

        public StringDt getIfMatchElement() {
            if (this.myIfMatch == null) {
                this.myIfMatch = new StringDt();
            }
            return this.myIfMatch;
        }

        public String getIfMatch() {
            return (String)this.getIfMatchElement().getValue();
        }

        public EntryRequest setIfMatch(StringDt theValue) {
            this.myIfMatch = theValue;
            return this;
        }

        public EntryRequest setIfMatch(String theString) {
            this.myIfMatch = new StringDt(theString);
            return this;
        }

        public StringDt getIfNoneExistElement() {
            if (this.myIfNoneExist == null) {
                this.myIfNoneExist = new StringDt();
            }
            return this.myIfNoneExist;
        }

        public String getIfNoneExist() {
            return (String)this.getIfNoneExistElement().getValue();
        }

        public EntryRequest setIfNoneExist(StringDt theValue) {
            this.myIfNoneExist = theValue;
            return this;
        }

        public EntryRequest setIfNoneExist(String theString) {
            this.myIfNoneExist = new StringDt(theString);
            return this;
        }
    }

    @Block
    public static class EntrySearch
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="mode", type={CodeDt.class}, order=0, min=0, max=1, summary=true, modifier=false)
        @Description(shortDefinition="", formalDefinition="Why this entry is in the result set - whether it's included as a match or because of an _include requirement")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/search-entry-mode")
        private BoundCodeDt<SearchEntryModeEnum> myMode;
        @Child(name="score", type={DecimalDt.class}, order=1, min=0, max=1, summary=true, modifier=false)
        @Description(shortDefinition="", formalDefinition="When searching, the server's search ranking score for the entry")
        private DecimalDt myScore;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.myMode, this.myScore});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myMode, this.myScore});
        }

        public BoundCodeDt<SearchEntryModeEnum> getModeElement() {
            if (this.myMode == null) {
                this.myMode = new BoundCodeDt(SearchEntryModeEnum.VALUESET_BINDER);
            }
            return this.myMode;
        }

        public String getMode() {
            return (String)this.getModeElement().getValue();
        }

        public EntrySearch setMode(BoundCodeDt<SearchEntryModeEnum> theValue) {
            this.myMode = theValue;
            return this;
        }

        public EntrySearch setMode(SearchEntryModeEnum theValue) {
            this.setMode((BoundCodeDt<SearchEntryModeEnum>)new BoundCodeDt(SearchEntryModeEnum.VALUESET_BINDER, (Enum)theValue));
            return this;
        }

        public DecimalDt getScoreElement() {
            if (this.myScore == null) {
                this.myScore = new DecimalDt();
            }
            return this.myScore;
        }

        public BigDecimal getScore() {
            return (BigDecimal)this.getScoreElement().getValue();
        }

        public EntrySearch setScore(DecimalDt theValue) {
            this.myScore = theValue;
            return this;
        }

        public EntrySearch setScore(double theValue) {
            this.myScore = new DecimalDt(theValue);
            return this;
        }

        public EntrySearch setScore(long theValue) {
            this.myScore = new DecimalDt(theValue);
            return this;
        }

        public EntrySearch setScore(BigDecimal theValue) {
            this.myScore = new DecimalDt(theValue);
            return this;
        }
    }
}

