/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.model.dstu2.resource;

import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.model.api.BaseElement;
import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.IResource;
import ca.uhn.fhir.model.api.ResourceMetadataKeyEnum;
import ca.uhn.fhir.model.api.Tag;
import ca.uhn.fhir.model.api.TagList;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.model.base.composite.BaseCodingDt;
import ca.uhn.fhir.model.base.resource.ResourceMetadataMap;
import ca.uhn.fhir.model.dstu2.composite.CodingDt;
import ca.uhn.fhir.model.dstu2.composite.ContainedDt;
import ca.uhn.fhir.model.dstu2.composite.NarrativeDt;
import ca.uhn.fhir.model.primitive.CodeDt;
import ca.uhn.fhir.model.primitive.IdDt;
import ca.uhn.fhir.model.primitive.InstantDt;
import ca.uhn.fhir.rest.gclient.StringClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.hl7.fhir.instance.model.api.IBaseCoding;
import org.hl7.fhir.instance.model.api.IBaseMetaType;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;
import org.hl7.fhir.instance.model.api.IPrimitiveType;

public abstract class BaseResource
extends BaseElement
implements IResource {
    public static final StringClientParam RES_ID = new StringClientParam("_id");
    @SearchParamDefinition(name="_id", path="", description="The ID of the resource", type="string")
    public static final String SP_RES_ID = "_id";
    @Child(name="contained", order=2, min=0, max=1)
    private ContainedDt myContained;
    private IdDt myId;
    @Child(name="language", order=0, min=0, max=1)
    private CodeDt myLanguage;
    private ResourceMetadataMap myResourceMetadata;
    @Child(name="text", order=1, min=0, max=1)
    private NarrativeDt myText;

    public ContainedDt getContained() {
        if (this.myContained == null) {
            this.myContained = new ContainedDt();
        }
        return this.myContained;
    }

    public IdDt getId() {
        if (this.myId == null) {
            this.myId = new IdDt();
        }
        return this.myId;
    }

    public IIdType getIdElement() {
        return this.getId();
    }

    public CodeDt getLanguage() {
        if (this.myLanguage == null) {
            this.myLanguage = new CodeDt();
        }
        return this.myLanguage;
    }

    public IBaseMetaType getMeta() {
        return new IBaseMetaType(){
            private static final long serialVersionUID = 1L;

            public IBaseMetaType addProfile(String theProfile) {
                ArrayList<IdDt> newTagList = new ArrayList<IdDt>();
                List existingTagList = (List)ResourceMetadataKeyEnum.PROFILES.get((IBaseResource)BaseResource.this);
                if (existingTagList != null) {
                    newTagList.addAll(existingTagList);
                }
                ResourceMetadataKeyEnum.PROFILES.put((IBaseResource)BaseResource.this, newTagList);
                IdDt tag = new IdDt(theProfile);
                newTagList.add(tag);
                return this;
            }

            public IBaseCoding addSecurity() {
                ArrayList<CodingDt> tagList = (ArrayList<CodingDt>)ResourceMetadataKeyEnum.SECURITY_LABELS.get((IBaseResource)BaseResource.this);
                if (tagList == null) {
                    tagList = new ArrayList<CodingDt>();
                    ResourceMetadataKeyEnum.SECURITY_LABELS.put((IBaseResource)BaseResource.this, tagList);
                }
                CodingDt tag = new CodingDt();
                tagList.add(tag);
                return tag;
            }

            public IBaseCoding addTag() {
                TagList tagList = (TagList)ResourceMetadataKeyEnum.TAG_LIST.get((IBaseResource)BaseResource.this);
                if (tagList == null) {
                    tagList = new TagList();
                    ResourceMetadataKeyEnum.TAG_LIST.put((IBaseResource)BaseResource.this, (Object)tagList);
                }
                Tag tag = new Tag();
                tagList.add(tag);
                return tag;
            }

            public List<String> getFormatCommentsPost() {
                return Collections.emptyList();
            }

            public Object getUserData(String theName) {
                throw new UnsupportedOperationException(Msg.code((int)582));
            }

            public void setUserData(String theName, Object theValue) {
                throw new UnsupportedOperationException(Msg.code((int)583));
            }

            public List<String> getFormatCommentsPre() {
                return Collections.emptyList();
            }

            public Date getLastUpdated() {
                InstantDt lu = (InstantDt)ResourceMetadataKeyEnum.UPDATED.get((IBaseResource)BaseResource.this);
                if (lu != null) {
                    return (Date)lu.getValue();
                }
                return null;
            }

            public List<? extends IPrimitiveType<String>> getProfile() {
                ArrayList<IdDt> retVal = new ArrayList<IdDt>();
                List profilesList = (List)ResourceMetadataKeyEnum.PROFILES.get((IBaseResource)BaseResource.this);
                if (profilesList == null) {
                    return Collections.emptyList();
                }
                for (IdDt next : profilesList) {
                    retVal.add(next);
                }
                return retVal;
            }

            public List<? extends IBaseCoding> getSecurity() {
                ArrayList<CodingDt> retVal = new ArrayList<CodingDt>();
                List labelsList = (List)ResourceMetadataKeyEnum.SECURITY_LABELS.get((IBaseResource)BaseResource.this);
                if (labelsList == null) {
                    return Collections.emptyList();
                }
                for (BaseCodingDt next : labelsList) {
                    CodingDt c = new CodingDt((String)next.getSystemElement().getValue(), (String)next.getCodeElement().getValue());
                    c.setDisplay((String)next.getDisplayElement().getValue());
                    c.setUserSelected(next.getUserSelectedElement());
                    c.setVersion(next.getVersionElement());
                    retVal.add(c);
                }
                return retVal;
            }

            public IBaseCoding getSecurity(String theSystem, String theCode) {
                for (IBaseCoding iBaseCoding : this.getSecurity()) {
                    if (!theSystem.equals(iBaseCoding.getSystem()) || !theCode.equals(iBaseCoding.getCode())) continue;
                    return iBaseCoding;
                }
                return null;
            }

            public List<? extends IBaseCoding> getTag() {
                ArrayList<Tag> retVal = new ArrayList<Tag>();
                TagList tagList = (TagList)ResourceMetadataKeyEnum.TAG_LIST.get((IBaseResource)BaseResource.this);
                if (tagList == null) {
                    return Collections.emptyList();
                }
                for (Tag next : tagList) {
                    retVal.add(next);
                }
                return retVal;
            }

            public IBaseCoding getTag(String theSystem, String theCode) {
                for (IBaseCoding iBaseCoding : this.getTag()) {
                    if (!iBaseCoding.getSystem().equals(theSystem) || !iBaseCoding.getCode().equals(theCode)) continue;
                    return iBaseCoding;
                }
                return null;
            }

            public String getVersionId() {
                return BaseResource.this.getId().getVersionIdPart();
            }

            public boolean hasFormatComment() {
                return false;
            }

            public boolean isEmpty() {
                return BaseResource.this.getResourceMetadata().isEmpty();
            }

            public IBaseMetaType setLastUpdated(Date theHeaderDateValue) {
                if (theHeaderDateValue == null) {
                    BaseResource.this.getResourceMetadata().remove((Object)ResourceMetadataKeyEnum.UPDATED);
                } else {
                    ResourceMetadataKeyEnum.UPDATED.put((IBaseResource)BaseResource.this, (Object)new InstantDt(theHeaderDateValue));
                }
                return this;
            }

            public IBaseMetaType setVersionId(String theVersionId) {
                BaseResource.this.setId(BaseResource.this.getId().withVersion(theVersionId));
                return this;
            }
        };
    }

    public ResourceMetadataMap getResourceMetadata() {
        if (this.myResourceMetadata == null) {
            this.myResourceMetadata = new ResourceMetadataMap();
        }
        return this.myResourceMetadata;
    }

    public NarrativeDt getText() {
        if (this.myText == null) {
            this.myText = new NarrativeDt();
        }
        return this.myText;
    }

    protected boolean isBaseEmpty() {
        return super.isBaseEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.myLanguage, this.myText, this.myId});
    }

    public void setContained(ContainedDt theContained) {
        this.myContained = theContained;
    }

    public void setId(IdDt theId) {
        this.myId = theId;
    }

    public BaseResource setId(IIdType theId) {
        this.myId = theId instanceof IdDt ? (IdDt)theId : (theId != null ? new IdDt(theId.getValue()) : null);
        return this;
    }

    public BaseResource setId(String theId) {
        this.myId = theId == null ? null : new IdDt(theId);
        return this;
    }

    public void setLanguage(CodeDt theLanguage) {
        this.myLanguage = theLanguage;
    }

    public void setResourceMetadata(ResourceMetadataMap theMap) {
        Validate.notNull((Object)theMap, (String)"The Map must not be null", (Object[])new Object[0]);
        this.myResourceMetadata = theMap;
    }

    public void setText(NarrativeDt theText) {
        this.myText = theText;
    }

    public String toString() {
        ToStringBuilder b = new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE);
        b.append("id", (Object)this.getId().toUnqualified());
        return b.toString();
    }
}

