/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.model.dstu2.resource;

import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.IResource;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.model.dstu2.composite.CodingDt;
import ca.uhn.fhir.model.dstu2.composite.IdentifierDt;
import ca.uhn.fhir.model.dstu2.composite.PeriodDt;
import ca.uhn.fhir.model.dstu2.composite.ResourceReferenceDt;
import ca.uhn.fhir.model.dstu2.resource.BaseResource;
import ca.uhn.fhir.model.dstu2.resource.Contract;
import ca.uhn.fhir.model.dstu2.resource.Organization;
import ca.uhn.fhir.model.dstu2.resource.Patient;
import ca.uhn.fhir.model.primitive.PositiveIntDt;
import ca.uhn.fhir.model.primitive.StringDt;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.List;

@ResourceDef(name="Coverage", profile="http://hl7.org/fhir/profiles/Coverage", id="coverage")
public class Coverage
extends BaseResource
implements IResource {
    @SearchParamDefinition(name="issuer", path="Coverage.issuer", description="The identity of the insurer", type="reference")
    public static final String SP_ISSUER = "issuer";
    public static final ReferenceClientParam ISSUER = new ReferenceClientParam("issuer");
    @SearchParamDefinition(name="identifier", path="Coverage.identifier", description="The primary identifier of the insured", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="type", path="Coverage.type", description="The kind of coverage", type="token")
    public static final String SP_TYPE = "type";
    public static final TokenClientParam TYPE = new TokenClientParam("type");
    @SearchParamDefinition(name="plan", path="Coverage.plan", description="A plan or policy identifier", type="token")
    public static final String SP_PLAN = "plan";
    public static final TokenClientParam PLAN = new TokenClientParam("plan");
    @SearchParamDefinition(name="subplan", path="Coverage.subPlan", description="Sub-plan identifier", type="token")
    public static final String SP_SUBPLAN = "subplan";
    public static final TokenClientParam SUBPLAN = new TokenClientParam("subplan");
    @SearchParamDefinition(name="group", path="Coverage.group", description="Group identifier", type="token")
    public static final String SP_GROUP = "group";
    public static final TokenClientParam GROUP = new TokenClientParam("group");
    @SearchParamDefinition(name="dependent", path="Coverage.dependent", description="Dependent number", type="token")
    public static final String SP_DEPENDENT = "dependent";
    public static final TokenClientParam DEPENDENT = new TokenClientParam("dependent");
    @SearchParamDefinition(name="sequence", path="Coverage.sequence", description="Sequence number", type="token")
    public static final String SP_SEQUENCE = "sequence";
    public static final TokenClientParam SEQUENCE = new TokenClientParam("sequence");
    public static final Include INCLUDE_ISSUER = new Include("Coverage:issuer");
    @Child(name="issuer", order=0, min=0, max=1, summary=true, modifier=false, type={Organization.class})
    @Description(shortDefinition="", formalDefinition="The program or plan underwriter or payor.")
    private ResourceReferenceDt myIssuer;
    @Child(name="bin", type={IdentifierDt.class}, order=1, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="Business Identification Number (BIN number) used to identify the routing  of eclaims if the insurer themselves don't have a BIN number for all of their business.")
    private IdentifierDt myBin;
    @Child(name="period", type={PeriodDt.class}, order=2, min=0, max=1, summary=true, modifier=false)
    @Description(shortDefinition="", formalDefinition="Time period during which the coverage is in force. A missing start date indicates the start date isn't known, a missing end date means the coverage is continuing to be in force.")
    private PeriodDt myPeriod;
    @Child(name="type", type={CodingDt.class}, order=3, min=0, max=1, summary=true, modifier=false)
    @Description(shortDefinition="", formalDefinition="The type of coverage: social program, medical plan, accident coverage (workers compensation, auto), group health.")
    private CodingDt myType;
    @Child(name="subscriberId", type={IdentifierDt.class}, order=4, min=0, max=1, summary=true, modifier=false)
    @Description(shortDefinition="", formalDefinition="The id issued to the subscriber.")
    private IdentifierDt mySubscriberId;
    @Child(name="identifier", type={IdentifierDt.class}, order=5, min=0, max=-1, summary=true, modifier=false)
    @Description(shortDefinition="", formalDefinition="The main (and possibly only) identifier for the coverage - often referred to as a Member Id, Subscriber Id, Certificate number or Personal Health Number or Case ID.")
    private List<IdentifierDt> myIdentifier;
    @Child(name="group", type={StringDt.class}, order=6, min=0, max=1, summary=true, modifier=false)
    @Description(shortDefinition="", formalDefinition="Identifies a style or collective of coverage issues by the underwriter, for example may be used to identify a class of coverage or employer group. May also be referred to as a Policy or Group ID.")
    private StringDt myGroup;
    @Child(name="plan", type={StringDt.class}, order=7, min=0, max=1, summary=true, modifier=false)
    @Description(shortDefinition="", formalDefinition="Identifies a style or collective of coverage issues by the underwriter, for example may be used to identify a class of coverage or employer group. May also be referred to as a Policy or Group ID.")
    private StringDt myPlan;
    @Child(name="subPlan", type={StringDt.class}, order=8, min=0, max=1, summary=true, modifier=false)
    @Description(shortDefinition="", formalDefinition="Identifies a sub-style or sub-collective of coverage issues by the underwriter, for example may be used to identify a specific employer group within a class of employers. May be referred to as a Section or Division ID.")
    private StringDt mySubPlan;
    @Child(name="dependent", type={PositiveIntDt.class}, order=9, min=0, max=1, summary=true, modifier=false)
    @Description(shortDefinition="", formalDefinition="A unique identifier for a dependent under the coverage.")
    private PositiveIntDt myDependent;
    @Child(name="sequence", type={PositiveIntDt.class}, order=10, min=0, max=1, summary=true, modifier=false)
    @Description(shortDefinition="", formalDefinition="An optional counter for a particular instance of the identified coverage which increments upon each renewal.")
    private PositiveIntDt mySequence;
    @Child(name="subscriber", order=11, min=0, max=1, summary=false, modifier=true, type={Patient.class})
    @Description(shortDefinition="", formalDefinition="The party who 'owns' the insurance contractual relationship to the policy or to whom the benefit of the policy is due.")
    private ResourceReferenceDt mySubscriber;
    @Child(name="network", type={IdentifierDt.class}, order=12, min=0, max=1, summary=true, modifier=false)
    @Description(shortDefinition="", formalDefinition="The identifier for a community of providers.")
    private IdentifierDt myNetwork;
    @Child(name="contract", order=13, min=0, max=-1, summary=false, modifier=false, type={Contract.class})
    @Description(shortDefinition="", formalDefinition="The policy(s) which constitute this insurance coverage.")
    private List<ResourceReferenceDt> myContract;

    public boolean isEmpty() {
        return super.isBaseEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.myIssuer, this.myBin, this.myPeriod, this.myType, this.mySubscriberId, this.myIdentifier, this.myGroup, this.myPlan, this.mySubPlan, this.myDependent, this.mySequence, this.mySubscriber, this.myNetwork, this.myContract});
    }

    public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
        return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myIssuer, this.myBin, this.myPeriod, this.myType, this.mySubscriberId, this.myIdentifier, this.myGroup, this.myPlan, this.mySubPlan, this.myDependent, this.mySequence, this.mySubscriber, this.myNetwork, this.myContract});
    }

    public ResourceReferenceDt getIssuer() {
        if (this.myIssuer == null) {
            this.myIssuer = new ResourceReferenceDt();
        }
        return this.myIssuer;
    }

    public Coverage setIssuer(ResourceReferenceDt theValue) {
        this.myIssuer = theValue;
        return this;
    }

    public IdentifierDt getBin() {
        if (this.myBin == null) {
            this.myBin = new IdentifierDt();
        }
        return this.myBin;
    }

    public Coverage setBin(IdentifierDt theValue) {
        this.myBin = theValue;
        return this;
    }

    public PeriodDt getPeriod() {
        if (this.myPeriod == null) {
            this.myPeriod = new PeriodDt();
        }
        return this.myPeriod;
    }

    public Coverage setPeriod(PeriodDt theValue) {
        this.myPeriod = theValue;
        return this;
    }

    public CodingDt getType() {
        if (this.myType == null) {
            this.myType = new CodingDt();
        }
        return this.myType;
    }

    public Coverage setType(CodingDt theValue) {
        this.myType = theValue;
        return this;
    }

    public IdentifierDt getSubscriberId() {
        if (this.mySubscriberId == null) {
            this.mySubscriberId = new IdentifierDt();
        }
        return this.mySubscriberId;
    }

    public Coverage setSubscriberId(IdentifierDt theValue) {
        this.mySubscriberId = theValue;
        return this;
    }

    public List<IdentifierDt> getIdentifier() {
        if (this.myIdentifier == null) {
            this.myIdentifier = new ArrayList<IdentifierDt>();
        }
        return this.myIdentifier;
    }

    public Coverage setIdentifier(List<IdentifierDt> theValue) {
        this.myIdentifier = theValue;
        return this;
    }

    public IdentifierDt addIdentifier() {
        IdentifierDt newType = new IdentifierDt();
        this.getIdentifier().add(newType);
        return newType;
    }

    public Coverage addIdentifier(IdentifierDt theValue) {
        if (theValue == null) {
            throw new NullPointerException("theValue must not be null");
        }
        this.getIdentifier().add(theValue);
        return this;
    }

    public IdentifierDt getIdentifierFirstRep() {
        if (this.getIdentifier().isEmpty()) {
            return this.addIdentifier();
        }
        return this.getIdentifier().get(0);
    }

    public StringDt getGroupElement() {
        if (this.myGroup == null) {
            this.myGroup = new StringDt();
        }
        return this.myGroup;
    }

    public String getGroup() {
        return (String)this.getGroupElement().getValue();
    }

    public Coverage setGroup(StringDt theValue) {
        this.myGroup = theValue;
        return this;
    }

    public Coverage setGroup(String theString) {
        this.myGroup = new StringDt(theString);
        return this;
    }

    public StringDt getPlanElement() {
        if (this.myPlan == null) {
            this.myPlan = new StringDt();
        }
        return this.myPlan;
    }

    public String getPlan() {
        return (String)this.getPlanElement().getValue();
    }

    public Coverage setPlan(StringDt theValue) {
        this.myPlan = theValue;
        return this;
    }

    public Coverage setPlan(String theString) {
        this.myPlan = new StringDt(theString);
        return this;
    }

    public StringDt getSubPlanElement() {
        if (this.mySubPlan == null) {
            this.mySubPlan = new StringDt();
        }
        return this.mySubPlan;
    }

    public String getSubPlan() {
        return (String)this.getSubPlanElement().getValue();
    }

    public Coverage setSubPlan(StringDt theValue) {
        this.mySubPlan = theValue;
        return this;
    }

    public Coverage setSubPlan(String theString) {
        this.mySubPlan = new StringDt(theString);
        return this;
    }

    public PositiveIntDt getDependentElement() {
        if (this.myDependent == null) {
            this.myDependent = new PositiveIntDt();
        }
        return this.myDependent;
    }

    public Integer getDependent() {
        return (Integer)this.getDependentElement().getValue();
    }

    public Coverage setDependent(PositiveIntDt theValue) {
        this.myDependent = theValue;
        return this;
    }

    public Coverage setDependent(int theInteger) {
        this.myDependent = new PositiveIntDt(theInteger);
        return this;
    }

    public PositiveIntDt getSequenceElement() {
        if (this.mySequence == null) {
            this.mySequence = new PositiveIntDt();
        }
        return this.mySequence;
    }

    public Integer getSequence() {
        return (Integer)this.getSequenceElement().getValue();
    }

    public Coverage setSequence(PositiveIntDt theValue) {
        this.mySequence = theValue;
        return this;
    }

    public Coverage setSequence(int theInteger) {
        this.mySequence = new PositiveIntDt(theInteger);
        return this;
    }

    public ResourceReferenceDt getSubscriber() {
        if (this.mySubscriber == null) {
            this.mySubscriber = new ResourceReferenceDt();
        }
        return this.mySubscriber;
    }

    public Coverage setSubscriber(ResourceReferenceDt theValue) {
        this.mySubscriber = theValue;
        return this;
    }

    public IdentifierDt getNetwork() {
        if (this.myNetwork == null) {
            this.myNetwork = new IdentifierDt();
        }
        return this.myNetwork;
    }

    public Coverage setNetwork(IdentifierDt theValue) {
        this.myNetwork = theValue;
        return this;
    }

    public List<ResourceReferenceDt> getContract() {
        if (this.myContract == null) {
            this.myContract = new ArrayList<ResourceReferenceDt>();
        }
        return this.myContract;
    }

    public Coverage setContract(List<ResourceReferenceDt> theValue) {
        this.myContract = theValue;
        return this;
    }

    public ResourceReferenceDt addContract() {
        ResourceReferenceDt newType = new ResourceReferenceDt();
        this.getContract().add(newType);
        return newType;
    }

    public String getResourceName() {
        return "Coverage";
    }

    public FhirVersionEnum getStructureFhirVersionEnum() {
        return FhirVersionEnum.DSTU2;
    }
}

