/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.model.dstu2.resource;

import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.model.api.BaseIdentifiableElement;
import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.IResource;
import ca.uhn.fhir.model.api.IResourceBlock;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.TemporalPrecisionEnum;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.model.dstu2.composite.CodeableConceptDt;
import ca.uhn.fhir.model.dstu2.composite.RatioDt;
import ca.uhn.fhir.model.dstu2.composite.ResourceReferenceDt;
import ca.uhn.fhir.model.dstu2.composite.SimpleQuantityDt;
import ca.uhn.fhir.model.dstu2.resource.BaseResource;
import ca.uhn.fhir.model.dstu2.resource.Organization;
import ca.uhn.fhir.model.dstu2.resource.Substance;
import ca.uhn.fhir.model.primitive.BooleanDt;
import ca.uhn.fhir.model.primitive.DateTimeDt;
import ca.uhn.fhir.model.primitive.StringDt;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@ResourceDef(name="Medication", profile="http://hl7.org/fhir/profiles/Medication", id="medication")
public class Medication
extends BaseResource
implements IResource {
    @SearchParamDefinition(name="code", path="Medication.code", description="", type="token")
    public static final String SP_CODE = "code";
    public static final TokenClientParam CODE = new TokenClientParam("code");
    @SearchParamDefinition(name="manufacturer", path="Medication.manufacturer", description="", type="reference")
    public static final String SP_MANUFACTURER = "manufacturer";
    public static final ReferenceClientParam MANUFACTURER = new ReferenceClientParam("manufacturer");
    @SearchParamDefinition(name="form", path="Medication.product.form", description="", type="token")
    public static final String SP_FORM = "form";
    public static final TokenClientParam FORM = new TokenClientParam("form");
    @SearchParamDefinition(name="ingredient", path="Medication.product.ingredient.item", description="", type="reference")
    public static final String SP_INGREDIENT = "ingredient";
    public static final ReferenceClientParam INGREDIENT = new ReferenceClientParam("ingredient");
    @SearchParamDefinition(name="container", path="Medication.package.container", description="", type="token")
    public static final String SP_CONTAINER = "container";
    public static final TokenClientParam CONTAINER = new TokenClientParam("container");
    @SearchParamDefinition(name="content", path="Medication.package.content.item", description="", type="reference")
    public static final String SP_CONTENT = "content";
    public static final ReferenceClientParam CONTENT = new ReferenceClientParam("content");
    public static final Include INCLUDE_CONTENT = new Include("Medication:content");
    public static final Include INCLUDE_INGREDIENT = new Include("Medication:ingredient");
    public static final Include INCLUDE_MANUFACTURER = new Include("Medication:manufacturer");
    @Child(name="code", type={CodeableConceptDt.class}, order=0, min=0, max=1, summary=true, modifier=false)
    @Description(shortDefinition="class", formalDefinition="A code (or set of codes) that specify this medication, or a textual description if no code is available. Usage note: This could be a standard medication code such as a code from RxNorm, SNOMED CT, IDMP etc. It could also be a national or local formulary code, optionally with translations to other code systems.")
    private CodeableConceptDt myCode;
    @Child(name="isBrand", type={BooleanDt.class}, order=1, min=0, max=1, summary=true, modifier=false)
    @Description(shortDefinition="class", formalDefinition="Set to true if the item is attributable to a specific manufacturer.")
    private BooleanDt myIsBrand;
    @Child(name="manufacturer", order=2, min=0, max=1, summary=true, modifier=false, type={Organization.class})
    @Description(shortDefinition="who.actor", formalDefinition="Describes the details of the manufacturer")
    private ResourceReferenceDt myManufacturer;
    @Child(name="product", order=3, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="Information that only applies to products (not packages)")
    private Product myProduct;
    @Child(name="package", order=4, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="Information that only applies to packages (not products)")
    private Package myPackage;

    public boolean isEmpty() {
        return super.isBaseEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.myCode, this.myIsBrand, this.myManufacturer, this.myProduct, this.myPackage});
    }

    public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
        return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myCode, this.myIsBrand, this.myManufacturer, this.myProduct, this.myPackage});
    }

    public CodeableConceptDt getCode() {
        if (this.myCode == null) {
            this.myCode = new CodeableConceptDt();
        }
        return this.myCode;
    }

    public Medication setCode(CodeableConceptDt theValue) {
        this.myCode = theValue;
        return this;
    }

    public BooleanDt getIsBrandElement() {
        if (this.myIsBrand == null) {
            this.myIsBrand = new BooleanDt();
        }
        return this.myIsBrand;
    }

    public Boolean getIsBrand() {
        return (Boolean)this.getIsBrandElement().getValue();
    }

    public Medication setIsBrand(BooleanDt theValue) {
        this.myIsBrand = theValue;
        return this;
    }

    public Medication setIsBrand(boolean theBoolean) {
        this.myIsBrand = new BooleanDt(theBoolean);
        return this;
    }

    public ResourceReferenceDt getManufacturer() {
        if (this.myManufacturer == null) {
            this.myManufacturer = new ResourceReferenceDt();
        }
        return this.myManufacturer;
    }

    public Medication setManufacturer(ResourceReferenceDt theValue) {
        this.myManufacturer = theValue;
        return this;
    }

    public Product getProduct() {
        if (this.myProduct == null) {
            this.myProduct = new Product();
        }
        return this.myProduct;
    }

    public Medication setProduct(Product theValue) {
        this.myProduct = theValue;
        return this;
    }

    public Package getPackage() {
        if (this.myPackage == null) {
            this.myPackage = new Package();
        }
        return this.myPackage;
    }

    public Medication setPackage(Package theValue) {
        this.myPackage = theValue;
        return this;
    }

    public String getResourceName() {
        return "Medication";
    }

    public FhirVersionEnum getStructureFhirVersionEnum() {
        return FhirVersionEnum.DSTU2;
    }

    @Block
    public static class Product
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="form", type={CodeableConceptDt.class}, order=0, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="Describes the form of the item.  Powder; tablets; carton")
        private CodeableConceptDt myForm;
        @Child(name="ingredient", order=1, min=0, max=-1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="Identifies a particular constituent of interest in the product")
        private List<ProductIngredient> myIngredient;
        @Child(name="batch", order=2, min=0, max=-1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="Information about a group of medication produced or packaged from one production run.")
        private List<ProductBatch> myBatch;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.myForm, this.myIngredient, this.myBatch});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myForm, this.myIngredient, this.myBatch});
        }

        public CodeableConceptDt getForm() {
            if (this.myForm == null) {
                this.myForm = new CodeableConceptDt();
            }
            return this.myForm;
        }

        public Product setForm(CodeableConceptDt theValue) {
            this.myForm = theValue;
            return this;
        }

        public List<ProductIngredient> getIngredient() {
            if (this.myIngredient == null) {
                this.myIngredient = new ArrayList<ProductIngredient>();
            }
            return this.myIngredient;
        }

        public Product setIngredient(List<ProductIngredient> theValue) {
            this.myIngredient = theValue;
            return this;
        }

        public ProductIngredient addIngredient() {
            ProductIngredient newType = new ProductIngredient();
            this.getIngredient().add(newType);
            return newType;
        }

        public Product addIngredient(ProductIngredient theValue) {
            if (theValue == null) {
                throw new NullPointerException("theValue must not be null");
            }
            this.getIngredient().add(theValue);
            return this;
        }

        public ProductIngredient getIngredientFirstRep() {
            if (this.getIngredient().isEmpty()) {
                return this.addIngredient();
            }
            return this.getIngredient().get(0);
        }

        public List<ProductBatch> getBatch() {
            if (this.myBatch == null) {
                this.myBatch = new ArrayList<ProductBatch>();
            }
            return this.myBatch;
        }

        public Product setBatch(List<ProductBatch> theValue) {
            this.myBatch = theValue;
            return this;
        }

        public ProductBatch addBatch() {
            ProductBatch newType = new ProductBatch();
            this.getBatch().add(newType);
            return newType;
        }

        public Product addBatch(ProductBatch theValue) {
            if (theValue == null) {
                throw new NullPointerException("theValue must not be null");
            }
            this.getBatch().add(theValue);
            return this;
        }

        public ProductBatch getBatchFirstRep() {
            if (this.getBatch().isEmpty()) {
                return this.addBatch();
            }
            return this.getBatch().get(0);
        }
    }

    @Block
    public static class Package
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="container", type={CodeableConceptDt.class}, order=0, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="The kind of container that this package comes as")
        private CodeableConceptDt myContainer;
        @Child(name="content", order=1, min=0, max=-1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="A set of components that go to make up the described item.")
        private List<PackageContent> myContent;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.myContainer, this.myContent});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myContainer, this.myContent});
        }

        public CodeableConceptDt getContainer() {
            if (this.myContainer == null) {
                this.myContainer = new CodeableConceptDt();
            }
            return this.myContainer;
        }

        public Package setContainer(CodeableConceptDt theValue) {
            this.myContainer = theValue;
            return this;
        }

        public List<PackageContent> getContent() {
            if (this.myContent == null) {
                this.myContent = new ArrayList<PackageContent>();
            }
            return this.myContent;
        }

        public Package setContent(List<PackageContent> theValue) {
            this.myContent = theValue;
            return this;
        }

        public PackageContent addContent() {
            PackageContent newType = new PackageContent();
            this.getContent().add(newType);
            return newType;
        }

        public Package addContent(PackageContent theValue) {
            if (theValue == null) {
                throw new NullPointerException("theValue must not be null");
            }
            this.getContent().add(theValue);
            return this;
        }

        public PackageContent getContentFirstRep() {
            if (this.getContent().isEmpty()) {
                return this.addContent();
            }
            return this.getContent().get(0);
        }
    }

    @Block
    public static class PackageContent
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="item", order=0, min=1, max=1, summary=false, modifier=false, type={Medication.class})
        @Description(shortDefinition="", formalDefinition="Identifies one of the items in the package")
        private ResourceReferenceDt myItem;
        @Child(name="amount", type={SimpleQuantityDt.class}, order=1, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="The amount of the product that is in the package")
        private SimpleQuantityDt myAmount;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.myItem, this.myAmount});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myItem, this.myAmount});
        }

        public ResourceReferenceDt getItem() {
            if (this.myItem == null) {
                this.myItem = new ResourceReferenceDt();
            }
            return this.myItem;
        }

        public PackageContent setItem(ResourceReferenceDt theValue) {
            this.myItem = theValue;
            return this;
        }

        public SimpleQuantityDt getAmount() {
            if (this.myAmount == null) {
                this.myAmount = new SimpleQuantityDt();
            }
            return this.myAmount;
        }

        public PackageContent setAmount(SimpleQuantityDt theValue) {
            this.myAmount = theValue;
            return this;
        }
    }

    @Block
    public static class ProductBatch
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="lotNumber", type={StringDt.class}, order=0, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="The assigned lot number of a batch of the specified product.")
        private StringDt myLotNumber;
        @Child(name="expirationDate", type={DateTimeDt.class}, order=1, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="When this specific batch of product will expire.")
        private DateTimeDt myExpirationDate;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.myLotNumber, this.myExpirationDate});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myLotNumber, this.myExpirationDate});
        }

        public StringDt getLotNumberElement() {
            if (this.myLotNumber == null) {
                this.myLotNumber = new StringDt();
            }
            return this.myLotNumber;
        }

        public String getLotNumber() {
            return (String)this.getLotNumberElement().getValue();
        }

        public ProductBatch setLotNumber(StringDt theValue) {
            this.myLotNumber = theValue;
            return this;
        }

        public ProductBatch setLotNumber(String theString) {
            this.myLotNumber = new StringDt(theString);
            return this;
        }

        public DateTimeDt getExpirationDateElement() {
            if (this.myExpirationDate == null) {
                this.myExpirationDate = new DateTimeDt();
            }
            return this.myExpirationDate;
        }

        public Date getExpirationDate() {
            return (Date)this.getExpirationDateElement().getValue();
        }

        public ProductBatch setExpirationDate(DateTimeDt theValue) {
            this.myExpirationDate = theValue;
            return this;
        }

        public ProductBatch setExpirationDateWithSecondsPrecision(Date theDate) {
            this.myExpirationDate = new DateTimeDt(theDate);
            return this;
        }

        public ProductBatch setExpirationDate(Date theDate, TemporalPrecisionEnum thePrecision) {
            this.myExpirationDate = new DateTimeDt(theDate, thePrecision);
            return this;
        }
    }

    @Block
    public static class ProductIngredient
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="item", order=0, min=1, max=1, summary=false, modifier=false, type={Substance.class, Medication.class})
        @Description(shortDefinition="", formalDefinition="The actual ingredient - either a substance (simple ingredient) or another medication")
        private ResourceReferenceDt myItem;
        @Child(name="amount", type={RatioDt.class}, order=1, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="Specifies how many (or how much) of the items there are in this Medication.  For example, 250 mg per tablet")
        private RatioDt myAmount;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.myItem, this.myAmount});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myItem, this.myAmount});
        }

        public ResourceReferenceDt getItem() {
            if (this.myItem == null) {
                this.myItem = new ResourceReferenceDt();
            }
            return this.myItem;
        }

        public ProductIngredient setItem(ResourceReferenceDt theValue) {
            this.myItem = theValue;
            return this;
        }

        public RatioDt getAmount() {
            if (this.myAmount == null) {
                this.myAmount = new RatioDt();
            }
            return this.myAmount;
        }

        public ProductIngredient setAmount(RatioDt theValue) {
            this.myAmount = theValue;
            return this;
        }
    }
}

