/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.model.dstu2.valueset;

import ca.uhn.fhir.model.api.IValueSetEnumBinder;
import java.util.HashMap;
import java.util.Map;

public enum BindingStrengthEnum {
    REQUIRED("required", "http://hl7.org/fhir/binding-strength"),
    EXTENSIBLE("extensible", "http://hl7.org/fhir/binding-strength"),
    PREFERRED("preferred", "http://hl7.org/fhir/binding-strength"),
    EXAMPLE("example", "http://hl7.org/fhir/binding-strength");

    public static final String VALUESET_IDENTIFIER = "";
    public static final String VALUESET_NAME = "BindingStrength";
    private static Map<String, BindingStrengthEnum> CODE_TO_ENUM;
    private static Map<String, Map<String, BindingStrengthEnum>> SYSTEM_TO_CODE_TO_ENUM;
    private final String myCode;
    private final String mySystem;
    public static final IValueSetEnumBinder<BindingStrengthEnum> VALUESET_BINDER;

    public String getCode() {
        return this.myCode;
    }

    public String getSystem() {
        return this.mySystem;
    }

    public static BindingStrengthEnum forCode(String theCode) {
        BindingStrengthEnum retVal = CODE_TO_ENUM.get(theCode);
        return retVal;
    }

    private BindingStrengthEnum(String theCode, String theSystem) {
        this.myCode = theCode;
        this.mySystem = theSystem;
    }

    static {
        CODE_TO_ENUM = new HashMap<String, BindingStrengthEnum>();
        SYSTEM_TO_CODE_TO_ENUM = new HashMap<String, Map<String, BindingStrengthEnum>>();
        for (BindingStrengthEnum next : BindingStrengthEnum.values()) {
            CODE_TO_ENUM.put(next.getCode(), next);
            if (!SYSTEM_TO_CODE_TO_ENUM.containsKey(next.getSystem())) {
                SYSTEM_TO_CODE_TO_ENUM.put(next.getSystem(), new HashMap());
            }
            SYSTEM_TO_CODE_TO_ENUM.get(next.getSystem()).put(next.getCode(), next);
        }
        VALUESET_BINDER = new IValueSetEnumBinder<BindingStrengthEnum>(){

            public String toCodeString(BindingStrengthEnum theEnum) {
                return theEnum.getCode();
            }

            public String toSystemString(BindingStrengthEnum theEnum) {
                return theEnum.getSystem();
            }

            public BindingStrengthEnum fromCodeString(String theCodeString) {
                return CODE_TO_ENUM.get(theCodeString);
            }

            public BindingStrengthEnum fromCodeString(String theCodeString, String theSystemString) {
                Map<String, BindingStrengthEnum> map = SYSTEM_TO_CODE_TO_ENUM.get(theSystemString);
                if (map == null) {
                    return null;
                }
                return map.get(theCodeString);
            }
        };
    }
}

