/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.model.dstu2.resource;

import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.model.api.BaseIdentifiableElement;
import ca.uhn.fhir.model.api.IDatatype;
import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.IResource;
import ca.uhn.fhir.model.api.IResourceBlock;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.TemporalPrecisionEnum;
import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Compartment;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.model.dstu2.composite.CodeableConceptDt;
import ca.uhn.fhir.model.dstu2.composite.ResourceReferenceDt;
import ca.uhn.fhir.model.dstu2.resource.AllergyIntolerance;
import ca.uhn.fhir.model.dstu2.resource.Appointment;
import ca.uhn.fhir.model.dstu2.resource.BaseResource;
import ca.uhn.fhir.model.dstu2.resource.CarePlan;
import ca.uhn.fhir.model.dstu2.resource.CommunicationRequest;
import ca.uhn.fhir.model.dstu2.resource.Condition;
import ca.uhn.fhir.model.dstu2.resource.DeviceUseRequest;
import ca.uhn.fhir.model.dstu2.resource.DiagnosticOrder;
import ca.uhn.fhir.model.dstu2.resource.DiagnosticReport;
import ca.uhn.fhir.model.dstu2.resource.FamilyMemberHistory;
import ca.uhn.fhir.model.dstu2.resource.MedicationOrder;
import ca.uhn.fhir.model.dstu2.resource.NutritionOrder;
import ca.uhn.fhir.model.dstu2.resource.Observation;
import ca.uhn.fhir.model.dstu2.resource.Order;
import ca.uhn.fhir.model.dstu2.resource.Patient;
import ca.uhn.fhir.model.dstu2.resource.Practitioner;
import ca.uhn.fhir.model.dstu2.resource.Procedure;
import ca.uhn.fhir.model.dstu2.resource.ProcedureRequest;
import ca.uhn.fhir.model.dstu2.resource.ProcessRequest;
import ca.uhn.fhir.model.dstu2.resource.QuestionnaireResponse;
import ca.uhn.fhir.model.dstu2.resource.ReferralRequest;
import ca.uhn.fhir.model.dstu2.resource.SupplyRequest;
import ca.uhn.fhir.model.dstu2.resource.VisionPrescription;
import ca.uhn.fhir.model.dstu2.valueset.ClinicalImpressionStatusEnum;
import ca.uhn.fhir.model.primitive.BoundCodeDt;
import ca.uhn.fhir.model.primitive.CodeDt;
import ca.uhn.fhir.model.primitive.DateTimeDt;
import ca.uhn.fhir.model.primitive.StringDt;
import ca.uhn.fhir.model.primitive.UriDt;
import ca.uhn.fhir.rest.gclient.DateClientParam;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@ResourceDef(name="ClinicalImpression", profile="http://hl7.org/fhir/profiles/ClinicalImpression", id="clinicalimpression")
public class ClinicalImpression
extends BaseResource
implements IResource {
    @SearchParamDefinition(name="previous", path="ClinicalImpression.previous", description="", type="reference")
    public static final String SP_PREVIOUS = "previous";
    public static final ReferenceClientParam PREVIOUS = new ReferenceClientParam("previous");
    @SearchParamDefinition(name="problem", path="ClinicalImpression.problem", description="", type="reference")
    public static final String SP_PROBLEM = "problem";
    public static final ReferenceClientParam PROBLEM = new ReferenceClientParam("problem");
    @SearchParamDefinition(name="trigger", path="ClinicalImpression.triggerReference", description="", type="reference")
    public static final String SP_TRIGGER = "trigger";
    public static final ReferenceClientParam TRIGGER = new ReferenceClientParam("trigger");
    @SearchParamDefinition(name="trigger-code", path="ClinicalImpression.triggerCodeableConcept", description="", type="token")
    public static final String SP_TRIGGER_CODE = "trigger-code";
    public static final TokenClientParam TRIGGER_CODE = new TokenClientParam("trigger-code");
    @SearchParamDefinition(name="investigation", path="ClinicalImpression.investigations.item", description="", type="reference")
    public static final String SP_INVESTIGATION = "investigation";
    public static final ReferenceClientParam INVESTIGATION = new ReferenceClientParam("investigation");
    @SearchParamDefinition(name="finding", path="ClinicalImpression.finding.item", description="", type="token")
    public static final String SP_FINDING = "finding";
    public static final TokenClientParam FINDING = new TokenClientParam("finding");
    @SearchParamDefinition(name="resolved", path="ClinicalImpression.resolved", description="", type="token")
    public static final String SP_RESOLVED = "resolved";
    public static final TokenClientParam RESOLVED = new TokenClientParam("resolved");
    @SearchParamDefinition(name="ruledout", path="ClinicalImpression.ruledOut.item", description="", type="token")
    public static final String SP_RULEDOUT = "ruledout";
    public static final TokenClientParam RULEDOUT = new TokenClientParam("ruledout");
    @SearchParamDefinition(name="plan", path="ClinicalImpression.plan", description="", type="reference")
    public static final String SP_PLAN = "plan";
    public static final ReferenceClientParam PLAN = new ReferenceClientParam("plan");
    @SearchParamDefinition(name="action", path="ClinicalImpression.action", description="", type="reference")
    public static final String SP_ACTION = "action";
    public static final ReferenceClientParam ACTION = new ReferenceClientParam("action");
    @SearchParamDefinition(name="patient", path="ClinicalImpression.patient", description="", type="reference", providesMembershipIn={@Compartment(name="Patient")})
    public static final String SP_PATIENT = "patient";
    public static final ReferenceClientParam PATIENT = new ReferenceClientParam("patient");
    @SearchParamDefinition(name="assessor", path="ClinicalImpression.assessor", description="", type="reference", providesMembershipIn={@Compartment(name="Encounter")})
    public static final String SP_ASSESSOR = "assessor";
    public static final ReferenceClientParam ASSESSOR = new ReferenceClientParam("assessor");
    @SearchParamDefinition(name="date", path="ClinicalImpression.date", description="", type="date")
    public static final String SP_DATE = "date";
    public static final DateClientParam DATE = new DateClientParam("date");
    @SearchParamDefinition(name="status", path="ClinicalImpression.status", description="", type="token")
    public static final String SP_STATUS = "status";
    public static final TokenClientParam STATUS = new TokenClientParam("status");
    public static final Include INCLUDE_ACTION = new Include("ClinicalImpression:action");
    public static final Include INCLUDE_ASSESSOR = new Include("ClinicalImpression:assessor");
    public static final Include INCLUDE_INVESTIGATION = new Include("ClinicalImpression:investigation");
    public static final Include INCLUDE_PATIENT = new Include("ClinicalImpression:patient");
    public static final Include INCLUDE_PLAN = new Include("ClinicalImpression:plan");
    public static final Include INCLUDE_PREVIOUS = new Include("ClinicalImpression:previous");
    public static final Include INCLUDE_PROBLEM = new Include("ClinicalImpression:problem");
    public static final Include INCLUDE_TRIGGER = new Include("ClinicalImpression:trigger");
    @Child(name="patient", order=0, min=1, max=1, summary=true, modifier=false, type={Patient.class})
    @Description(shortDefinition="", formalDefinition="The patient being assessed")
    private ResourceReferenceDt myPatient;
    @Child(name="assessor", order=1, min=0, max=1, summary=true, modifier=false, type={Practitioner.class})
    @Description(shortDefinition="", formalDefinition="The clinician performing the assessment")
    private ResourceReferenceDt myAssessor;
    @Child(name="status", type={CodeDt.class}, order=2, min=1, max=1, summary=true, modifier=true)
    @Description(shortDefinition="", formalDefinition="Identifies the workflow status of the assessment")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/clinical-impression-status")
    private BoundCodeDt<ClinicalImpressionStatusEnum> myStatus;
    @Child(name="date", type={DateTimeDt.class}, order=3, min=0, max=1, summary=true, modifier=false)
    @Description(shortDefinition="", formalDefinition="The point in time at which the assessment was concluded (not when it was recorded)")
    private DateTimeDt myDate;
    @Child(name="description", type={StringDt.class}, order=4, min=0, max=1, summary=true, modifier=false)
    @Description(shortDefinition="", formalDefinition="A summary of the context and/or cause of the assessment - why / where was it peformed, and what patient events/sstatus prompted it")
    private StringDt myDescription;
    @Child(name="previous", order=5, min=0, max=1, summary=false, modifier=false, type={ClinicalImpression.class})
    @Description(shortDefinition="", formalDefinition="A reference to the last assesment that was conducted bon this patient. Assessments are often/usually ongoing in nature; a care provider (practitioner or team) will make new assessments on an ongoing basis as new data arises or the patient's conditions changes")
    private ResourceReferenceDt myPrevious;
    @Child(name="problem", order=6, min=0, max=-1, summary=true, modifier=false, type={Condition.class, AllergyIntolerance.class})
    @Description(shortDefinition="", formalDefinition="This a list of the general problems/conditions for a patient")
    private List<ResourceReferenceDt> myProblem;
    @Child(name="trigger", order=7, min=0, max=1, summary=false, modifier=false, type={CodeableConceptDt.class, IResource.class})
    @Description(shortDefinition="", formalDefinition="The request or event that necessitated this assessment. This may be a diagnosis, a Care Plan, a Request Referral, or some other resource")
    private IDatatype myTrigger;
    @Child(name="investigations", order=8, min=0, max=-1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="One or more sets of investigations (signs, symptions, etc.). The actual grouping of investigations vary greatly depending on the type and context of the assessment. These investigations may include data generated during the assessment process, or data previously generated and recorded that is pertinent to the outcomes")
    private List<Investigations> myInvestigations;
    @Child(name="protocol", type={UriDt.class}, order=9, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="Reference to a specific published clinical protocol that was followed during this assessment, and/or that provides evidence in support of the diagnosis")
    private UriDt myProtocol;
    @Child(name="summary", type={StringDt.class}, order=10, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="A text summary of the investigations and the diagnosis")
    private StringDt mySummary;
    @Child(name="finding", order=11, min=0, max=-1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="Specific findings or diagnoses that was considered likely or relevant to ongoing treatment")
    private List<Finding> myFinding;
    @Child(name="resolved", type={CodeableConceptDt.class}, order=12, min=0, max=-1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="Diagnoses/conditions resolved since the last assessment")
    private List<CodeableConceptDt> myResolved;
    @Child(name="ruledOut", order=13, min=0, max=-1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="Diagnosis considered not possible")
    private List<RuledOut> myRuledOut;
    @Child(name="prognosis", type={StringDt.class}, order=14, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="Estimate of likely outcome")
    private StringDt myPrognosis;
    @Child(name="plan", order=15, min=0, max=-1, summary=false, modifier=false, type={CarePlan.class, Appointment.class, CommunicationRequest.class, DeviceUseRequest.class, DiagnosticOrder.class, MedicationOrder.class, NutritionOrder.class, Order.class, ProcedureRequest.class, ProcessRequest.class, ReferralRequest.class, SupplyRequest.class, VisionPrescription.class})
    @Description(shortDefinition="", formalDefinition="Plan of action after assessment")
    private List<ResourceReferenceDt> myPlan;
    @Child(name="action", order=16, min=0, max=-1, summary=false, modifier=false, type={ReferralRequest.class, ProcedureRequest.class, Procedure.class, MedicationOrder.class, DiagnosticOrder.class, NutritionOrder.class, SupplyRequest.class, Appointment.class})
    @Description(shortDefinition="", formalDefinition="Actions taken during assessment")
    private List<ResourceReferenceDt> myAction;

    public boolean isEmpty() {
        return super.isBaseEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.myPatient, this.myAssessor, this.myStatus, this.myDate, this.myDescription, this.myPrevious, this.myProblem, this.myTrigger, this.myInvestigations, this.myProtocol, this.mySummary, this.myFinding, this.myResolved, this.myRuledOut, this.myPrognosis, this.myPlan, this.myAction});
    }

    public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
        return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myPatient, this.myAssessor, this.myStatus, this.myDate, this.myDescription, this.myPrevious, this.myProblem, this.myTrigger, this.myInvestigations, this.myProtocol, this.mySummary, this.myFinding, this.myResolved, this.myRuledOut, this.myPrognosis, this.myPlan, this.myAction});
    }

    public ResourceReferenceDt getPatient() {
        if (this.myPatient == null) {
            this.myPatient = new ResourceReferenceDt();
        }
        return this.myPatient;
    }

    public ClinicalImpression setPatient(ResourceReferenceDt theValue) {
        this.myPatient = theValue;
        return this;
    }

    public ResourceReferenceDt getAssessor() {
        if (this.myAssessor == null) {
            this.myAssessor = new ResourceReferenceDt();
        }
        return this.myAssessor;
    }

    public ClinicalImpression setAssessor(ResourceReferenceDt theValue) {
        this.myAssessor = theValue;
        return this;
    }

    public BoundCodeDt<ClinicalImpressionStatusEnum> getStatusElement() {
        if (this.myStatus == null) {
            this.myStatus = new BoundCodeDt(ClinicalImpressionStatusEnum.VALUESET_BINDER);
        }
        return this.myStatus;
    }

    public String getStatus() {
        return (String)this.getStatusElement().getValue();
    }

    public ClinicalImpression setStatus(BoundCodeDt<ClinicalImpressionStatusEnum> theValue) {
        this.myStatus = theValue;
        return this;
    }

    public ClinicalImpression setStatus(ClinicalImpressionStatusEnum theValue) {
        this.setStatus((BoundCodeDt<ClinicalImpressionStatusEnum>)new BoundCodeDt(ClinicalImpressionStatusEnum.VALUESET_BINDER, (Enum)theValue));
        return this;
    }

    public DateTimeDt getDateElement() {
        if (this.myDate == null) {
            this.myDate = new DateTimeDt();
        }
        return this.myDate;
    }

    public Date getDate() {
        return (Date)this.getDateElement().getValue();
    }

    public ClinicalImpression setDate(DateTimeDt theValue) {
        this.myDate = theValue;
        return this;
    }

    public ClinicalImpression setDate(Date theDate, TemporalPrecisionEnum thePrecision) {
        this.myDate = new DateTimeDt(theDate, thePrecision);
        return this;
    }

    public ClinicalImpression setDateWithSecondsPrecision(Date theDate) {
        this.myDate = new DateTimeDt(theDate);
        return this;
    }

    public StringDt getDescriptionElement() {
        if (this.myDescription == null) {
            this.myDescription = new StringDt();
        }
        return this.myDescription;
    }

    public String getDescription() {
        return (String)this.getDescriptionElement().getValue();
    }

    public ClinicalImpression setDescription(StringDt theValue) {
        this.myDescription = theValue;
        return this;
    }

    public ClinicalImpression setDescription(String theString) {
        this.myDescription = new StringDt(theString);
        return this;
    }

    public ResourceReferenceDt getPrevious() {
        if (this.myPrevious == null) {
            this.myPrevious = new ResourceReferenceDt();
        }
        return this.myPrevious;
    }

    public ClinicalImpression setPrevious(ResourceReferenceDt theValue) {
        this.myPrevious = theValue;
        return this;
    }

    public List<ResourceReferenceDt> getProblem() {
        if (this.myProblem == null) {
            this.myProblem = new ArrayList<ResourceReferenceDt>();
        }
        return this.myProblem;
    }

    public ClinicalImpression setProblem(List<ResourceReferenceDt> theValue) {
        this.myProblem = theValue;
        return this;
    }

    public ResourceReferenceDt addProblem() {
        ResourceReferenceDt newType = new ResourceReferenceDt();
        this.getProblem().add(newType);
        return newType;
    }

    public IDatatype getTrigger() {
        return this.myTrigger;
    }

    public ClinicalImpression setTrigger(IDatatype theValue) {
        this.myTrigger = theValue;
        return this;
    }

    public List<Investigations> getInvestigations() {
        if (this.myInvestigations == null) {
            this.myInvestigations = new ArrayList<Investigations>();
        }
        return this.myInvestigations;
    }

    public ClinicalImpression setInvestigations(List<Investigations> theValue) {
        this.myInvestigations = theValue;
        return this;
    }

    public Investigations addInvestigations() {
        Investigations newType = new Investigations();
        this.getInvestigations().add(newType);
        return newType;
    }

    public ClinicalImpression addInvestigations(Investigations theValue) {
        if (theValue == null) {
            throw new NullPointerException("theValue must not be null");
        }
        this.getInvestigations().add(theValue);
        return this;
    }

    public Investigations getInvestigationsFirstRep() {
        if (this.getInvestigations().isEmpty()) {
            return this.addInvestigations();
        }
        return this.getInvestigations().get(0);
    }

    public UriDt getProtocolElement() {
        if (this.myProtocol == null) {
            this.myProtocol = new UriDt();
        }
        return this.myProtocol;
    }

    public String getProtocol() {
        return (String)this.getProtocolElement().getValue();
    }

    public ClinicalImpression setProtocol(UriDt theValue) {
        this.myProtocol = theValue;
        return this;
    }

    public ClinicalImpression setProtocol(String theUri) {
        this.myProtocol = new UriDt(theUri);
        return this;
    }

    public StringDt getSummaryElement() {
        if (this.mySummary == null) {
            this.mySummary = new StringDt();
        }
        return this.mySummary;
    }

    public String getSummary() {
        return (String)this.getSummaryElement().getValue();
    }

    public ClinicalImpression setSummary(StringDt theValue) {
        this.mySummary = theValue;
        return this;
    }

    public ClinicalImpression setSummary(String theString) {
        this.mySummary = new StringDt(theString);
        return this;
    }

    public List<Finding> getFinding() {
        if (this.myFinding == null) {
            this.myFinding = new ArrayList<Finding>();
        }
        return this.myFinding;
    }

    public ClinicalImpression setFinding(List<Finding> theValue) {
        this.myFinding = theValue;
        return this;
    }

    public Finding addFinding() {
        Finding newType = new Finding();
        this.getFinding().add(newType);
        return newType;
    }

    public ClinicalImpression addFinding(Finding theValue) {
        if (theValue == null) {
            throw new NullPointerException("theValue must not be null");
        }
        this.getFinding().add(theValue);
        return this;
    }

    public Finding getFindingFirstRep() {
        if (this.getFinding().isEmpty()) {
            return this.addFinding();
        }
        return this.getFinding().get(0);
    }

    public List<CodeableConceptDt> getResolved() {
        if (this.myResolved == null) {
            this.myResolved = new ArrayList<CodeableConceptDt>();
        }
        return this.myResolved;
    }

    public ClinicalImpression setResolved(List<CodeableConceptDt> theValue) {
        this.myResolved = theValue;
        return this;
    }

    public CodeableConceptDt addResolved() {
        CodeableConceptDt newType = new CodeableConceptDt();
        this.getResolved().add(newType);
        return newType;
    }

    public ClinicalImpression addResolved(CodeableConceptDt theValue) {
        if (theValue == null) {
            throw new NullPointerException("theValue must not be null");
        }
        this.getResolved().add(theValue);
        return this;
    }

    public CodeableConceptDt getResolvedFirstRep() {
        if (this.getResolved().isEmpty()) {
            return this.addResolved();
        }
        return this.getResolved().get(0);
    }

    public List<RuledOut> getRuledOut() {
        if (this.myRuledOut == null) {
            this.myRuledOut = new ArrayList<RuledOut>();
        }
        return this.myRuledOut;
    }

    public ClinicalImpression setRuledOut(List<RuledOut> theValue) {
        this.myRuledOut = theValue;
        return this;
    }

    public RuledOut addRuledOut() {
        RuledOut newType = new RuledOut();
        this.getRuledOut().add(newType);
        return newType;
    }

    public ClinicalImpression addRuledOut(RuledOut theValue) {
        if (theValue == null) {
            throw new NullPointerException("theValue must not be null");
        }
        this.getRuledOut().add(theValue);
        return this;
    }

    public RuledOut getRuledOutFirstRep() {
        if (this.getRuledOut().isEmpty()) {
            return this.addRuledOut();
        }
        return this.getRuledOut().get(0);
    }

    public StringDt getPrognosisElement() {
        if (this.myPrognosis == null) {
            this.myPrognosis = new StringDt();
        }
        return this.myPrognosis;
    }

    public String getPrognosis() {
        return (String)this.getPrognosisElement().getValue();
    }

    public ClinicalImpression setPrognosis(StringDt theValue) {
        this.myPrognosis = theValue;
        return this;
    }

    public ClinicalImpression setPrognosis(String theString) {
        this.myPrognosis = new StringDt(theString);
        return this;
    }

    public List<ResourceReferenceDt> getPlan() {
        if (this.myPlan == null) {
            this.myPlan = new ArrayList<ResourceReferenceDt>();
        }
        return this.myPlan;
    }

    public ClinicalImpression setPlan(List<ResourceReferenceDt> theValue) {
        this.myPlan = theValue;
        return this;
    }

    public ResourceReferenceDt addPlan() {
        ResourceReferenceDt newType = new ResourceReferenceDt();
        this.getPlan().add(newType);
        return newType;
    }

    public List<ResourceReferenceDt> getAction() {
        if (this.myAction == null) {
            this.myAction = new ArrayList<ResourceReferenceDt>();
        }
        return this.myAction;
    }

    public ClinicalImpression setAction(List<ResourceReferenceDt> theValue) {
        this.myAction = theValue;
        return this;
    }

    public ResourceReferenceDt addAction() {
        ResourceReferenceDt newType = new ResourceReferenceDt();
        this.getAction().add(newType);
        return newType;
    }

    public String getResourceName() {
        return "ClinicalImpression";
    }

    public FhirVersionEnum getStructureFhirVersionEnum() {
        return FhirVersionEnum.DSTU2;
    }

    @Block
    public static class Investigations
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="code", type={CodeableConceptDt.class}, order=0, min=1, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="A name/code for the group (\"set\") of investigations. Typically, this will be something like \"signs\", \"symptoms\", \"clinical\", \"diagnostic\", but the list is not constrained, and others such groups such as (exposure|family|travel|nutitirional) history may be used")
        private CodeableConceptDt myCode;
        @Child(name="item", order=1, min=0, max=-1, summary=false, modifier=false, type={Observation.class, QuestionnaireResponse.class, FamilyMemberHistory.class, DiagnosticReport.class})
        @Description(shortDefinition="", formalDefinition="A record of a specific investigation that was undertaken")
        private List<ResourceReferenceDt> myItem;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.myCode, this.myItem});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myCode, this.myItem});
        }

        public CodeableConceptDt getCode() {
            if (this.myCode == null) {
                this.myCode = new CodeableConceptDt();
            }
            return this.myCode;
        }

        public Investigations setCode(CodeableConceptDt theValue) {
            this.myCode = theValue;
            return this;
        }

        public List<ResourceReferenceDt> getItem() {
            if (this.myItem == null) {
                this.myItem = new ArrayList<ResourceReferenceDt>();
            }
            return this.myItem;
        }

        public Investigations setItem(List<ResourceReferenceDt> theValue) {
            this.myItem = theValue;
            return this;
        }

        public ResourceReferenceDt addItem() {
            ResourceReferenceDt newType = new ResourceReferenceDt();
            this.getItem().add(newType);
            return newType;
        }
    }

    @Block
    public static class Finding
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="item", type={CodeableConceptDt.class}, order=0, min=1, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="Specific text of code for finding or diagnosis")
        private CodeableConceptDt myItem;
        @Child(name="cause", type={StringDt.class}, order=1, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="Which investigations support finding or diagnosis")
        private StringDt myCause;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.myItem, this.myCause});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myItem, this.myCause});
        }

        public CodeableConceptDt getItem() {
            if (this.myItem == null) {
                this.myItem = new CodeableConceptDt();
            }
            return this.myItem;
        }

        public Finding setItem(CodeableConceptDt theValue) {
            this.myItem = theValue;
            return this;
        }

        public StringDt getCauseElement() {
            if (this.myCause == null) {
                this.myCause = new StringDt();
            }
            return this.myCause;
        }

        public String getCause() {
            return (String)this.getCauseElement().getValue();
        }

        public Finding setCause(StringDt theValue) {
            this.myCause = theValue;
            return this;
        }

        public Finding setCause(String theString) {
            this.myCause = new StringDt(theString);
            return this;
        }
    }

    @Block
    public static class RuledOut
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="item", type={CodeableConceptDt.class}, order=0, min=1, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="Specific text of code for diagnosis")
        private CodeableConceptDt myItem;
        @Child(name="reason", type={StringDt.class}, order=1, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="Grounds for elimination")
        private StringDt myReason;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.myItem, this.myReason});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myItem, this.myReason});
        }

        public CodeableConceptDt getItem() {
            if (this.myItem == null) {
                this.myItem = new CodeableConceptDt();
            }
            return this.myItem;
        }

        public RuledOut setItem(CodeableConceptDt theValue) {
            this.myItem = theValue;
            return this;
        }

        public StringDt getReasonElement() {
            if (this.myReason == null) {
                this.myReason = new StringDt();
            }
            return this.myReason;
        }

        public String getReason() {
            return (String)this.getReasonElement().getValue();
        }

        public RuledOut setReason(StringDt theValue) {
            this.myReason = theValue;
            return this;
        }

        public RuledOut setReason(String theString) {
            this.myReason = new StringDt(theString);
            return this;
        }
    }
}

