/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.model.dstu2.resource;

import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.model.api.IDatatype;
import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.IResource;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.TemporalPrecisionEnum;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Compartment;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.model.dstu2.composite.CodeableConceptDt;
import ca.uhn.fhir.model.dstu2.composite.IdentifierDt;
import ca.uhn.fhir.model.dstu2.composite.PeriodDt;
import ca.uhn.fhir.model.dstu2.composite.ResourceReferenceDt;
import ca.uhn.fhir.model.dstu2.composite.TimingDt;
import ca.uhn.fhir.model.dstu2.resource.BaseResource;
import ca.uhn.fhir.model.dstu2.resource.BodySite;
import ca.uhn.fhir.model.dstu2.resource.Device;
import ca.uhn.fhir.model.dstu2.resource.Patient;
import ca.uhn.fhir.model.primitive.DateTimeDt;
import ca.uhn.fhir.model.primitive.StringDt;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@ResourceDef(name="DeviceUseStatement", profile="http://hl7.org/fhir/profiles/DeviceUseStatement", id="deviceusestatement")
public class DeviceUseStatement
extends BaseResource
implements IResource {
    @SearchParamDefinition(name="subject", path="DeviceUseStatement.subject", description="Search by subject", type="reference", providesMembershipIn={@Compartment(name="Patient")})
    public static final String SP_SUBJECT = "subject";
    public static final ReferenceClientParam SUBJECT = new ReferenceClientParam("subject");
    @SearchParamDefinition(name="patient", path="DeviceUseStatement.subject", description="Search by subject - a patient", type="reference")
    public static final String SP_PATIENT = "patient";
    public static final ReferenceClientParam PATIENT = new ReferenceClientParam("patient");
    @SearchParamDefinition(name="device", path="DeviceUseStatement.device", description="Search by device", type="reference", providesMembershipIn={@Compartment(name="Encounter")})
    public static final String SP_DEVICE = "device";
    public static final ReferenceClientParam DEVICE = new ReferenceClientParam("device");
    public static final Include INCLUDE_DEVICE = new Include("DeviceUseStatement:device");
    public static final Include INCLUDE_PATIENT = new Include("DeviceUseStatement:patient");
    public static final Include INCLUDE_SUBJECT = new Include("DeviceUseStatement:subject");
    @Child(name="bodySite", order=0, min=0, max=1, summary=false, modifier=false, type={CodeableConceptDt.class, BodySite.class})
    @Description(shortDefinition="", formalDefinition="Indicates the site on the subject's body where the device was used ( i.e. the target site).")
    private IDatatype myBodySite;
    @Child(name="whenUsed", type={PeriodDt.class}, order=1, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="when.done", formalDefinition="The time period over which the device was used.")
    private PeriodDt myWhenUsed;
    @Child(name="device", order=2, min=1, max=1, summary=false, modifier=false, type={Device.class})
    @Description(shortDefinition="who.actor", formalDefinition="The details of the device used.")
    private ResourceReferenceDt myDevice;
    @Child(name="identifier", type={IdentifierDt.class}, order=3, min=0, max=-1, summary=false, modifier=false)
    @Description(shortDefinition="id", formalDefinition="An external identifier for this statement such as an IRI.")
    private List<IdentifierDt> myIdentifier;
    @Child(name="indication", type={CodeableConceptDt.class}, order=4, min=0, max=-1, summary=false, modifier=false)
    @Description(shortDefinition="why", formalDefinition="Reason or justification for the use of the device.")
    private List<CodeableConceptDt> myIndication;
    @Child(name="notes", type={StringDt.class}, order=5, min=0, max=-1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="Details about the device statement that were not represented at all or sufficiently in one of the attributes provided in a class. These may include for example a comment, an instruction, or a note associated with the statement.")
    private List<StringDt> myNotes;
    @Child(name="recordedOn", type={DateTimeDt.class}, order=6, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="when.recorded", formalDefinition="The time at which the statement was made/recorded.")
    private DateTimeDt myRecordedOn;
    @Child(name="subject", order=7, min=1, max=1, summary=false, modifier=false, type={Patient.class})
    @Description(shortDefinition="who.focus", formalDefinition="The patient who used the device.")
    private ResourceReferenceDt mySubject;
    @Child(name="timing", order=8, min=0, max=1, summary=false, modifier=false, type={TimingDt.class, PeriodDt.class, DateTimeDt.class})
    @Description(shortDefinition="when.done", formalDefinition="How often the device was used.")
    private IDatatype myTiming;

    public boolean isEmpty() {
        return super.isBaseEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.myBodySite, this.myWhenUsed, this.myDevice, this.myIdentifier, this.myIndication, this.myNotes, this.myRecordedOn, this.mySubject, this.myTiming});
    }

    public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
        return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myBodySite, this.myWhenUsed, this.myDevice, this.myIdentifier, this.myIndication, this.myNotes, this.myRecordedOn, this.mySubject, this.myTiming});
    }

    public IDatatype getBodySite() {
        return this.myBodySite;
    }

    public DeviceUseStatement setBodySite(IDatatype theValue) {
        this.myBodySite = theValue;
        return this;
    }

    public PeriodDt getWhenUsed() {
        if (this.myWhenUsed == null) {
            this.myWhenUsed = new PeriodDt();
        }
        return this.myWhenUsed;
    }

    public DeviceUseStatement setWhenUsed(PeriodDt theValue) {
        this.myWhenUsed = theValue;
        return this;
    }

    public ResourceReferenceDt getDevice() {
        if (this.myDevice == null) {
            this.myDevice = new ResourceReferenceDt();
        }
        return this.myDevice;
    }

    public DeviceUseStatement setDevice(ResourceReferenceDt theValue) {
        this.myDevice = theValue;
        return this;
    }

    public List<IdentifierDt> getIdentifier() {
        if (this.myIdentifier == null) {
            this.myIdentifier = new ArrayList<IdentifierDt>();
        }
        return this.myIdentifier;
    }

    public DeviceUseStatement setIdentifier(List<IdentifierDt> theValue) {
        this.myIdentifier = theValue;
        return this;
    }

    public IdentifierDt addIdentifier() {
        IdentifierDt newType = new IdentifierDt();
        this.getIdentifier().add(newType);
        return newType;
    }

    public DeviceUseStatement addIdentifier(IdentifierDt theValue) {
        if (theValue == null) {
            throw new NullPointerException("theValue must not be null");
        }
        this.getIdentifier().add(theValue);
        return this;
    }

    public IdentifierDt getIdentifierFirstRep() {
        if (this.getIdentifier().isEmpty()) {
            return this.addIdentifier();
        }
        return this.getIdentifier().get(0);
    }

    public List<CodeableConceptDt> getIndication() {
        if (this.myIndication == null) {
            this.myIndication = new ArrayList<CodeableConceptDt>();
        }
        return this.myIndication;
    }

    public DeviceUseStatement setIndication(List<CodeableConceptDt> theValue) {
        this.myIndication = theValue;
        return this;
    }

    public CodeableConceptDt addIndication() {
        CodeableConceptDt newType = new CodeableConceptDt();
        this.getIndication().add(newType);
        return newType;
    }

    public DeviceUseStatement addIndication(CodeableConceptDt theValue) {
        if (theValue == null) {
            throw new NullPointerException("theValue must not be null");
        }
        this.getIndication().add(theValue);
        return this;
    }

    public CodeableConceptDt getIndicationFirstRep() {
        if (this.getIndication().isEmpty()) {
            return this.addIndication();
        }
        return this.getIndication().get(0);
    }

    public List<StringDt> getNotes() {
        if (this.myNotes == null) {
            this.myNotes = new ArrayList<StringDt>();
        }
        return this.myNotes;
    }

    public DeviceUseStatement setNotes(List<StringDt> theValue) {
        this.myNotes = theValue;
        return this;
    }

    public StringDt addNotes() {
        StringDt newType = new StringDt();
        this.getNotes().add(newType);
        return newType;
    }

    public DeviceUseStatement addNotes(StringDt theValue) {
        if (theValue == null) {
            throw new NullPointerException("theValue must not be null");
        }
        this.getNotes().add(theValue);
        return this;
    }

    public StringDt getNotesFirstRep() {
        if (this.getNotes().isEmpty()) {
            return this.addNotes();
        }
        return this.getNotes().get(0);
    }

    public DeviceUseStatement addNotes(String theString) {
        if (this.myNotes == null) {
            this.myNotes = new ArrayList<StringDt>();
        }
        this.myNotes.add(new StringDt(theString));
        return this;
    }

    public DateTimeDt getRecordedOnElement() {
        if (this.myRecordedOn == null) {
            this.myRecordedOn = new DateTimeDt();
        }
        return this.myRecordedOn;
    }

    public Date getRecordedOn() {
        return (Date)this.getRecordedOnElement().getValue();
    }

    public DeviceUseStatement setRecordedOn(DateTimeDt theValue) {
        this.myRecordedOn = theValue;
        return this;
    }

    public DeviceUseStatement setRecordedOn(Date theDate, TemporalPrecisionEnum thePrecision) {
        this.myRecordedOn = new DateTimeDt(theDate, thePrecision);
        return this;
    }

    public DeviceUseStatement setRecordedOnWithSecondsPrecision(Date theDate) {
        this.myRecordedOn = new DateTimeDt(theDate);
        return this;
    }

    public ResourceReferenceDt getSubject() {
        if (this.mySubject == null) {
            this.mySubject = new ResourceReferenceDt();
        }
        return this.mySubject;
    }

    public DeviceUseStatement setSubject(ResourceReferenceDt theValue) {
        this.mySubject = theValue;
        return this;
    }

    public IDatatype getTiming() {
        return this.myTiming;
    }

    public DeviceUseStatement setTiming(IDatatype theValue) {
        this.myTiming = theValue;
        return this;
    }

    public String getResourceName() {
        return "DeviceUseStatement";
    }

    public FhirVersionEnum getStructureFhirVersionEnum() {
        return FhirVersionEnum.DSTU2;
    }
}

