/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.model.dstu2.resource;

import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.model.api.BaseIdentifiableElement;
import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.IResource;
import ca.uhn.fhir.model.api.IResourceBlock;
import ca.uhn.fhir.model.api.TemporalPrecisionEnum;
import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.model.dstu2.composite.ContactPointDt;
import ca.uhn.fhir.model.dstu2.resource.BaseResource;
import ca.uhn.fhir.model.dstu2.valueset.ConformanceResourceStatusEnum;
import ca.uhn.fhir.model.dstu2.valueset.ResourceTypeEnum;
import ca.uhn.fhir.model.dstu2.valueset.SearchParamTypeEnum;
import ca.uhn.fhir.model.dstu2.valueset.XPathUsageTypeEnum;
import ca.uhn.fhir.model.primitive.BooleanDt;
import ca.uhn.fhir.model.primitive.BoundCodeDt;
import ca.uhn.fhir.model.primitive.CodeDt;
import ca.uhn.fhir.model.primitive.DateTimeDt;
import ca.uhn.fhir.model.primitive.StringDt;
import ca.uhn.fhir.model.primitive.UriDt;
import ca.uhn.fhir.rest.gclient.StringClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.rest.gclient.UriClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@ResourceDef(name="SearchParameter", profile="http://hl7.org/fhir/profiles/SearchParameter", id="searchparameter")
public class SearchParameter
extends BaseResource
implements IResource {
    @SearchParamDefinition(name="url", path="SearchParameter.url", description="", type="uri")
    public static final String SP_URL = "url";
    public static final UriClientParam URL = new UriClientParam("url");
    @SearchParamDefinition(name="name", path="SearchParameter.name", description="", type="string")
    public static final String SP_NAME = "name";
    public static final StringClientParam NAME = new StringClientParam("name");
    @SearchParamDefinition(name="base", path="SearchParameter.base", description="", type="token")
    public static final String SP_BASE = "base";
    public static final TokenClientParam BASE = new TokenClientParam("base");
    @SearchParamDefinition(name="type", path="SearchParameter.type", description="", type="token")
    public static final String SP_TYPE = "type";
    public static final TokenClientParam TYPE = new TokenClientParam("type");
    @SearchParamDefinition(name="description", path="SearchParameter.description", description="", type="string")
    public static final String SP_DESCRIPTION = "description";
    public static final StringClientParam DESCRIPTION = new StringClientParam("description");
    @SearchParamDefinition(name="target", path="SearchParameter.target", description="", type="token")
    public static final String SP_TARGET = "target";
    public static final TokenClientParam TARGET = new TokenClientParam("target");
    @SearchParamDefinition(name="code", path="SearchParameter.code", description="", type="token")
    public static final String SP_CODE = "code";
    public static final TokenClientParam CODE = new TokenClientParam("code");
    @Child(name="url", type={UriDt.class}, order=0, min=1, max=1, summary=true, modifier=false)
    @Description(shortDefinition="id", formalDefinition="An absolute URL that is used to identify this search parameter when it is referenced in a specification, model, design or an instance. This SHALL be a URL, SHOULD be globally unique, and SHOULD be an address at which this search parameter is (or will be) published")
    private UriDt myUrl;
    @Child(name="name", type={StringDt.class}, order=1, min=1, max=1, summary=true, modifier=false)
    @Description(shortDefinition="", formalDefinition="A free text natural language name identifying the search parameter")
    private StringDt myName;
    @Child(name="status", type={CodeDt.class}, order=2, min=0, max=1, summary=true, modifier=false)
    @Description(shortDefinition="status", formalDefinition="The status of this search parameter definition")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/conformance-resource-status")
    private BoundCodeDt<ConformanceResourceStatusEnum> myStatus;
    @Child(name="experimental", type={BooleanDt.class}, order=3, min=0, max=1, summary=true, modifier=false)
    @Description(shortDefinition="class", formalDefinition="A flag to indicate that this search parameter definition is authored for testing purposes (or education/evaluation/marketing), and is not intended to be used for genuine usage")
    private BooleanDt myExperimental;
    @Child(name="publisher", type={StringDt.class}, order=4, min=0, max=1, summary=true, modifier=false)
    @Description(shortDefinition="who.witness", formalDefinition="The name of the individual or organization that published the search parameter")
    private StringDt myPublisher;
    @Child(name="contact", order=5, min=0, max=-1, summary=true, modifier=false)
    @Description(shortDefinition="", formalDefinition="Contacts to assist a user in finding and communicating with the publisher")
    private List<Contact> myContact;
    @Child(name="date", type={DateTimeDt.class}, order=6, min=0, max=1, summary=true, modifier=false)
    @Description(shortDefinition="when.recorded", formalDefinition="The date  (and optionally time) when the search parameter definition was published. The date must change when the business version changes, if it does, and it must change if the status code changes. In addition, it should change when the substantive content of the search parameter changes")
    private DateTimeDt myDate;
    @Child(name="requirements", type={StringDt.class}, order=7, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="why", formalDefinition="The Scope and Usage that this search parameter was created to meet")
    private StringDt myRequirements;
    @Child(name="code", type={CodeDt.class}, order=8, min=1, max=1, summary=true, modifier=false)
    @Description(shortDefinition="", formalDefinition="The code used in the URL or the parameter name in a parameters resource for this search parameter")
    private CodeDt myCode;
    @Child(name="base", type={CodeDt.class}, order=9, min=1, max=1, summary=true, modifier=false)
    @Description(shortDefinition="", formalDefinition="The base resource type that this search parameter refers to")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/resource-types")
    private BoundCodeDt<ResourceTypeEnum> myBase;
    @Child(name="type", type={CodeDt.class}, order=10, min=1, max=1, summary=true, modifier=false)
    @Description(shortDefinition="", formalDefinition="The type of value a search parameter refers to, and how the content is interpreted")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/search-param-type")
    private BoundCodeDt<SearchParamTypeEnum> myType;
    @Child(name="description", type={StringDt.class}, order=11, min=1, max=1, summary=true, modifier=false)
    @Description(shortDefinition="", formalDefinition="A description of the search parameters and how it used")
    private StringDt myDescription;
    @Child(name="xpath", type={StringDt.class}, order=12, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="An XPath expression that returns a set of elements for the search parameter")
    private StringDt myXpath;
    @Child(name="xpathUsage", type={CodeDt.class}, order=13, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="How the search parameter relates to the set of elements returned by evaluating the xpath query")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/search-xpath-usage")
    private BoundCodeDt<XPathUsageTypeEnum> myXpathUsage;
    @Child(name="target", type={CodeDt.class}, order=14, min=0, max=-1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="Types of resource (if a resource is referenced)")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/resource-types")
    private List<BoundCodeDt<ResourceTypeEnum>> myTarget;

    public boolean isEmpty() {
        return super.isBaseEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.myUrl, this.myName, this.myStatus, this.myExperimental, this.myPublisher, this.myContact, this.myDate, this.myRequirements, this.myCode, this.myBase, this.myType, this.myDescription, this.myXpath, this.myXpathUsage, this.myTarget});
    }

    public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
        return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myUrl, this.myName, this.myStatus, this.myExperimental, this.myPublisher, this.myContact, this.myDate, this.myRequirements, this.myCode, this.myBase, this.myType, this.myDescription, this.myXpath, this.myXpathUsage, this.myTarget});
    }

    public UriDt getUrlElement() {
        if (this.myUrl == null) {
            this.myUrl = new UriDt();
        }
        return this.myUrl;
    }

    public String getUrl() {
        return (String)this.getUrlElement().getValue();
    }

    public SearchParameter setUrl(UriDt theValue) {
        this.myUrl = theValue;
        return this;
    }

    public SearchParameter setUrl(String theUri) {
        this.myUrl = new UriDt(theUri);
        return this;
    }

    public StringDt getNameElement() {
        if (this.myName == null) {
            this.myName = new StringDt();
        }
        return this.myName;
    }

    public String getName() {
        return (String)this.getNameElement().getValue();
    }

    public SearchParameter setName(StringDt theValue) {
        this.myName = theValue;
        return this;
    }

    public SearchParameter setName(String theString) {
        this.myName = new StringDt(theString);
        return this;
    }

    public BoundCodeDt<ConformanceResourceStatusEnum> getStatusElement() {
        if (this.myStatus == null) {
            this.myStatus = new BoundCodeDt(ConformanceResourceStatusEnum.VALUESET_BINDER);
        }
        return this.myStatus;
    }

    public String getStatus() {
        return (String)this.getStatusElement().getValue();
    }

    public SearchParameter setStatus(BoundCodeDt<ConformanceResourceStatusEnum> theValue) {
        this.myStatus = theValue;
        return this;
    }

    public SearchParameter setStatus(ConformanceResourceStatusEnum theValue) {
        this.setStatus((BoundCodeDt<ConformanceResourceStatusEnum>)new BoundCodeDt(ConformanceResourceStatusEnum.VALUESET_BINDER, (Enum)theValue));
        return this;
    }

    public BooleanDt getExperimentalElement() {
        if (this.myExperimental == null) {
            this.myExperimental = new BooleanDt();
        }
        return this.myExperimental;
    }

    public Boolean getExperimental() {
        return (Boolean)this.getExperimentalElement().getValue();
    }

    public SearchParameter setExperimental(BooleanDt theValue) {
        this.myExperimental = theValue;
        return this;
    }

    public SearchParameter setExperimental(boolean theBoolean) {
        this.myExperimental = new BooleanDt(theBoolean);
        return this;
    }

    public StringDt getPublisherElement() {
        if (this.myPublisher == null) {
            this.myPublisher = new StringDt();
        }
        return this.myPublisher;
    }

    public String getPublisher() {
        return (String)this.getPublisherElement().getValue();
    }

    public SearchParameter setPublisher(StringDt theValue) {
        this.myPublisher = theValue;
        return this;
    }

    public SearchParameter setPublisher(String theString) {
        this.myPublisher = new StringDt(theString);
        return this;
    }

    public List<Contact> getContact() {
        if (this.myContact == null) {
            this.myContact = new ArrayList<Contact>();
        }
        return this.myContact;
    }

    public SearchParameter setContact(List<Contact> theValue) {
        this.myContact = theValue;
        return this;
    }

    public Contact addContact() {
        Contact newType = new Contact();
        this.getContact().add(newType);
        return newType;
    }

    public SearchParameter addContact(Contact theValue) {
        if (theValue == null) {
            throw new NullPointerException("theValue must not be null");
        }
        this.getContact().add(theValue);
        return this;
    }

    public Contact getContactFirstRep() {
        if (this.getContact().isEmpty()) {
            return this.addContact();
        }
        return this.getContact().get(0);
    }

    public DateTimeDt getDateElement() {
        if (this.myDate == null) {
            this.myDate = new DateTimeDt();
        }
        return this.myDate;
    }

    public Date getDate() {
        return (Date)this.getDateElement().getValue();
    }

    public SearchParameter setDate(DateTimeDt theValue) {
        this.myDate = theValue;
        return this;
    }

    public SearchParameter setDate(Date theDate, TemporalPrecisionEnum thePrecision) {
        this.myDate = new DateTimeDt(theDate, thePrecision);
        return this;
    }

    public SearchParameter setDateWithSecondsPrecision(Date theDate) {
        this.myDate = new DateTimeDt(theDate);
        return this;
    }

    public StringDt getRequirementsElement() {
        if (this.myRequirements == null) {
            this.myRequirements = new StringDt();
        }
        return this.myRequirements;
    }

    public String getRequirements() {
        return (String)this.getRequirementsElement().getValue();
    }

    public SearchParameter setRequirements(StringDt theValue) {
        this.myRequirements = theValue;
        return this;
    }

    public SearchParameter setRequirements(String theString) {
        this.myRequirements = new StringDt(theString);
        return this;
    }

    public CodeDt getCodeElement() {
        if (this.myCode == null) {
            this.myCode = new CodeDt();
        }
        return this.myCode;
    }

    public String getCode() {
        return (String)this.getCodeElement().getValue();
    }

    public SearchParameter setCode(CodeDt theValue) {
        this.myCode = theValue;
        return this;
    }

    public SearchParameter setCode(String theCode) {
        this.myCode = new CodeDt(theCode);
        return this;
    }

    public BoundCodeDt<ResourceTypeEnum> getBaseElement() {
        if (this.myBase == null) {
            this.myBase = new BoundCodeDt(ResourceTypeEnum.VALUESET_BINDER);
        }
        return this.myBase;
    }

    public String getBase() {
        return (String)this.getBaseElement().getValue();
    }

    public SearchParameter setBase(BoundCodeDt<ResourceTypeEnum> theValue) {
        this.myBase = theValue;
        return this;
    }

    public SearchParameter setBase(ResourceTypeEnum theValue) {
        this.setBase((BoundCodeDt<ResourceTypeEnum>)new BoundCodeDt(ResourceTypeEnum.VALUESET_BINDER, (Enum)theValue));
        return this;
    }

    public BoundCodeDt<SearchParamTypeEnum> getTypeElement() {
        if (this.myType == null) {
            this.myType = new BoundCodeDt(SearchParamTypeEnum.VALUESET_BINDER);
        }
        return this.myType;
    }

    public String getType() {
        return (String)this.getTypeElement().getValue();
    }

    public SearchParameter setType(BoundCodeDt<SearchParamTypeEnum> theValue) {
        this.myType = theValue;
        return this;
    }

    public SearchParameter setType(SearchParamTypeEnum theValue) {
        this.setType((BoundCodeDt<SearchParamTypeEnum>)new BoundCodeDt(SearchParamTypeEnum.VALUESET_BINDER, (Enum)theValue));
        return this;
    }

    public StringDt getDescriptionElement() {
        if (this.myDescription == null) {
            this.myDescription = new StringDt();
        }
        return this.myDescription;
    }

    public String getDescription() {
        return (String)this.getDescriptionElement().getValue();
    }

    public SearchParameter setDescription(StringDt theValue) {
        this.myDescription = theValue;
        return this;
    }

    public SearchParameter setDescription(String theString) {
        this.myDescription = new StringDt(theString);
        return this;
    }

    public StringDt getXpathElement() {
        if (this.myXpath == null) {
            this.myXpath = new StringDt();
        }
        return this.myXpath;
    }

    public String getXpath() {
        return (String)this.getXpathElement().getValue();
    }

    public SearchParameter setXpath(StringDt theValue) {
        this.myXpath = theValue;
        return this;
    }

    public SearchParameter setXpath(String theString) {
        this.myXpath = new StringDt(theString);
        return this;
    }

    public BoundCodeDt<XPathUsageTypeEnum> getXpathUsageElement() {
        if (this.myXpathUsage == null) {
            this.myXpathUsage = new BoundCodeDt(XPathUsageTypeEnum.VALUESET_BINDER);
        }
        return this.myXpathUsage;
    }

    public String getXpathUsage() {
        return (String)this.getXpathUsageElement().getValue();
    }

    public SearchParameter setXpathUsage(BoundCodeDt<XPathUsageTypeEnum> theValue) {
        this.myXpathUsage = theValue;
        return this;
    }

    public SearchParameter setXpathUsage(XPathUsageTypeEnum theValue) {
        this.setXpathUsage((BoundCodeDt<XPathUsageTypeEnum>)new BoundCodeDt(XPathUsageTypeEnum.VALUESET_BINDER, (Enum)theValue));
        return this;
    }

    public List<BoundCodeDt<ResourceTypeEnum>> getTarget() {
        if (this.myTarget == null) {
            this.myTarget = new ArrayList<BoundCodeDt<ResourceTypeEnum>>();
        }
        return this.myTarget;
    }

    public SearchParameter setTarget(List<BoundCodeDt<ResourceTypeEnum>> theValue) {
        this.myTarget = theValue;
        return this;
    }

    public BoundCodeDt<ResourceTypeEnum> addTarget(ResourceTypeEnum theValue) {
        BoundCodeDt retVal = new BoundCodeDt(ResourceTypeEnum.VALUESET_BINDER, (Enum)theValue);
        this.getTarget().add((BoundCodeDt<ResourceTypeEnum>)retVal);
        return retVal;
    }

    public BoundCodeDt<ResourceTypeEnum> getTargetFirstRep() {
        if (this.getTarget().size() == 0) {
            this.addTarget();
        }
        return this.getTarget().get(0);
    }

    public BoundCodeDt<ResourceTypeEnum> addTarget() {
        BoundCodeDt retVal = new BoundCodeDt(ResourceTypeEnum.VALUESET_BINDER);
        this.getTarget().add((BoundCodeDt<ResourceTypeEnum>)retVal);
        return retVal;
    }

    public SearchParameter setTarget(ResourceTypeEnum theValue) {
        this.getTarget().clear();
        this.addTarget(theValue);
        return this;
    }

    public String getResourceName() {
        return "SearchParameter";
    }

    public FhirVersionEnum getStructureFhirVersionEnum() {
        return FhirVersionEnum.DSTU2;
    }

    @Block
    public static class Contact
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="name", type={StringDt.class}, order=0, min=0, max=1, summary=true, modifier=false)
        @Description(shortDefinition="", formalDefinition="The name of an individual to contact regarding the search parameter")
        private StringDt myName;
        @Child(name="telecom", type={ContactPointDt.class}, order=1, min=0, max=-1, summary=true, modifier=false)
        @Description(shortDefinition="", formalDefinition="Contact details for individual (if a name was provided) or the publisher")
        private List<ContactPointDt> myTelecom;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.myName, this.myTelecom});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myName, this.myTelecom});
        }

        public StringDt getNameElement() {
            if (this.myName == null) {
                this.myName = new StringDt();
            }
            return this.myName;
        }

        public String getName() {
            return (String)this.getNameElement().getValue();
        }

        public Contact setName(StringDt theValue) {
            this.myName = theValue;
            return this;
        }

        public Contact setName(String theString) {
            this.myName = new StringDt(theString);
            return this;
        }

        public List<ContactPointDt> getTelecom() {
            if (this.myTelecom == null) {
                this.myTelecom = new ArrayList<ContactPointDt>();
            }
            return this.myTelecom;
        }

        public Contact setTelecom(List<ContactPointDt> theValue) {
            this.myTelecom = theValue;
            return this;
        }

        public ContactPointDt addTelecom() {
            ContactPointDt newType = new ContactPointDt();
            this.getTelecom().add(newType);
            return newType;
        }

        public Contact addTelecom(ContactPointDt theValue) {
            if (theValue == null) {
                throw new NullPointerException("theValue must not be null");
            }
            this.getTelecom().add(theValue);
            return this;
        }

        public ContactPointDt getTelecomFirstRep() {
            if (this.getTelecom().isEmpty()) {
                return this.addTelecom();
            }
            return this.getTelecom().get(0);
        }
    }
}

