/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.model.dstu2.resource;

import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.IResource;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.TemporalPrecisionEnum;
import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.model.dstu2.composite.AnnotationDt;
import ca.uhn.fhir.model.dstu2.composite.CodeableConceptDt;
import ca.uhn.fhir.model.dstu2.composite.ContactPointDt;
import ca.uhn.fhir.model.dstu2.composite.IdentifierDt;
import ca.uhn.fhir.model.dstu2.composite.ResourceReferenceDt;
import ca.uhn.fhir.model.dstu2.resource.BaseResource;
import ca.uhn.fhir.model.dstu2.resource.Location;
import ca.uhn.fhir.model.dstu2.resource.Organization;
import ca.uhn.fhir.model.dstu2.resource.Patient;
import ca.uhn.fhir.model.dstu2.valueset.DeviceStatusEnum;
import ca.uhn.fhir.model.primitive.BoundCodeDt;
import ca.uhn.fhir.model.primitive.CodeDt;
import ca.uhn.fhir.model.primitive.DateTimeDt;
import ca.uhn.fhir.model.primitive.StringDt;
import ca.uhn.fhir.model.primitive.UriDt;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.StringClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.rest.gclient.UriClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@ResourceDef(name="Device", profile="http://hl7.org/fhir/profiles/Device", id="device")
public class Device
extends BaseResource
implements IResource {
    @SearchParamDefinition(name="type", path="Device.type", description="The type of the device", type="token")
    public static final String SP_TYPE = "type";
    public static final TokenClientParam TYPE = new TokenClientParam("type");
    @SearchParamDefinition(name="manufacturer", path="Device.manufacturer", description="The manufacturer of the device", type="string")
    public static final String SP_MANUFACTURER = "manufacturer";
    public static final StringClientParam MANUFACTURER = new StringClientParam("manufacturer");
    @SearchParamDefinition(name="model", path="Device.model", description="The model of the device", type="string")
    public static final String SP_MODEL = "model";
    public static final StringClientParam MODEL = new StringClientParam("model");
    @SearchParamDefinition(name="organization", path="Device.owner", description="The organization responsible for the device", type="reference")
    public static final String SP_ORGANIZATION = "organization";
    public static final ReferenceClientParam ORGANIZATION = new ReferenceClientParam("organization");
    @SearchParamDefinition(name="identifier", path="Device.identifier", description="Instance id from manufacturer, owner, and others", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="location", path="Device.location", description="A location, where the resource is found", type="reference")
    public static final String SP_LOCATION = "location";
    public static final ReferenceClientParam LOCATION = new ReferenceClientParam("location");
    @SearchParamDefinition(name="patient", path="Device.patient", description="Patient information, if the resource is affixed to a person", type="reference")
    public static final String SP_PATIENT = "patient";
    public static final ReferenceClientParam PATIENT = new ReferenceClientParam("patient");
    @SearchParamDefinition(name="udi", path="Device.udi", description="FDA mandated Unique Device Identifier", type="string")
    public static final String SP_UDI = "udi";
    public static final StringClientParam UDI = new StringClientParam("udi");
    @SearchParamDefinition(name="url", path="Device.url", description="Network address to contact device", type="uri")
    public static final String SP_URL = "url";
    public static final UriClientParam URL = new UriClientParam("url");
    public static final Include INCLUDE_LOCATION = new Include("Device:location");
    public static final Include INCLUDE_ORGANIZATION = new Include("Device:organization");
    public static final Include INCLUDE_PATIENT = new Include("Device:patient");
    @Child(name="identifier", type={IdentifierDt.class}, order=0, min=0, max=-1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="Unique instance identifiers assigned to a device by organizations like manufacturers or owners. If the identifier identifies the type of device, Device.type should be used.")
    private List<IdentifierDt> myIdentifier;
    @Child(name="type", type={CodeableConceptDt.class}, order=1, min=1, max=1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="Code or identifier to identify a kind of device.")
    @Binding(valueSet="https://www.gmdnagency.org/Info.aspx?pageid=1091")
    private CodeableConceptDt myType;
    @Child(name="note", type={AnnotationDt.class}, order=2, min=0, max=-1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="Descriptive information, usage information or implantation information that is not captured in an existing element.")
    private List<AnnotationDt> myNote;
    @Child(name="status", type={CodeDt.class}, order=3, min=0, max=1, summary=true, modifier=true)
    @Description(shortDefinition="", formalDefinition="Status of the Device availability.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/devicestatus")
    private BoundCodeDt<DeviceStatusEnum> myStatus;
    @Child(name="manufacturer", type={StringDt.class}, order=4, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="A name of the manufacturer")
    private StringDt myManufacturer;
    @Child(name="model", type={StringDt.class}, order=5, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="The \"model\" is an identifier assigned by the manufacturer to identify the product by its type. This number is shared by the all devices sold as the same type.")
    private StringDt myModel;
    @Child(name="version", type={StringDt.class}, order=6, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="The version of the device, if the device has multiple releases under the same model, or if the device is software or carries firmware.")
    private StringDt myVersion;
    @Child(name="manufactureDate", type={DateTimeDt.class}, order=7, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="The date and time when the device was manufactured.")
    private DateTimeDt myManufactureDate;
    @Child(name="expiry", type={DateTimeDt.class}, order=8, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="The date and time beyond which this device is no longer valid or should not be used (if applicable)")
    private DateTimeDt myExpiry;
    @Child(name="udi", type={StringDt.class}, order=9, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="United States Food and Drug Administration mandated Unique Device Identifier (UDI). Use the human readable information (the content that the user sees, which is sometimes different to the exact syntax represented in the barcode)  - see http://www.fda.gov/MedicalDevices/DeviceRegulationandGuidance/UniqueDeviceIdentification/default.htm")
    private StringDt myUdi;
    @Child(name="lotNumber", type={StringDt.class}, order=10, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="Lot number assigned by the manufacturer")
    private StringDt myLotNumber;
    @Child(name="owner", order=11, min=0, max=1, summary=false, modifier=false, type={Organization.class})
    @Description(shortDefinition="", formalDefinition="An organization that is responsible for the provision and ongoing maintenance of the device.")
    private ResourceReferenceDt myOwner;
    @Child(name="location", order=12, min=0, max=1, summary=false, modifier=false, type={Location.class})
    @Description(shortDefinition="", formalDefinition="The place where the device can be found.")
    private ResourceReferenceDt myLocation;
    @Child(name="patient", order=13, min=0, max=1, summary=false, modifier=false, type={Patient.class})
    @Description(shortDefinition="", formalDefinition="Patient information, if the resource is affixed to a person")
    private ResourceReferenceDt myPatient;
    @Child(name="contact", type={ContactPointDt.class}, order=14, min=0, max=-1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="Contact details for an organization or a particular human that is responsible for the device")
    private List<ContactPointDt> myContact;
    @Child(name="url", type={UriDt.class}, order=15, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="A network address on which the device may be contacted directly")
    private UriDt myUrl;

    public boolean isEmpty() {
        return super.isBaseEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.myIdentifier, this.myType, this.myNote, this.myStatus, this.myManufacturer, this.myModel, this.myVersion, this.myManufactureDate, this.myExpiry, this.myUdi, this.myLotNumber, this.myOwner, this.myLocation, this.myPatient, this.myContact, this.myUrl});
    }

    public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
        return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myIdentifier, this.myType, this.myNote, this.myStatus, this.myManufacturer, this.myModel, this.myVersion, this.myManufactureDate, this.myExpiry, this.myUdi, this.myLotNumber, this.myOwner, this.myLocation, this.myPatient, this.myContact, this.myUrl});
    }

    public List<IdentifierDt> getIdentifier() {
        if (this.myIdentifier == null) {
            this.myIdentifier = new ArrayList<IdentifierDt>();
        }
        return this.myIdentifier;
    }

    public Device setIdentifier(List<IdentifierDt> theValue) {
        this.myIdentifier = theValue;
        return this;
    }

    public IdentifierDt addIdentifier() {
        IdentifierDt newType = new IdentifierDt();
        this.getIdentifier().add(newType);
        return newType;
    }

    public Device addIdentifier(IdentifierDt theValue) {
        if (theValue == null) {
            throw new NullPointerException("theValue must not be null");
        }
        this.getIdentifier().add(theValue);
        return this;
    }

    public IdentifierDt getIdentifierFirstRep() {
        if (this.getIdentifier().isEmpty()) {
            return this.addIdentifier();
        }
        return this.getIdentifier().get(0);
    }

    public CodeableConceptDt getType() {
        if (this.myType == null) {
            this.myType = new CodeableConceptDt();
        }
        return this.myType;
    }

    public Device setType(CodeableConceptDt theValue) {
        this.myType = theValue;
        return this;
    }

    public List<AnnotationDt> getNote() {
        if (this.myNote == null) {
            this.myNote = new ArrayList<AnnotationDt>();
        }
        return this.myNote;
    }

    public Device setNote(List<AnnotationDt> theValue) {
        this.myNote = theValue;
        return this;
    }

    public AnnotationDt addNote() {
        AnnotationDt newType = new AnnotationDt();
        this.getNote().add(newType);
        return newType;
    }

    public Device addNote(AnnotationDt theValue) {
        if (theValue == null) {
            throw new NullPointerException("theValue must not be null");
        }
        this.getNote().add(theValue);
        return this;
    }

    public AnnotationDt getNoteFirstRep() {
        if (this.getNote().isEmpty()) {
            return this.addNote();
        }
        return this.getNote().get(0);
    }

    public BoundCodeDt<DeviceStatusEnum> getStatusElement() {
        if (this.myStatus == null) {
            this.myStatus = new BoundCodeDt(DeviceStatusEnum.VALUESET_BINDER);
        }
        return this.myStatus;
    }

    public String getStatus() {
        return (String)this.getStatusElement().getValue();
    }

    public Device setStatus(BoundCodeDt<DeviceStatusEnum> theValue) {
        this.myStatus = theValue;
        return this;
    }

    public Device setStatus(DeviceStatusEnum theValue) {
        this.setStatus((BoundCodeDt<DeviceStatusEnum>)new BoundCodeDt(DeviceStatusEnum.VALUESET_BINDER, (Enum)theValue));
        return this;
    }

    public StringDt getManufacturerElement() {
        if (this.myManufacturer == null) {
            this.myManufacturer = new StringDt();
        }
        return this.myManufacturer;
    }

    public String getManufacturer() {
        return (String)this.getManufacturerElement().getValue();
    }

    public Device setManufacturer(StringDt theValue) {
        this.myManufacturer = theValue;
        return this;
    }

    public Device setManufacturer(String theString) {
        this.myManufacturer = new StringDt(theString);
        return this;
    }

    public StringDt getModelElement() {
        if (this.myModel == null) {
            this.myModel = new StringDt();
        }
        return this.myModel;
    }

    public String getModel() {
        return (String)this.getModelElement().getValue();
    }

    public Device setModel(StringDt theValue) {
        this.myModel = theValue;
        return this;
    }

    public Device setModel(String theString) {
        this.myModel = new StringDt(theString);
        return this;
    }

    public StringDt getVersionElement() {
        if (this.myVersion == null) {
            this.myVersion = new StringDt();
        }
        return this.myVersion;
    }

    public String getVersion() {
        return (String)this.getVersionElement().getValue();
    }

    public Device setVersion(StringDt theValue) {
        this.myVersion = theValue;
        return this;
    }

    public Device setVersion(String theString) {
        this.myVersion = new StringDt(theString);
        return this;
    }

    public DateTimeDt getManufactureDateElement() {
        if (this.myManufactureDate == null) {
            this.myManufactureDate = new DateTimeDt();
        }
        return this.myManufactureDate;
    }

    public Date getManufactureDate() {
        return (Date)this.getManufactureDateElement().getValue();
    }

    public Device setManufactureDate(DateTimeDt theValue) {
        this.myManufactureDate = theValue;
        return this;
    }

    public Device setManufactureDate(Date theDate, TemporalPrecisionEnum thePrecision) {
        this.myManufactureDate = new DateTimeDt(theDate, thePrecision);
        return this;
    }

    public Device setManufactureDateWithSecondsPrecision(Date theDate) {
        this.myManufactureDate = new DateTimeDt(theDate);
        return this;
    }

    public DateTimeDt getExpiryElement() {
        if (this.myExpiry == null) {
            this.myExpiry = new DateTimeDt();
        }
        return this.myExpiry;
    }

    public Date getExpiry() {
        return (Date)this.getExpiryElement().getValue();
    }

    public Device setExpiry(DateTimeDt theValue) {
        this.myExpiry = theValue;
        return this;
    }

    public Device setExpiry(Date theDate, TemporalPrecisionEnum thePrecision) {
        this.myExpiry = new DateTimeDt(theDate, thePrecision);
        return this;
    }

    public Device setExpiryWithSecondsPrecision(Date theDate) {
        this.myExpiry = new DateTimeDt(theDate);
        return this;
    }

    public StringDt getUdiElement() {
        if (this.myUdi == null) {
            this.myUdi = new StringDt();
        }
        return this.myUdi;
    }

    public String getUdi() {
        return (String)this.getUdiElement().getValue();
    }

    public Device setUdi(StringDt theValue) {
        this.myUdi = theValue;
        return this;
    }

    public Device setUdi(String theString) {
        this.myUdi = new StringDt(theString);
        return this;
    }

    public StringDt getLotNumberElement() {
        if (this.myLotNumber == null) {
            this.myLotNumber = new StringDt();
        }
        return this.myLotNumber;
    }

    public String getLotNumber() {
        return (String)this.getLotNumberElement().getValue();
    }

    public Device setLotNumber(StringDt theValue) {
        this.myLotNumber = theValue;
        return this;
    }

    public Device setLotNumber(String theString) {
        this.myLotNumber = new StringDt(theString);
        return this;
    }

    public ResourceReferenceDt getOwner() {
        if (this.myOwner == null) {
            this.myOwner = new ResourceReferenceDt();
        }
        return this.myOwner;
    }

    public Device setOwner(ResourceReferenceDt theValue) {
        this.myOwner = theValue;
        return this;
    }

    public ResourceReferenceDt getLocation() {
        if (this.myLocation == null) {
            this.myLocation = new ResourceReferenceDt();
        }
        return this.myLocation;
    }

    public Device setLocation(ResourceReferenceDt theValue) {
        this.myLocation = theValue;
        return this;
    }

    public ResourceReferenceDt getPatient() {
        if (this.myPatient == null) {
            this.myPatient = new ResourceReferenceDt();
        }
        return this.myPatient;
    }

    public Device setPatient(ResourceReferenceDt theValue) {
        this.myPatient = theValue;
        return this;
    }

    public List<ContactPointDt> getContact() {
        if (this.myContact == null) {
            this.myContact = new ArrayList<ContactPointDt>();
        }
        return this.myContact;
    }

    public Device setContact(List<ContactPointDt> theValue) {
        this.myContact = theValue;
        return this;
    }

    public ContactPointDt addContact() {
        ContactPointDt newType = new ContactPointDt();
        this.getContact().add(newType);
        return newType;
    }

    public Device addContact(ContactPointDt theValue) {
        if (theValue == null) {
            throw new NullPointerException("theValue must not be null");
        }
        this.getContact().add(theValue);
        return this;
    }

    public ContactPointDt getContactFirstRep() {
        if (this.getContact().isEmpty()) {
            return this.addContact();
        }
        return this.getContact().get(0);
    }

    public UriDt getUrlElement() {
        if (this.myUrl == null) {
            this.myUrl = new UriDt();
        }
        return this.myUrl;
    }

    public String getUrl() {
        return (String)this.getUrlElement().getValue();
    }

    public Device setUrl(UriDt theValue) {
        this.myUrl = theValue;
        return this;
    }

    public Device setUrl(String theUri) {
        this.myUrl = new UriDt(theUri);
        return this;
    }

    public String getResourceName() {
        return "Device";
    }

    public FhirVersionEnum getStructureFhirVersionEnum() {
        return FhirVersionEnum.DSTU2;
    }
}

