/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.model.dstu2.valueset;

import ca.uhn.fhir.model.api.IValueSetEnumBinder;
import java.util.HashMap;
import java.util.Map;

public enum AddressUseEnum {
    HOME("home", "http://hl7.org/fhir/address-use"),
    WORK("work", "http://hl7.org/fhir/address-use"),
    TEMPORARY("temp", "http://hl7.org/fhir/address-use"),
    OLD___INCORRECT("old", "http://hl7.org/fhir/address-use");

    public static final String VALUESET_IDENTIFIER = "";
    public static final String VALUESET_NAME = "AddressUse";
    private static Map<String, AddressUseEnum> CODE_TO_ENUM;
    private static Map<String, Map<String, AddressUseEnum>> SYSTEM_TO_CODE_TO_ENUM;
    private final String myCode;
    private final String mySystem;
    public static final IValueSetEnumBinder<AddressUseEnum> VALUESET_BINDER;

    public String getCode() {
        return this.myCode;
    }

    public String getSystem() {
        return this.mySystem;
    }

    public static AddressUseEnum forCode(String theCode) {
        AddressUseEnum retVal = CODE_TO_ENUM.get(theCode);
        return retVal;
    }

    private AddressUseEnum(String theCode, String theSystem) {
        this.myCode = theCode;
        this.mySystem = theSystem;
    }

    static {
        CODE_TO_ENUM = new HashMap<String, AddressUseEnum>();
        SYSTEM_TO_CODE_TO_ENUM = new HashMap<String, Map<String, AddressUseEnum>>();
        for (AddressUseEnum next : AddressUseEnum.values()) {
            CODE_TO_ENUM.put(next.getCode(), next);
            if (!SYSTEM_TO_CODE_TO_ENUM.containsKey(next.getSystem())) {
                SYSTEM_TO_CODE_TO_ENUM.put(next.getSystem(), new HashMap());
            }
            SYSTEM_TO_CODE_TO_ENUM.get(next.getSystem()).put(next.getCode(), next);
        }
        VALUESET_BINDER = new IValueSetEnumBinder<AddressUseEnum>(){

            public String toCodeString(AddressUseEnum theEnum) {
                return theEnum.getCode();
            }

            public String toSystemString(AddressUseEnum theEnum) {
                return theEnum.getSystem();
            }

            public AddressUseEnum fromCodeString(String theCodeString) {
                return (AddressUseEnum)((Object)CODE_TO_ENUM.get(theCodeString));
            }

            public AddressUseEnum fromCodeString(String theCodeString, String theSystemString) {
                Map map = (Map)SYSTEM_TO_CODE_TO_ENUM.get(theSystemString);
                if (map == null) {
                    return null;
                }
                return (AddressUseEnum)((Object)map.get(theCodeString));
            }
        };
    }
}

