/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.model.dstu2.valueset;

import ca.uhn.fhir.model.api.IValueSetEnumBinder;
import java.util.HashMap;
import java.util.Map;

public enum IssueSeverityEnum {
    FATAL("fatal", "http://hl7.org/fhir/issue-severity"),
    ERROR("error", "http://hl7.org/fhir/issue-severity"),
    WARNING("warning", "http://hl7.org/fhir/issue-severity"),
    INFORMATION("information", "http://hl7.org/fhir/issue-severity");

    public static final String VALUESET_IDENTIFIER = "";
    public static final String VALUESET_NAME = "IssueSeverity";
    private static Map<String, IssueSeverityEnum> CODE_TO_ENUM;
    private static Map<String, Map<String, IssueSeverityEnum>> SYSTEM_TO_CODE_TO_ENUM;
    private final String myCode;
    private final String mySystem;
    public static final IValueSetEnumBinder<IssueSeverityEnum> VALUESET_BINDER;

    public String getCode() {
        return this.myCode;
    }

    public String getSystem() {
        return this.mySystem;
    }

    public static IssueSeverityEnum forCode(String theCode) {
        IssueSeverityEnum retVal = CODE_TO_ENUM.get(theCode);
        return retVal;
    }

    private IssueSeverityEnum(String theCode, String theSystem) {
        this.myCode = theCode;
        this.mySystem = theSystem;
    }

    static {
        CODE_TO_ENUM = new HashMap<String, IssueSeverityEnum>();
        SYSTEM_TO_CODE_TO_ENUM = new HashMap<String, Map<String, IssueSeverityEnum>>();
        for (IssueSeverityEnum next : IssueSeverityEnum.values()) {
            CODE_TO_ENUM.put(next.getCode(), next);
            if (!SYSTEM_TO_CODE_TO_ENUM.containsKey(next.getSystem())) {
                SYSTEM_TO_CODE_TO_ENUM.put(next.getSystem(), new HashMap());
            }
            SYSTEM_TO_CODE_TO_ENUM.get(next.getSystem()).put(next.getCode(), next);
        }
        VALUESET_BINDER = new IValueSetEnumBinder<IssueSeverityEnum>(){

            public String toCodeString(IssueSeverityEnum theEnum) {
                return theEnum.getCode();
            }

            public String toSystemString(IssueSeverityEnum theEnum) {
                return theEnum.getSystem();
            }

            public IssueSeverityEnum fromCodeString(String theCodeString) {
                return (IssueSeverityEnum)((Object)CODE_TO_ENUM.get(theCodeString));
            }

            public IssueSeverityEnum fromCodeString(String theCodeString, String theSystemString) {
                Map map = (Map)SYSTEM_TO_CODE_TO_ENUM.get(theSystemString);
                if (map == null) {
                    return null;
                }
                return (IssueSeverityEnum)((Object)map.get(theCodeString));
            }
        };
    }
}

