/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2016may.hapi.validation;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.support.IContextValidationSupport;
import ca.uhn.fhir.rest.api.Constants;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.hl7.fhir.dstu2016may.hapi.validation.HapiWorkerContext;
import org.hl7.fhir.dstu2016may.hapi.validation.IValidationSupport;
import org.hl7.fhir.dstu2016may.model.Bundle;
import org.hl7.fhir.dstu2016may.model.CodeSystem;
import org.hl7.fhir.dstu2016may.model.CodeType;
import org.hl7.fhir.dstu2016may.model.DomainResource;
import org.hl7.fhir.dstu2016may.model.OperationOutcome;
import org.hl7.fhir.dstu2016may.model.StructureDefinition;
import org.hl7.fhir.dstu2016may.model.ValueSet;
import org.hl7.fhir.dstu2016may.terminologies.ValueSetExpander;
import org.hl7.fhir.dstu2016may.terminologies.ValueSetExpanderFactory;
import org.hl7.fhir.dstu2016may.terminologies.ValueSetExpanderSimple;
import org.hl7.fhir.dstu2016may.utils.IWorkerContext;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultProfileValidationSupport
implements IValidationSupport {
    private static final Logger ourLog = LoggerFactory.getLogger(DefaultProfileValidationSupport.class);
    private Map<String, CodeSystem> myCodeSystems;
    private Map<String, StructureDefinition> myStructureDefinitions;
    private Map<String, ValueSet> myValueSets;

    @Override
    public ValueSet.ValueSetExpansionComponent expandValueSet(FhirContext theContext, ValueSet.ConceptSetComponent theInclude) {
        ValueSet.ValueSetExpansionComponent retVal = new ValueSet.ValueSetExpansionComponent();
        HashSet<String> wantCodes = new HashSet<String>();
        for (ValueSet.ConceptReferenceComponent next : theInclude.getConcept()) {
            wantCodes.add(next.getCode());
        }
        CodeSystem system = this.fetchCodeSystem(theContext, theInclude.getSystem());
        for (CodeSystem.ConceptDefinitionComponent next : system.getConcept()) {
            if (!wantCodes.isEmpty() && !wantCodes.contains(next.getCode())) continue;
            retVal.addContains().setSystem(theInclude.getSystem()).setCode(next.getCode()).setDisplay(next.getDisplay());
        }
        return retVal;
    }

    public List<IBaseResource> fetchAllConformanceResources(FhirContext theContext) {
        ArrayList<IBaseResource> retVal = new ArrayList<IBaseResource>();
        retVal.addAll(this.myCodeSystems.values());
        retVal.addAll(this.myStructureDefinitions.values());
        retVal.addAll(this.myValueSets.values());
        return retVal;
    }

    @Override
    public List<StructureDefinition> fetchAllStructureDefinitions(FhirContext theContext) {
        return new ArrayList<StructureDefinition>(this.provideStructureDefinitionMap(theContext).values());
    }

    @Override
    public CodeSystem fetchCodeSystem(FhirContext theContext, String theSystem) {
        return (CodeSystem)this.fetchCodeSystemOrValueSet(theContext, theSystem, true);
    }

    private DomainResource fetchCodeSystemOrValueSet(FhirContext theContext, String theSystem, boolean codeSystem) {
        Map<String, CodeSystem> codeSystems = this.myCodeSystems;
        Map<String, ValueSet> valueSets = this.myValueSets;
        if (codeSystems == null) {
            codeSystems = new HashMap<String, CodeSystem>();
            valueSets = new HashMap<String, ValueSet>();
            this.loadCodeSystems(theContext, codeSystems, valueSets, "/org/hl7/fhir/dstu2016may/model/valueset/valuesets.xml");
            this.loadCodeSystems(theContext, codeSystems, valueSets, "/org/hl7/fhir/dstu2016may/model/valueset/v2-tables.xml");
            this.loadCodeSystems(theContext, codeSystems, valueSets, "/org/hl7/fhir/dstu2016may/model/valueset/v3-codesystems.xml");
            this.myCodeSystems = codeSystems;
            this.myValueSets = valueSets;
        }
        if (codeSystem) {
            return (DomainResource)codeSystems.get(theSystem);
        }
        return (DomainResource)valueSets.get(theSystem);
    }

    @Override
    public <T extends IBaseResource> T fetchResource(FhirContext theContext, Class<T> theClass, String theUri) {
        Validate.notBlank((CharSequence)theUri, (String)"theUri must not be null or blank", (Object[])new Object[0]);
        if (theUri.startsWith("http://hl7.org/fhir/StructureDefinition/")) {
            return (T)this.fetchStructureDefinition(theContext, theUri);
        }
        if (theUri.startsWith("http://hl7.org/fhir/ValueSet/")) {
            return (T)this.fetchValueSet(theContext, theUri);
        }
        return null;
    }

    @Override
    public StructureDefinition fetchStructureDefinition(FhirContext theContext, String theUrl) {
        return this.provideStructureDefinitionMap(theContext).get(theUrl);
    }

    @Override
    public ValueSet fetchValueSet(FhirContext theContext, String uri) {
        return (ValueSet)this.fetchCodeSystemOrValueSet(theContext, uri, false);
    }

    public void flush() {
        this.myCodeSystems = null;
        this.myStructureDefinitions = null;
    }

    @Override
    public boolean isCodeSystemSupported(FhirContext theContext, String theSystem) {
        CodeSystem cs = this.fetchCodeSystem(theContext, theSystem);
        return cs != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadCodeSystems(FhirContext theContext, Map<String, CodeSystem> theCodeSystems, Map<String, ValueSet> theValueSets, String theClasspath) {
        block5: {
            block4: {
                ourLog.info("Loading CodeSystem/ValueSet from classpath: {}", (Object)theClasspath);
                InputStream inputStream = DefaultProfileValidationSupport.class.getResourceAsStream(theClasspath);
                InputStreamReader reader = null;
                if (inputStream == null) break block4;
                try {
                    reader = new InputStreamReader(inputStream, StandardCharsets.UTF_8);
                    Bundle bundle = (Bundle)theContext.newXmlParser().parseResource(Bundle.class, (Reader)reader);
                    for (Bundle.BundleEntryComponent next : bundle.getEntry()) {
                        String system;
                        CodeSystem nextValueSet;
                        if (next.getResource() instanceof CodeSystem) {
                            nextValueSet = (CodeSystem)next.getResource();
                            nextValueSet.getText().setDivAsString("");
                            system = nextValueSet.getUrl();
                            if (!StringUtils.isNotBlank((CharSequence)system)) continue;
                            theCodeSystems.put(system, nextValueSet);
                            continue;
                        }
                        if (!(next.getResource() instanceof ValueSet)) continue;
                        nextValueSet = (ValueSet)next.getResource();
                        nextValueSet.getText().setDivAsString("");
                        system = nextValueSet.getUrl();
                        if (!StringUtils.isNotBlank((CharSequence)system)) continue;
                        theValueSets.put(system, (ValueSet)nextValueSet);
                    }
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(reader);
                    IOUtils.closeQuietly((InputStream)inputStream);
                    throw throwable;
                }
                IOUtils.closeQuietly((Reader)reader);
                IOUtils.closeQuietly((InputStream)inputStream);
                break block5;
            }
            ourLog.warn("Unable to load resource: {}", (Object)theClasspath);
        }
    }

    private void loadStructureDefinitions(FhirContext theContext, Map<String, StructureDefinition> theCodeSystems, String theClasspath) {
        ourLog.info("Loading structure definitions from classpath: {}", (Object)theClasspath);
        InputStream valuesetText = DefaultProfileValidationSupport.class.getResourceAsStream(theClasspath);
        if (valuesetText != null) {
            InputStreamReader reader = new InputStreamReader(valuesetText, StandardCharsets.UTF_8);
            Bundle bundle = (Bundle)theContext.newXmlParser().parseResource(Bundle.class, (Reader)reader);
            for (Bundle.BundleEntryComponent next : bundle.getEntry()) {
                if (!(next.getResource() instanceof StructureDefinition)) continue;
                StructureDefinition nextSd = (StructureDefinition)next.getResource();
                nextSd.getText().setDivAsString("");
                String system = nextSd.getUrl();
                if (!StringUtils.isNotBlank((CharSequence)system)) continue;
                theCodeSystems.put(system, nextSd);
            }
        } else {
            ourLog.warn("Unable to load resource: {}", (Object)theClasspath);
        }
    }

    private Map<String, StructureDefinition> provideStructureDefinitionMap(FhirContext theContext) {
        Map<String, StructureDefinition> structureDefinitions = this.myStructureDefinitions;
        if (structureDefinitions == null) {
            structureDefinitions = new HashMap<String, StructureDefinition>();
            this.loadStructureDefinitions(theContext, structureDefinitions, "/org/hl7/fhir/dstu2016may/model/profile/profiles-resources.xml");
            this.loadStructureDefinitions(theContext, structureDefinitions, "/org/hl7/fhir/dstu2016may/model/profile/profiles-types.xml");
            this.loadStructureDefinitions(theContext, structureDefinitions, "/org/hl7/fhir/dstu2016may/model/profile/profiles-others.xml");
            this.myStructureDefinitions = structureDefinitions;
        }
        return structureDefinitions;
    }

    private IContextValidationSupport.CodeValidationResult testIfConceptIsInList(String theCode, List<CodeSystem.ConceptDefinitionComponent> conceptList, boolean theCaseSensitive) {
        String code = theCode;
        if (!theCaseSensitive) {
            code = code.toUpperCase();
        }
        return this.testIfConceptIsInListInner(conceptList, theCaseSensitive, code);
    }

    private IContextValidationSupport.CodeValidationResult testIfConceptIsInListInner(List<CodeSystem.ConceptDefinitionComponent> conceptList, boolean theCaseSensitive, String code) {
        IContextValidationSupport.CodeValidationResult retVal = null;
        for (CodeSystem.ConceptDefinitionComponent next : conceptList) {
            String nextCandidate = next.getCode();
            if (!theCaseSensitive) {
                nextCandidate = nextCandidate.toUpperCase();
            }
            if (nextCandidate.equals(code)) {
                retVal = new IContextValidationSupport.CodeValidationResult(null, null, (IBase)next, next.getDisplay());
                break;
            }
            retVal = this.testIfConceptIsInList(code, next.getConcept(), theCaseSensitive);
            if (retVal == null) continue;
            break;
        }
        return retVal;
    }

    public IContextValidationSupport.CodeValidationResult validateCode(FhirContext theContext, String theCodeSystem, String theCode, String theDisplay, String theValueSetUrl) {
        CodeSystem cs;
        if (StringUtils.isNotBlank((CharSequence)theValueSetUrl)) {
            HapiWorkerContext workerContext = new HapiWorkerContext(theContext, this);
            ValueSetExpanderSimple expander = new ValueSetExpanderSimple((IWorkerContext)workerContext, (ValueSetExpanderFactory)workerContext);
            try {
                ValueSetExpander.ValueSetExpansionOutcome expanded;
                Optional<ValueSet.ValueSetExpansionContainsComponent> haveMatch;
                ValueSet valueSet = this.fetchValueSet(theContext, theValueSetUrl);
                if (valueSet != null && (haveMatch = (expanded = expander.expand(valueSet)).getValueset().getExpansion().getContains().stream().filter(t -> (Constants.codeSystemNotNeeded((String)theCodeSystem) || t.getSystem().equals(theCodeSystem)) && t.getCode().equals(theCode)).findFirst()).isPresent()) {
                    return new IContextValidationSupport.CodeValidationResult((IBase)new CodeSystem.ConceptDefinitionComponent(new CodeType(theCode)));
                }
            }
            catch (Exception e) {
                return new IContextValidationSupport.CodeValidationResult((Enum)OperationOutcome.IssueSeverity.WARNING, e.getMessage());
            }
            return null;
        }
        if (theCodeSystem != null && (cs = this.fetchCodeSystem(theContext, theCodeSystem)) != null) {
            IContextValidationSupport.CodeValidationResult retVal;
            boolean caseSensitive = true;
            if (cs.hasCaseSensitive()) {
                caseSensitive = cs.getCaseSensitive();
            }
            if ((retVal = this.testIfConceptIsInList(theCode, cs.getConcept(), caseSensitive)) != null) {
                return retVal;
            }
        }
        return new IContextValidationSupport.CodeValidationResult((Enum)OperationOutcome.IssueSeverity.WARNING, "Unknown code: " + theCodeSystem + " / " + theCode);
    }

    public IContextValidationSupport.LookupCodeResult lookupCode(FhirContext theContext, String theSystem, String theCode) {
        return this.validateCode(theContext, theSystem, theCode, null, null).asLookupCodeResult(theSystem, theCode);
    }
}

