/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2016may.hapi.validation;

import ca.uhn.fhir.context.FhirContext;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.dstu2016may.hapi.validation.IValidationSupport;
import org.hl7.fhir.dstu2016may.model.CodeSystem;
import org.hl7.fhir.dstu2016may.model.StructureDefinition;
import org.hl7.fhir.dstu2016may.model.ValueSet;
import org.hl7.fhir.instance.model.api.IBaseResource;

public class ValidationSupportChain
implements IValidationSupport {
    private List<IValidationSupport> myChain = new ArrayList<IValidationSupport>();

    public ValidationSupportChain() {
    }

    public ValidationSupportChain(IValidationSupport ... theValidationSupportModules) {
        this();
        for (IValidationSupport next : theValidationSupportModules) {
            if (next == null) continue;
            this.myChain.add(next);
        }
    }

    public void addValidationSupport(IValidationSupport theValidationSupport) {
        this.myChain.add(theValidationSupport);
    }

    @Override
    public ValueSet.ValueSetExpansionComponent expandValueSet(FhirContext theCtx, ValueSet.ConceptSetComponent theInclude) {
        for (IValidationSupport next : this.myChain) {
            if (!next.isCodeSystemSupported(theCtx, theInclude.getSystem())) continue;
            return next.expandValueSet(theCtx, theInclude);
        }
        return this.myChain.get(0).expandValueSet(theCtx, theInclude);
    }

    public List<IBaseResource> fetchAllConformanceResources(FhirContext theContext) {
        ArrayList<IBaseResource> retVal = new ArrayList<IBaseResource>();
        for (IValidationSupport next : this.myChain) {
            List candidates = next.fetchAllConformanceResources(theContext);
            if (candidates == null) continue;
            retVal.addAll(candidates);
        }
        return retVal;
    }

    @Override
    public List<StructureDefinition> fetchAllStructureDefinitions(FhirContext theContext) {
        ArrayList<StructureDefinition> retVal = new ArrayList<StructureDefinition>();
        HashSet<String> urls = new HashSet<String>();
        for (IValidationSupport nextSupport : this.myChain) {
            for (StructureDefinition next : nextSupport.fetchAllStructureDefinitions(theContext)) {
                if (!StringUtils.isBlank((CharSequence)next.getUrl()) && !urls.add(next.getUrl())) continue;
                retVal.add(next);
            }
        }
        return retVal;
    }

    @Override
    public CodeSystem fetchCodeSystem(FhirContext theCtx, String theSystem) {
        for (IValidationSupport next : this.myChain) {
            CodeSystem retVal = next.fetchCodeSystem(theCtx, theSystem);
            if (retVal == null) continue;
            return retVal;
        }
        return null;
    }

    @Override
    public <T extends IBaseResource> T fetchResource(FhirContext theContext, Class<T> theClass, String theUri) {
        for (IValidationSupport next : this.myChain) {
            T retVal = next.fetchResource(theContext, theClass, theUri);
            if (retVal == null) continue;
            return retVal;
        }
        return null;
    }

    @Override
    public StructureDefinition fetchStructureDefinition(FhirContext theCtx, String theUrl) {
        for (IValidationSupport next : this.myChain) {
            StructureDefinition retVal = next.fetchStructureDefinition(theCtx, theUrl);
            if (retVal == null) continue;
            return retVal;
        }
        return null;
    }

    @Override
    public boolean isCodeSystemSupported(FhirContext theCtx, String theSystem) {
        for (IValidationSupport next : this.myChain) {
            if (!next.isCodeSystemSupported(theCtx, theSystem)) continue;
            return true;
        }
        return false;
    }

    @Override
    public IValidationSupport.CodeValidationResult validateCode(FhirContext theCtx, String theCodeSystem, String theCode, String theDisplay) {
        for (IValidationSupport next : this.myChain) {
            if (!next.isCodeSystemSupported(theCtx, theCodeSystem)) continue;
            return next.validateCode(theCtx, theCodeSystem, theCode, theDisplay);
        }
        return this.myChain.get(0).validateCode(theCtx, theCodeSystem, theCode, theDisplay);
    }
}

