/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2016may.hapi.validation;

import ca.uhn.fhir.context.ConfigurationException;
import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.rest.api.EncodingEnum;
import ca.uhn.fhir.rest.server.exceptions.InternalErrorException;
import ca.uhn.fhir.validation.IValidationContext;
import ca.uhn.fhir.validation.IValidatorModule;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.lang3.Validate;
import org.hl7.fhir.dstu2016may.hapi.validation.BaseValidatorBridge;
import org.hl7.fhir.dstu2016may.hapi.validation.DefaultProfileValidationSupport;
import org.hl7.fhir.dstu2016may.hapi.validation.HapiWorkerContext;
import org.hl7.fhir.dstu2016may.hapi.validation.IValidationSupport;
import org.hl7.fhir.dstu2016may.model.StructureDefinition;
import org.hl7.fhir.dstu2016may.validation.IResourceValidator;
import org.hl7.fhir.dstu2016may.validation.InstanceValidator;
import org.hl7.fhir.utilities.validation.ValidationMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class FhirInstanceValidator
extends BaseValidatorBridge
implements IValidatorModule {
    private static final Logger ourLog = LoggerFactory.getLogger(FhirInstanceValidator.class);
    private IResourceValidator.BestPracticeWarningLevel myBestPracticeWarningLevel;
    private DocumentBuilderFactory myDocBuilderFactory = DocumentBuilderFactory.newInstance();
    private StructureDefinition myStructureDefintion;
    private IValidationSupport myValidationSupport;

    public FhirInstanceValidator() {
        this(new DefaultProfileValidationSupport());
    }

    public FhirInstanceValidator(IValidationSupport theValidationSupport) {
        this.myDocBuilderFactory.setNamespaceAware(true);
        this.myValidationSupport = theValidationSupport;
    }

    private String determineResourceName(Document theDocument) {
        Element root = null;
        NodeList list = theDocument.getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            if (!(list.item(i) instanceof Element)) continue;
            root = (Element)list.item(i);
            break;
        }
        root = theDocument.getDocumentElement();
        return root.getLocalName();
    }

    public IResourceValidator.BestPracticeWarningLevel getBestPracticeWarningLevel() {
        return this.myBestPracticeWarningLevel;
    }

    public IValidationSupport getValidationSupport() {
        return this.myValidationSupport;
    }

    public void setBestPracticeWarningLevel(IResourceValidator.BestPracticeWarningLevel theBestPracticeWarningLevel) {
        Validate.notNull((Object)((Object)theBestPracticeWarningLevel));
        this.myBestPracticeWarningLevel = theBestPracticeWarningLevel;
    }

    public void setStructureDefintion(StructureDefinition theStructureDefintion) {
        this.myStructureDefintion = theStructureDefintion;
    }

    public void setValidationSupport(IValidationSupport theValidationSupport) {
        this.myValidationSupport = theValidationSupport;
    }

    protected List<ValidationMessage> validate(FhirContext theCtx, String theInput, EncodingEnum theEncoding) {
        InstanceValidator v;
        HapiWorkerContext workerContext = new HapiWorkerContext(theCtx, this.myValidationSupport);
        try {
            v = new InstanceValidator(workerContext);
        }
        catch (Exception e) {
            throw new ConfigurationException((Throwable)e);
        }
        v.setBestPracticeWarningLevel(this.myBestPracticeWarningLevel);
        v.setAnyExtensionsAllowed(true);
        v.setResourceIdRule(IResourceValidator.IdStatus.OPTIONAL);
        ArrayList<ValidationMessage> messages = new ArrayList<ValidationMessage>();
        if (theEncoding == EncodingEnum.XML) {
            Document document;
            try {
                DocumentBuilder builder = this.myDocBuilderFactory.newDocumentBuilder();
                InputSource src = new InputSource(new StringReader(theInput));
                document = builder.parse(src);
            }
            catch (Exception e2) {
                ourLog.error("Failure to parse XML input", (Throwable)e2);
                ValidationMessage m = new ValidationMessage();
                m.setLevel(ValidationMessage.IssueSeverity.FATAL);
                m.setMessage("Failed to parse input, it does not appear to be valid XML:" + e2.getMessage());
                return Collections.singletonList(m);
            }
            String resourceName = this.determineResourceName(document);
            StructureDefinition profile = this.findStructureDefinitionForResourceName(theCtx, resourceName);
            if (profile != null) {
                try {
                    v.validate(messages, document, profile);
                }
                catch (Exception e) {
                    throw new InternalErrorException("Unexpected failure while validating resource", (Throwable)e);
                }
            }
        } else if (theEncoding == EncodingEnum.JSON) {
            Gson gson = new GsonBuilder().create();
            JsonObject json = (JsonObject)gson.fromJson(theInput, JsonObject.class);
            String resourceName = json.get("resourceType").getAsString();
            StructureDefinition profile = this.findStructureDefinitionForResourceName(theCtx, resourceName);
            if (profile != null) {
                try {
                    v.validate(messages, json, profile);
                }
                catch (Exception e) {
                    throw new InternalErrorException("Unexpected failure while validating resource", (Throwable)e);
                }
            }
        } else {
            throw new IllegalArgumentException("Unknown encoding: " + theEncoding);
        }
        for (int i = 0; i < messages.size(); ++i) {
            ValidationMessage next = (ValidationMessage)messages.get(i);
            if (!"Binding has no source, so can't be checked".equals(next.getMessage())) continue;
            messages.remove(i);
            --i;
        }
        return messages;
    }

    private StructureDefinition findStructureDefinitionForResourceName(FhirContext theCtx, String resourceName) {
        String sdName = "http://hl7.org/fhir/StructureDefinition/" + resourceName;
        StructureDefinition profile = this.myStructureDefintion != null ? this.myStructureDefintion : this.myValidationSupport.fetchStructureDefinition(theCtx, sdName);
        return profile;
    }

    @Override
    protected List<ValidationMessage> validate(IValidationContext<?> theCtx) {
        return this.validate(theCtx.getFhirContext(), theCtx.getResourceAsString(), theCtx.getResourceAsStringEncoding());
    }
}

