/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.client.impl;

import ca.uhn.fhir.context.BaseRuntimeChildDefinition;
import ca.uhn.fhir.context.BaseRuntimeElementCompositeDefinition;
import ca.uhn.fhir.context.BaseRuntimeElementDefinition;
import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.RuntimeResourceDefinition;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.interceptor.api.HookParams;
import ca.uhn.fhir.interceptor.api.IInterceptorService;
import ca.uhn.fhir.interceptor.api.IPointcut;
import ca.uhn.fhir.interceptor.api.Pointcut;
import ca.uhn.fhir.interceptor.executor.InterceptorService;
import ca.uhn.fhir.parser.DataFormatException;
import ca.uhn.fhir.parser.IParser;
import ca.uhn.fhir.rest.api.CacheControlDirective;
import ca.uhn.fhir.rest.api.Constants;
import ca.uhn.fhir.rest.api.EncodingEnum;
import ca.uhn.fhir.rest.api.RequestFormatParamStyleEnum;
import ca.uhn.fhir.rest.api.SummaryEnum;
import ca.uhn.fhir.rest.client.api.ClientResponseContext;
import ca.uhn.fhir.rest.client.api.IHttpClient;
import ca.uhn.fhir.rest.client.api.IHttpRequest;
import ca.uhn.fhir.rest.client.api.IHttpResponse;
import ca.uhn.fhir.rest.client.api.IRestfulClient;
import ca.uhn.fhir.rest.client.exceptions.FhirClientConnectionException;
import ca.uhn.fhir.rest.client.exceptions.InvalidResponseException;
import ca.uhn.fhir.rest.client.exceptions.NonFhirResponseException;
import ca.uhn.fhir.rest.client.impl.BaseHttpClientInvocation;
import ca.uhn.fhir.rest.client.impl.RestfulClientFactory;
import ca.uhn.fhir.rest.client.interceptor.AdditionalRequestHeadersInterceptor;
import ca.uhn.fhir.rest.client.method.HttpGetClientInvocation;
import ca.uhn.fhir.rest.client.method.IClientResponseHandler;
import ca.uhn.fhir.rest.client.method.IClientResponseHandlerHandlesBinary;
import ca.uhn.fhir.rest.client.method.MethodUtil;
import ca.uhn.fhir.rest.server.exceptions.BaseServerResponseException;
import ca.uhn.fhir.rest.server.exceptions.InternalErrorException;
import ca.uhn.fhir.system.HapiSystemProperties;
import ca.uhn.fhir.util.BinaryUtil;
import ca.uhn.fhir.util.OperationOutcomeUtil;
import ca.uhn.fhir.util.XmlDetectionUtil;
import com.google.common.base.Charsets;
import jakarta.annotation.Nonnull;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IBaseBinary;
import org.hl7.fhir.instance.model.api.IBaseOperationOutcome;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;
import org.hl7.fhir.instance.model.api.IPrimitiveType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseClient
implements IRestfulClient {
    private static final Logger ourLog = LoggerFactory.getLogger(BaseClient.class);
    private final IHttpClient myClient;
    private final RestfulClientFactory myFactory;
    private final String myUrlBase;
    private boolean myDontValidateConformance;
    private EncodingEnum myEncoding = null;
    private boolean myKeepResponses = false;
    private IHttpResponse myLastResponse;
    private String myLastResponseBody;
    private Boolean myPrettyPrint = false;
    private SummaryEnum mySummary;
    private RequestFormatParamStyleEnum myRequestFormatParamStyle = RequestFormatParamStyleEnum.SHORT;
    private IInterceptorService myInterceptorService;

    BaseClient(IHttpClient theClient, String theUrlBase, RestfulClientFactory theFactory) {
        this.myClient = theClient;
        this.myUrlBase = theUrlBase;
        this.myFactory = theFactory;
        if (HapiSystemProperties.isHapiClientKeepResponsesEnabled()) {
            this.setKeepResponses(true);
        }
        if (!XmlDetectionUtil.isStaxPresent()) {
            this.myEncoding = EncodingEnum.JSON;
        }
        this.setInterceptorService((IInterceptorService)new InterceptorService());
    }

    public IInterceptorService getInterceptorService() {
        return this.myInterceptorService;
    }

    public void setInterceptorService(@Nonnull IInterceptorService theInterceptorService) {
        Validate.notNull((Object)theInterceptorService, (String)"theInterceptorService must not be null", (Object[])new Object[0]);
        this.myInterceptorService = theInterceptorService;
    }

    protected Map<String, List<String>> createExtraParams(String theCustomAcceptHeader) {
        LinkedHashMap<String, List<String>> retVal = new LinkedHashMap<String, List<String>>();
        if (StringUtils.isBlank((CharSequence)theCustomAcceptHeader) && this.myRequestFormatParamStyle == RequestFormatParamStyleEnum.SHORT) {
            if (this.getEncoding() == EncodingEnum.XML) {
                retVal.put("_format", Collections.singletonList("xml"));
            } else if (this.getEncoding() == EncodingEnum.JSON) {
                retVal.put("_format", Collections.singletonList("json"));
            }
        }
        if (this.isPrettyPrint()) {
            retVal.put("_pretty", Collections.singletonList("true"));
        }
        return retVal;
    }

    public <T extends IBaseResource> T fetchResourceFromUrl(Class<T> theResourceType, String theUrl) {
        HttpGetClientInvocation clientInvocation = new HttpGetClientInvocation(this.getFhirContext(), theUrl);
        ResourceResponseHandler<T> binding = new ResourceResponseHandler<T>(theResourceType);
        return (T)((IBaseResource)this.invokeClient(this.getFhirContext(), binding, clientInvocation, null, false, false, null, null, null, null, null));
    }

    void forceConformanceCheck() {
        this.myFactory.validateServerBase(this.myUrlBase, this.myClient, this);
    }

    public EncodingEnum getEncoding() {
        return this.myEncoding;
    }

    public void setEncoding(EncodingEnum theEncoding) {
        this.myEncoding = theEncoding;
    }

    public IHttpClient getHttpClient() {
        return this.myClient;
    }

    public IHttpResponse getLastResponse() {
        return this.myLastResponse;
    }

    public String getLastResponseBody() {
        return this.myLastResponseBody;
    }

    public String getServerBase() {
        return this.myUrlBase;
    }

    public SummaryEnum getSummary() {
        return this.mySummary;
    }

    public void setSummary(SummaryEnum theSummary) {
        this.mySummary = theSummary;
    }

    public String getUrlBase() {
        return this.myUrlBase;
    }

    public void setFormatParamStyle(RequestFormatParamStyleEnum theRequestFormatParamStyle) {
        Validate.notNull((Object)theRequestFormatParamStyle, (String)"theRequestFormatParamStyle must not be null", (Object[])new Object[0]);
        this.myRequestFormatParamStyle = theRequestFormatParamStyle;
    }

    protected <T> T invokeClient(FhirContext theContext, IClientResponseHandler<T> binding, BaseHttpClientInvocation clientInvocation) {
        return this.invokeClient(theContext, binding, clientInvocation, false);
    }

    protected <T> T invokeClient(FhirContext theContext, IClientResponseHandler<T> binding, BaseHttpClientInvocation clientInvocation, boolean theLogRequestAndResponse) {
        return this.invokeClient(theContext, binding, clientInvocation, null, null, theLogRequestAndResponse, null, null, null, null, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected <T> T invokeClient(FhirContext theContext, IClientResponseHandler<T> binding, BaseHttpClientInvocation clientInvocation, EncodingEnum theEncoding, Boolean thePrettyPrint, boolean theLogRequestAndResponse, SummaryEnum theSummaryMode, Set<String> theSubsetElements, CacheControlDirective theCacheControlDirective, String theCustomAcceptHeader, Map<String, List<String>> theCustomHeaders) {
        T t;
        InputStream reader;
        IClientResponseHandlerHandlesBinary handlesBinary;
        if (!this.myDontValidateConformance) {
            this.myFactory.validateServerBaseIfConfiguredToDoSo(this.myUrlBase, this.myClient, this);
        }
        IHttpRequest httpRequest = null;
        IHttpResponse response = null;
        Map<String, List<String>> params = this.createExtraParams(theCustomAcceptHeader);
        if (clientInvocation instanceof HttpGetClientInvocation && this.myRequestFormatParamStyle == RequestFormatParamStyleEnum.SHORT && StringUtils.isBlank((CharSequence)theCustomAcceptHeader)) {
            if (theEncoding == EncodingEnum.XML) {
                params.put("_format", Collections.singletonList("xml"));
            } else if (theEncoding == EncodingEnum.JSON) {
                params.put("_format", Collections.singletonList("json"));
            }
        }
        if (theSummaryMode != null) {
            params.put("_summary", Collections.singletonList(theSummaryMode.getCode()));
        } else if (this.mySummary != null) {
            params.put("_summary", Collections.singletonList(this.mySummary.getCode()));
        }
        if (thePrettyPrint == Boolean.TRUE) {
            params.put("_pretty", Collections.singletonList("true"));
        }
        if (theSubsetElements != null && !theSubsetElements.isEmpty()) {
            params.put("_elements", Collections.singletonList(StringUtils.join(theSubsetElements, (char)',')));
        }
        EncodingEnum encoding = this.getEncoding();
        if (theEncoding != null) {
            encoding = theEncoding;
        }
        httpRequest = clientInvocation.asHttpRequest(this.myUrlBase, params, encoding, thePrettyPrint);
        if (StringUtils.isNotBlank((CharSequence)theCustomAcceptHeader)) {
            httpRequest.removeHeaders("Accept");
            httpRequest.addHeader("Accept", theCustomAcceptHeader);
        }
        if (theCacheControlDirective != null) {
            StringBuilder b = new StringBuilder();
            this.addToCacheControlHeader(b, "no-cache", theCacheControlDirective.isNoCache());
            this.addToCacheControlHeader(b, "no-store", theCacheControlDirective.isNoStore());
            if (theCacheControlDirective.getMaxResults() != null) {
                this.addToCacheControlHeader(b, "max-results=" + theCacheControlDirective.getMaxResults(), true);
            }
            if (b.length() > 0) {
                httpRequest.addHeader("Cache-Control", b.toString());
            }
        }
        if (theLogRequestAndResponse) {
            ourLog.info("Client invoking: {}", (Object)httpRequest);
            String body = httpRequest.getRequestBodyFromStream();
            if (body != null) {
                ourLog.info("Client request body: {}", (Object)body);
            }
        }
        if (theCustomHeaders != null) {
            AdditionalRequestHeadersInterceptor interceptor = new AdditionalRequestHeadersInterceptor(theCustomHeaders);
            interceptor.interceptRequest(httpRequest);
        }
        HookParams requestParams = new HookParams();
        requestParams.add(IHttpRequest.class, (Object)httpRequest);
        requestParams.add(IRestfulClient.class, (Object)this);
        this.getInterceptorService().callHooks((IPointcut)Pointcut.CLIENT_REQUEST, requestParams);
        response = httpRequest.execute();
        Class returnType = binding instanceof ResourceResponseHandler ? ((ResourceResponseHandler)binding).getReturnType() : null;
        ClientResponseContext clientResponseContext = new ClientResponseContext(httpRequest, response, (IRestfulClient)this, this.getFhirContext(), returnType);
        HookParams responseParams = new HookParams();
        responseParams.add(IHttpRequest.class, (Object)httpRequest);
        responseParams.add(IHttpResponse.class, (Object)response);
        responseParams.add(IRestfulClient.class, (Object)this);
        responseParams.add(ClientResponseContext.class, (Object)clientResponseContext);
        this.getInterceptorService().callHooks((IPointcut)Pointcut.CLIENT_RESPONSE, responseParams);
        response = clientResponseContext.getHttpResponse();
        String mimeType = 204 == response.getStatus() ? null : response.getMimeType();
        Map headers = response.getAllHeaders();
        if (response.getStatus() < 200 || response.getStatus() > 299) {
            String body = null;
            try (Reader reader2 = response.createReader();){
                body = IOUtils.toString((Reader)reader2);
            }
            catch (Exception e) {
                ourLog.debug("Failed to read input stream", (Throwable)e);
            }
            String message = "HTTP " + response.getStatus() + " " + response.getStatusInfo();
            IBaseOperationOutcome oo = null;
            if ("text/plain".equals(mimeType)) {
                message = message + ": " + body;
            } else {
                EncodingEnum enc = EncodingEnum.forContentType((String)mimeType);
                if (enc != null) {
                    IParser p = enc.newParser(theContext);
                    try {
                        oo = (IBaseOperationOutcome)p.parseResource(body);
                        String details = OperationOutcomeUtil.getFirstIssueDiagnostics((FhirContext)this.getFhirContext(), (IBaseOperationOutcome)oo);
                        if (StringUtils.isNotBlank((CharSequence)details)) {
                            message = message + ": " + details;
                        }
                    }
                    catch (Exception e) {
                        ourLog.debug("Failed to process OperationOutcome response");
                    }
                }
            }
            this.keepResponseAndLogIt(theLogRequestAndResponse, response, body);
            BaseServerResponseException exception = BaseServerResponseException.newInstance((int)response.getStatus(), (String)message);
            exception.setOperationOutcome(oo);
            if (body == null) throw exception;
            exception.setResponseBody(body);
            throw exception;
        }
        if (binding instanceof IClientResponseHandlerHandlesBinary && (handlesBinary = (IClientResponseHandlerHandlesBinary)binding).isBinary()) {
            reader = response.readEntity();
            Object oo = handlesBinary.invokeClientForBinary(mimeType, reader, response.getStatus(), headers);
            return oo;
        }
        InputStream inputStream = response.readEntity();
        try {
            ByteArrayInputStream inputStreamToReturn;
            if (inputStream != null) {
                if (ourLog.isTraceEnabled() || this.myKeepResponses || theLogRequestAndResponse) {
                    String responseString = IOUtils.toString((InputStream)inputStream, (Charset)Charsets.UTF_8);
                    this.keepResponseAndLogIt(theLogRequestAndResponse, response, responseString);
                    inputStreamToReturn = new ByteArrayInputStream(responseString.getBytes(Charsets.UTF_8));
                } else {
                    inputStreamToReturn = new ByteArrayInputStream(inputStream.readAllBytes());
                }
            } else {
                inputStreamToReturn = new ByteArrayInputStream(new byte[0]);
            }
            t = binding.invokeClient(mimeType, inputStreamToReturn, response.getStatus(), headers);
            if (inputStream == null) return t;
        }
        catch (Throwable throwable) {
            String msg;
            try {
                if (inputStream == null) throw throwable;
                try {
                    inputStream.close();
                    throw throwable;
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (DataFormatException e) {
                if (httpRequest != null) {
                    msg = this.getFhirContext().getLocalizer().getMessage(BaseClient.class, "failedToParseResponse", new Object[]{httpRequest.getHttpVerbName(), httpRequest.getUri(), e.toString()});
                    throw new FhirClientConnectionException(Msg.code((int)1359) + msg, (Throwable)e);
                }
                msg = this.getFhirContext().getLocalizer().getMessage(BaseClient.class, "failedToParseResponse", new Object[]{"UNKNOWN", "UNKNOWN", e.toString()});
                throw new FhirClientConnectionException(Msg.code((int)1359) + msg, (Throwable)e);
            }
            catch (IllegalStateException e) {
                throw new FhirClientConnectionException(Msg.code((int)1360) + String.valueOf(e));
            }
            catch (IOException e) {
                msg = this.getFhirContext().getLocalizer().getMessage(BaseClient.class, "failedToParseResponse", new Object[]{httpRequest.getHttpVerbName(), httpRequest.getUri(), e.toString()});
                throw new FhirClientConnectionException(Msg.code((int)1361) + msg, (Throwable)e);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {}
            throw new FhirClientConnectionException(Msg.code((int)1362) + String.valueOf(e));
            finally {
                if (reader != null) {
                    reader.close();
                }
            }
        }
        finally {
            if (response != null) {
                response.close();
            }
        }
        inputStream.close();
        return t;
    }

    private void addToCacheControlHeader(StringBuilder theBuilder, String theDirective, boolean theActive) {
        if (theActive) {
            if (theBuilder.length() > 0) {
                theBuilder.append(", ");
            }
            theBuilder.append(theDirective);
        }
    }

    public boolean isKeepResponses() {
        return this.myKeepResponses;
    }

    public void setKeepResponses(boolean theKeepResponses) {
        this.myKeepResponses = theKeepResponses;
    }

    public boolean isPrettyPrint() {
        return Boolean.TRUE.equals(this.myPrettyPrint);
    }

    public void setPrettyPrint(Boolean thePrettyPrint) {
        this.myPrettyPrint = thePrettyPrint;
    }

    private void keepResponseAndLogIt(boolean theLogRequestAndResponse, IHttpResponse response, String responseString) {
        if (this.myKeepResponses) {
            this.myLastResponse = response;
            this.myLastResponseBody = responseString;
        }
        if (theLogRequestAndResponse) {
            String message = "HTTP " + response.getStatus() + " " + response.getStatusInfo();
            if (StringUtils.isNotBlank((CharSequence)responseString)) {
                ourLog.info("Client response: {}\n{}", (Object)message, (Object)responseString);
            } else {
                ourLog.info("Client response: {}", (Object)message);
            }
        } else {
            ourLog.trace("FHIR response:\n{}\n{}", (Object)response, (Object)responseString);
        }
    }

    public void registerInterceptor(Object theInterceptor) {
        Validate.notNull((Object)theInterceptor, (String)"Interceptor can not be null", (Object[])new Object[0]);
        this.getInterceptorService().registerInterceptor(theInterceptor);
    }

    public void setDontValidateConformance(boolean theDontValidateConformance) {
        this.myDontValidateConformance = theDontValidateConformance;
    }

    public void unregisterInterceptor(Object theInterceptor) {
        Validate.notNull((Object)theInterceptor, (String)"Interceptor can not be null", (Object[])new Object[0]);
        this.getInterceptorService().unregisterInterceptor(theInterceptor);
    }

    static ArrayList<Class<? extends IBaseResource>> toTypeList(Class<? extends IBaseResource> thePreferResponseType) {
        ArrayList<Class<? extends IBaseResource>> preferResponseTypes = null;
        if (thePreferResponseType != null) {
            preferResponseTypes = new ArrayList<Class<? extends IBaseResource>>(1);
            preferResponseTypes.add(thePreferResponseType);
        }
        return preferResponseTypes;
    }

    protected class ResourceResponseHandler<T extends IBaseResource>
    implements IClientResponseHandler<T> {
        private boolean myAllowHtmlResponse;
        private IIdType myId;
        private List<Class<? extends IBaseResource>> myPreferResponseTypes;
        private Class<T> myReturnType;

        public ResourceResponseHandler() {
            this(null);
        }

        public ResourceResponseHandler(Class<T> theReturnType) {
            this(theReturnType, null, null);
        }

        public ResourceResponseHandler(Class<T> theReturnType, Class<? extends IBaseResource> thePreferResponseType, IIdType theId) {
            this(theReturnType, thePreferResponseType, theId, false);
        }

        public ResourceResponseHandler(Class<T> theReturnType, Class<? extends IBaseResource> thePreferResponseType, IIdType theId, boolean theAllowHtmlResponse) {
            this(theReturnType, BaseClient.toTypeList(thePreferResponseType), theId, theAllowHtmlResponse);
        }

        public ResourceResponseHandler(Class<T> theClass, List<Class<? extends IBaseResource>> thePreferResponseTypes) {
            this(theClass, thePreferResponseTypes, null, false);
        }

        public ResourceResponseHandler(Class<T> theReturnType, List<Class<? extends IBaseResource>> thePreferResponseTypes, IIdType theId, boolean theAllowHtmlResponse) {
            this.myReturnType = theReturnType;
            this.myId = theId;
            this.myPreferResponseTypes = thePreferResponseTypes;
            this.myAllowHtmlResponse = theAllowHtmlResponse;
        }

        public Class<T> getReturnType() {
            return this.myReturnType;
        }

        @Override
        public T invokeClient(String theResponseMimeType, InputStream theResponseInputStream, int theResponseStatusCode, Map<String, List<String>> theHeaders) throws BaseServerResponseException {
            if (theResponseStatusCode == 204) {
                return null;
            }
            EncodingEnum respType = EncodingEnum.forContentType((String)theResponseMimeType);
            if (respType == null) {
                if (this.myAllowHtmlResponse && theResponseMimeType.toLowerCase().contains("text/html") && this.myReturnType != null) {
                    return this.readHtmlResponse(theResponseInputStream);
                }
                throw NonFhirResponseException.newInstance((int)theResponseStatusCode, (String)theResponseMimeType, (InputStream)theResponseInputStream);
            }
            IParser parser = respType.newParser(BaseClient.this.getFhirContext());
            parser.setServerBaseUrl(BaseClient.this.getUrlBase());
            if (this.myPreferResponseTypes != null) {
                parser.setPreferTypes(this.myPreferResponseTypes);
            }
            IBaseResource retVal = parser.parseResource(this.myReturnType, theResponseInputStream);
            MethodUtil.parseClientRequestResourceHeaders(this.myId, theHeaders, retVal);
            return (T)retVal;
        }

        private T readHtmlResponse(InputStream theResponseInputStream) {
            RuntimeResourceDefinition resDef = BaseClient.this.getFhirContext().getResourceDefinition(this.myReturnType);
            IBaseResource instance = (IBaseResource)resDef.newInstance();
            BaseRuntimeChildDefinition textChild = resDef.getChildByName("text");
            BaseRuntimeElementCompositeDefinition textElement = (BaseRuntimeElementCompositeDefinition)textChild.getChildByName("text");
            IBase textInstance = textElement.newInstance();
            textChild.getMutator().addValue((IBase)instance, textInstance);
            BaseRuntimeChildDefinition divChild = textElement.getChildByName("div");
            BaseRuntimeElementDefinition divElement = divChild.getChildByName("div");
            IPrimitiveType divInstance = (IPrimitiveType)divElement.newInstance();
            try {
                divInstance.setValueAsString(IOUtils.toString((InputStream)theResponseInputStream, (Charset)Charsets.UTF_8));
            }
            catch (Exception e) {
                throw new InvalidResponseException(Msg.code((int)1364) + "Failed to process HTML response from server: " + e.getMessage(), 400, (Throwable)e);
            }
            divChild.getMutator().addValue(textInstance, (IBase)divInstance);
            return (T)instance;
        }

        public ResourceResponseHandler<T> setPreferResponseTypes(List<Class<? extends IBaseResource>> thePreferResponseTypes) {
            this.myPreferResponseTypes = thePreferResponseTypes;
            return this;
        }
    }

    protected final class ResourceOrBinaryResponseHandler
    extends ResourceResponseHandler<IBaseResource> {
        protected ResourceOrBinaryResponseHandler() {
        }

        @Override
        public IBaseResource invokeClient(String theResponseMimeType, InputStream theResponseInputStream, int theResponseStatusCode, Map<String, List<String>> theHeaders) throws BaseServerResponseException {
            EncodingEnum respType = EncodingEnum.forContentType((String)theResponseMimeType);
            if (respType != null || theResponseStatusCode < 200 || theResponseStatusCode >= 300) {
                return super.invokeClient(theResponseMimeType, theResponseInputStream, theResponseStatusCode, theHeaders);
            }
            IBaseBinary responseBinary = BinaryUtil.newBinary((FhirContext)BaseClient.this.getFhirContext());
            String contentType = null;
            List<String> contentTypeHeaders = theHeaders.get(Constants.HEADER_CONTENT_TYPE_LC);
            if (contentTypeHeaders != null && contentTypeHeaders.size() > 0) {
                contentType = contentTypeHeaders.get(0);
            }
            responseBinary.setContentType(contentType);
            try {
                responseBinary.setContent(IOUtils.toByteArray((InputStream)theResponseInputStream));
            }
            catch (IOException e) {
                throw new InternalErrorException(Msg.code((int)1363) + "IO failure parsing response", (Throwable)e);
            }
            return responseBinary;
        }
    }
}

