/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.client.interceptor;

import ca.uhn.fhir.rest.client.api.IClientInterceptor;
import ca.uhn.fhir.rest.client.api.IHttpRequest;
import ca.uhn.fhir.rest.client.api.IHttpResponse;
import java.io.IOException;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;

public class SimpleRequestHeaderInterceptor
implements IClientInterceptor {
    private String myHeaderName;
    private String myHeaderValue;

    public SimpleRequestHeaderInterceptor() {
        this(null, null);
    }

    public SimpleRequestHeaderInterceptor(String theHeaderName, String theHeaderValue) {
        this.myHeaderName = theHeaderName;
        this.myHeaderValue = theHeaderValue;
    }

    public SimpleRequestHeaderInterceptor(String theCompleteHeader) {
        Validate.notBlank((CharSequence)theCompleteHeader, (String)"theCompleteHeader must not be null", (Object[])new Object[0]);
        int colonIdx = theCompleteHeader.indexOf(58);
        if (colonIdx != -1) {
            this.setHeaderName(theCompleteHeader.substring(0, colonIdx).trim());
            this.setHeaderValue(theCompleteHeader.substring(colonIdx + 1, theCompleteHeader.length()).trim());
        } else {
            this.setHeaderName(theCompleteHeader.trim());
            this.setHeaderValue(null);
        }
    }

    public String getHeaderName() {
        return this.myHeaderName;
    }

    public String getHeaderValue() {
        return this.myHeaderValue;
    }

    public void interceptRequest(IHttpRequest theRequest) {
        if (StringUtils.isNotBlank((CharSequence)this.getHeaderName())) {
            theRequest.addHeader(this.getHeaderName(), this.getHeaderValue());
        }
    }

    public void interceptResponse(IHttpResponse theResponse) throws IOException {
    }

    public void setHeaderName(String theHeaderName) {
        this.myHeaderName = theHeaderName;
    }

    public void setHeaderValue(String theHeaderValue) {
        this.myHeaderValue = theHeaderValue;
    }
}

