/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.client.method;

import ca.uhn.fhir.context.ConfigurationException;
import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.rest.annotation.IncludeParam;
import ca.uhn.fhir.rest.api.QualifiedParamList;
import ca.uhn.fhir.rest.api.RestSearchParameterTypeEnum;
import ca.uhn.fhir.rest.client.method.BaseQueryParameter;
import ca.uhn.fhir.rest.server.exceptions.InternalErrorException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

class IncludeParameter
extends BaseQueryParameter {
    private Set<String> myAllow;
    private Class<? extends Collection<Include>> myInstantiableCollectionType;
    private Class<?> mySpecType;
    private boolean myReverse;

    public IncludeParameter(IncludeParam theAnnotation, Class<? extends Collection<Include>> theInstantiableCollectionType, Class<?> theSpecType) {
        this.myInstantiableCollectionType = theInstantiableCollectionType;
        this.myReverse = theAnnotation.reverse();
        if (theAnnotation.allow().length > 0) {
            this.myAllow = new HashSet<String>();
            for (String next : theAnnotation.allow()) {
                if (next == null) continue;
                this.myAllow.add(next);
            }
        } else {
            this.myAllow = Collections.emptySet();
        }
        this.mySpecType = theSpecType;
        if (this.mySpecType != Include.class && this.mySpecType != String.class) {
            throw new ConfigurationException("Invalid @" + IncludeParam.class.getSimpleName() + " parameter type: " + this.mySpecType);
        }
    }

    @Override
    public List<QualifiedParamList> encode(FhirContext theContext, Object theObject) throws InternalErrorException {
        ArrayList<QualifiedParamList> retVal = new ArrayList<QualifiedParamList>();
        if (this.myInstantiableCollectionType == null) {
            if (this.mySpecType == Include.class) {
                this.convertAndAddIncludeToList(retVal, (Include)theObject, theContext);
            } else {
                retVal.add(QualifiedParamList.singleton((String)((String)theObject)));
            }
        } else {
            Collection val = (Collection)theObject;
            for (Include include : val) {
                this.convertAndAddIncludeToList(retVal, include, theContext);
            }
        }
        return retVal;
    }

    private void convertAndAddIncludeToList(ArrayList<QualifiedParamList> theQualifiedParamLists, Include theInclude, FhirContext theContext) {
        String qualifier = null;
        if (theInclude.isRecurse()) {
            qualifier = theContext.getVersion().getVersion().isEqualOrNewerThan(FhirVersionEnum.R4) ? ":iterate" : ":recurse";
        }
        theQualifiedParamLists.add(QualifiedParamList.singleton(qualifier, (String)theInclude.getValue()));
    }

    public Set<String> getAllow() {
        return this.myAllow;
    }

    @Override
    public String getName() {
        return this.myReverse ? "_revinclude" : "_include";
    }

    @Override
    public RestSearchParameterTypeEnum getParamType() {
        return null;
    }

    @Override
    public boolean isRequired() {
        return false;
    }
}

