/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.client.interceptor;

import ca.uhn.fhir.interceptor.api.Hook;
import ca.uhn.fhir.interceptor.api.Interceptor;
import ca.uhn.fhir.interceptor.api.Pointcut;
import ca.uhn.fhir.model.primitive.IdDt;
import ca.uhn.fhir.rest.client.api.IClientInterceptor;
import ca.uhn.fhir.rest.client.api.IHttpRequest;
import ca.uhn.fhir.rest.client.api.IHttpResponse;
import ca.uhn.fhir.rest.server.exceptions.InternalErrorException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Interceptor
public class LoggingInterceptor
implements IClientInterceptor {
    private static final Logger ourLog = LoggerFactory.getLogger(LoggingInterceptor.class);
    private Logger myLog = ourLog;
    private boolean myLogRequestBody = false;
    private boolean myLogRequestHeaders = false;
    private boolean myLogRequestSummary = true;
    private boolean myLogResponseBody = false;
    private boolean myLogResponseHeaders = false;
    private boolean myLogResponseSummary = true;

    public LoggingInterceptor() {
    }

    public LoggingInterceptor(boolean theVerbose) {
        if (theVerbose) {
            this.setLogRequestBody(true);
            this.setLogRequestSummary(true);
            this.setLogResponseBody(true);
            this.setLogResponseSummary(true);
            this.setLogRequestHeaders(true);
            this.setLogResponseHeaders(true);
        }
    }

    @Hook(value=Pointcut.CLIENT_REQUEST)
    public void interceptRequest(IHttpRequest theRequest) {
        if (this.myLogRequestSummary) {
            this.myLog.info("Client request: {}", (Object)theRequest);
        }
        if (this.myLogRequestHeaders) {
            StringBuilder b = this.headersToString(theRequest.getAllHeaders());
            this.myLog.info("Client request headers:\n{}", (Object)b.toString());
        }
        if (this.myLogRequestBody) {
            try {
                String content = theRequest.getRequestBodyFromStream();
                if (content != null) {
                    this.myLog.info("Client request body:\n{}", (Object)content);
                }
            }
            catch (IOException | IllegalStateException e) {
                this.myLog.warn("Failed to replay request contents (during logging attempt, actual FHIR call did not fail)", (Throwable)e);
            }
        }
    }

    @Hook(value=Pointcut.CLIENT_RESPONSE)
    public void interceptResponse(IHttpResponse theResponse) throws IOException {
        block17: {
            if (this.myLogResponseSummary) {
                String message = "HTTP " + theResponse.getStatus() + " " + theResponse.getStatusInfo();
                String respLocation = "";
                List locationHeaders = theResponse.getHeaders("Location");
                if (locationHeaders == null || locationHeaders.isEmpty()) {
                    locationHeaders = theResponse.getHeaders("Content-Location");
                }
                if (locationHeaders != null && locationHeaders.size() > 0) {
                    String locationValue = (String)locationHeaders.get(0);
                    IdDt locationValueId = new IdDt(locationValue);
                    if (locationValueId.hasBaseUrl() && locationValueId.hasIdPart()) {
                        locationValue = locationValueId.toUnqualified().getValue();
                    }
                    respLocation = " (" + locationValue + ")";
                }
                String timing = " in " + theResponse.getRequestStopWatch().toString();
                this.myLog.info("Client response: {}{}{}", new Object[]{message, respLocation, timing});
            }
            if (this.myLogResponseHeaders) {
                StringBuilder b = this.headersToString(theResponse.getAllHeaders());
                if (b.length() == 0) {
                    this.myLog.info("Client response headers: (none)");
                } else {
                    this.myLog.info("Client response headers:\n{}", (Object)b.toString());
                }
            }
            if (this.myLogResponseBody) {
                theResponse.bufferEntity();
                try (InputStream respEntity = theResponse.readEntity();){
                    if (respEntity != null) {
                        byte[] bytes;
                        try {
                            bytes = IOUtils.toByteArray((InputStream)respEntity);
                        }
                        catch (IllegalStateException e) {
                            throw new InternalErrorException((Throwable)e);
                        }
                        this.myLog.info("Client response body:\n{}", (Object)new String(bytes, StandardCharsets.UTF_8));
                        break block17;
                    }
                    this.myLog.info("Client response body: (none)");
                }
            }
        }
    }

    private StringBuilder headersToString(Map<String, List<String>> theHeaders) {
        StringBuilder b = new StringBuilder();
        if (theHeaders != null && !theHeaders.isEmpty()) {
            Iterator<String> nameEntries = theHeaders.keySet().iterator();
            while (nameEntries.hasNext()) {
                String key = nameEntries.next();
                Iterator<String> values = theHeaders.get(key).iterator();
                while (values.hasNext()) {
                    String value = values.next();
                    b.append(key);
                    b.append(": ");
                    b.append(value);
                    if (!nameEntries.hasNext() && !values.hasNext()) continue;
                    b.append('\n');
                }
            }
        }
        return b;
    }

    public void setLogger(Logger theLogger) {
        Validate.notNull((Object)theLogger, (String)"theLogger can not be null", (Object[])new Object[0]);
        this.myLog = theLogger;
    }

    public void setLogRequestBody(boolean theValue) {
        this.myLogRequestBody = theValue;
    }

    public void setLogRequestHeaders(boolean theValue) {
        this.myLogRequestHeaders = theValue;
    }

    public void setLogRequestSummary(boolean theValue) {
        this.myLogRequestSummary = theValue;
    }

    public void setLogResponseBody(boolean theValue) {
        this.myLogResponseBody = theValue;
    }

    public void setLogResponseHeaders(boolean theValue) {
        this.myLogResponseHeaders = theValue;
    }

    public void setLogResponseSummary(boolean theValue) {
        this.myLogResponseSummary = theValue;
    }
}

