/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.client.method;

import ca.uhn.fhir.context.ConfigurationException;
import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.RuntimeResourceDefinition;
import ca.uhn.fhir.model.api.IResource;
import ca.uhn.fhir.rest.annotation.TransactionParam;
import ca.uhn.fhir.rest.client.method.IParameter;
import ca.uhn.fhir.rest.server.exceptions.InternalErrorException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.hl7.fhir.instance.model.api.IBaseResource;

public class TransactionParameter
implements IParameter {
    private FhirContext myContext;
    private ParamStyle myParamStyle;

    public TransactionParameter(FhirContext theContext) {
        this.myContext = theContext;
    }

    private String createParameterTypeError(Method theMethod) {
        return "Method '" + theMethod.getName() + "' in type '" + theMethod.getDeclaringClass().getCanonicalName() + "' is annotated with @" + TransactionParam.class.getName() + " but is not of type List<" + IResource.class.getCanonicalName() + "> or Bundle";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void initializeTypes(Method theMethod, Class<? extends Collection<?>> theOuterCollectionType, Class<? extends Collection<?>> theInnerCollectionType, Class<?> theParameterType) {
        if (theOuterCollectionType != null) {
            throw new ConfigurationException("Method '" + theMethod.getName() + "' in type '" + theMethod.getDeclaringClass().getCanonicalName() + "' is annotated with @" + TransactionParam.class.getName() + " but can not be a collection of collections");
        }
        if (!Modifier.isInterface(theParameterType.getModifiers()) && IBaseResource.class.isAssignableFrom(theParameterType)) {
            Class<?> parameterType = theParameterType;
            RuntimeResourceDefinition def = this.myContext.getResourceDefinition(parameterType);
            if (!"Bundle".equals(def.getName())) throw new ConfigurationException(this.createParameterTypeError(theMethod));
            this.myParamStyle = ParamStyle.RESOURCE_BUNDLE;
            return;
        } else {
            if (!theInnerCollectionType.equals(List.class)) {
                throw new ConfigurationException(this.createParameterTypeError(theMethod));
            }
            if (!theParameterType.equals(IResource.class) && !theParameterType.equals(IBaseResource.class)) {
                throw new ConfigurationException(this.createParameterTypeError(theMethod));
            }
            this.myParamStyle = ParamStyle.RESOURCE_LIST;
        }
    }

    @Override
    public void translateClientArgumentIntoQueryArgument(FhirContext theContext, Object theSourceClientArgument, Map<String, List<String>> theTargetQueryArguments, IBaseResource theTargetResource) throws InternalErrorException {
    }

    public ParamStyle getParamStyle() {
        return this.myParamStyle;
    }

    public static enum ParamStyle {
        RESOURCE_BUNDLE,
        RESOURCE_LIST;

    }
}

