/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.client.method;

import ca.uhn.fhir.context.ConfigurationException;
import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.rest.annotation.IncludeParam;
import ca.uhn.fhir.rest.api.QualifiedParamList;
import ca.uhn.fhir.rest.api.RestSearchParameterTypeEnum;
import ca.uhn.fhir.rest.client.method.BaseQueryParameter;
import ca.uhn.fhir.rest.server.exceptions.InternalErrorException;
import ca.uhn.fhir.rest.server.exceptions.InvalidRequestException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;

class IncludeParameter
extends BaseQueryParameter {
    private Set<String> myAllow;
    private Class<? extends Collection<Include>> myInstantiableCollectionType;
    private Class<?> mySpecType;
    private boolean myReverse;

    public IncludeParameter(IncludeParam theAnnotation, Class<? extends Collection<Include>> theInstantiableCollectionType, Class<?> theSpecType) {
        this.myInstantiableCollectionType = theInstantiableCollectionType;
        this.myReverse = theAnnotation.reverse();
        if (theAnnotation.allow().length > 0) {
            this.myAllow = new HashSet<String>();
            for (String next : theAnnotation.allow()) {
                if (next == null) continue;
                this.myAllow.add(next);
            }
        } else {
            this.myAllow = Collections.emptySet();
        }
        this.mySpecType = theSpecType;
        if (this.mySpecType != Include.class && this.mySpecType != String.class) {
            throw new ConfigurationException("Invalid @" + IncludeParam.class.getSimpleName() + " parameter type: " + this.mySpecType);
        }
    }

    @Override
    public List<QualifiedParamList> encode(FhirContext theContext, Object theObject) throws InternalErrorException {
        ArrayList<QualifiedParamList> retVal = new ArrayList<QualifiedParamList>();
        if (this.myInstantiableCollectionType == null) {
            if (this.mySpecType == Include.class) {
                this.convertAndAddIncludeToList(retVal, (Include)theObject);
            } else {
                retVal.add(QualifiedParamList.singleton((String)((String)theObject)));
            }
        } else {
            Collection val = (Collection)theObject;
            for (Include include : val) {
                this.convertAndAddIncludeToList(retVal, include);
            }
        }
        return retVal;
    }

    private void convertAndAddIncludeToList(ArrayList<QualifiedParamList> retVal, Include include) {
        String qualifier = include.isRecurse() ? ":recurse" : null;
        retVal.add(QualifiedParamList.singleton((String)qualifier, (String)include.getValue()));
    }

    public Set<String> getAllow() {
        return this.myAllow;
    }

    @Override
    public String getName() {
        return this.myReverse ? "_revinclude" : "_include";
    }

    @Override
    public RestSearchParameterTypeEnum getParamType() {
        return null;
    }

    @Override
    public boolean handlesMissing() {
        return true;
    }

    @Override
    public boolean isRequired() {
        return false;
    }

    @Override
    public Object parse(FhirContext theContext, List<QualifiedParamList> theString) throws InternalErrorException, InvalidRequestException {
        Collection<Include> retValCollection = null;
        if (this.myInstantiableCollectionType != null) {
            try {
                retValCollection = this.myInstantiableCollectionType.newInstance();
            }
            catch (Exception e) {
                throw new InternalErrorException("Failed to instantiate " + this.myInstantiableCollectionType.getName(), (Throwable)e);
            }
        }
        for (QualifiedParamList nextParamList : theString) {
            if (nextParamList.isEmpty()) continue;
            if (nextParamList.size() > 1) {
                throw new InvalidRequestException(theContext.getLocalizer().getMessage(IncludeParameter.class, "orIncludeInRequest", new Object[0]));
            }
            boolean recurse = ":recurse".equals(nextParamList.getQualifier());
            String value = (String)nextParamList.get(0);
            if (!(this.myAllow == null || this.myAllow.isEmpty() || this.myAllow.contains(value) || this.myAllow.contains("*"))) {
                String msg = theContext.getLocalizer().getMessage(IncludeParameter.class, "invalidIncludeNameInRequest", new Object[]{value, new TreeSet<String>(this.myAllow).toString(), this.getName()});
                throw new InvalidRequestException(msg);
            }
            if (this.myInstantiableCollectionType == null) {
                if (this.mySpecType == String.class) {
                    return value;
                }
                return new Include(value, recurse);
            }
            retValCollection.add(new Include(value, recurse));
        }
        return retValCollection;
    }
}

