/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.util.bundle;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.rest.api.RequestTypeEnum;
import ca.uhn.fhir.util.bundle.BundleEntryMutator;
import ca.uhn.fhir.util.bundle.BundleEntryParts;
import jakarta.annotation.Nullable;
import java.util.Date;
import org.apache.commons.lang3.Validate;
import org.hl7.fhir.instance.model.api.IBaseResource;

public class ModifiableBundleEntryParts
extends BundleEntryParts {
    private final BundleEntryMutator myBundleEntryMutator;
    private final FhirContext myFhirContext;

    public ModifiableBundleEntryParts(FhirContext theFhirContext, BundleEntryParts theBundleEntryParts, BundleEntryMutator theBundleEntryMutator) {
        super(theBundleEntryParts);
        this.myFhirContext = theFhirContext;
        this.myBundleEntryMutator = theBundleEntryMutator;
    }

    public void setConditionalUrl(@Nullable String theConditionalUrl) {
        Validate.isTrue((theConditionalUrl == null || theConditionalUrl.contains("?") ? 1 : 0) != 0, (String)"theConditionalUrl must be null or be a valid conditional URL with format: [resourceType]?[params]", (Object[])new Object[0]);
        switch (this.getMethod()) {
            case POST: {
                this.setRequestIfNoneExist(theConditionalUrl);
                break;
            }
            case PUT: 
            case PATCH: 
            case DELETE: {
                this.setRequestUrl(theConditionalUrl);
            }
        }
    }

    public void setRequestUrl(String theRequestUrl) {
        this.myUrl = theRequestUrl;
        this.myBundleEntryMutator.setRequestUrl(theRequestUrl);
    }

    public void setFullUrl(String theFullUrl) {
        this.myFullUrl = theFullUrl;
        this.myBundleEntryMutator.setFullUrl(theFullUrl);
    }

    public void setResource(IBaseResource theUpdatedResource) {
        this.myBundleEntryMutator.setResource(theUpdatedResource);
    }

    public void setRequestIfNoneMatch(String ifNoneMatch) {
        this.myBundleEntryMutator.setRequestIfNoneMatch(ifNoneMatch);
    }

    public void setRequestIfModifiedSince(Date theModifiedSince) {
        this.myBundleEntryMutator.setRequestIfModifiedSince(theModifiedSince);
    }

    public void setRequestIfMatch(String theIfMatch) {
        this.myBundleEntryMutator.setRequestIfMatch(theIfMatch);
    }

    public void setRequestIfNoneExist(String theIfNoneExist) {
        this.myBundleEntryMutator.setRequestIfNoneExist(theIfNoneExist);
    }

    public void setMethod(RequestTypeEnum theMethod) {
        this.myMethod = theMethod;
        this.myBundleEntryMutator.setMethod(theMethod);
    }
}

