/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.util;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.RuntimeResourceDefinition;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.model.primitive.IdDt;
import ca.uhn.fhir.parser.DataFormatException;
import ca.uhn.fhir.rest.server.exceptions.InvalidRequestException;
import com.google.common.escape.Escaper;
import com.google.common.net.PercentEscaper;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.instance.model.api.IPrimitiveType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UrlUtil {
    private static final Logger ourLog = LoggerFactory.getLogger(UrlUtil.class);
    private static final String URL_FORM_PARAMETER_OTHER_SAFE_CHARS = "-_.*";
    private static final Escaper PARAMETER_ESCAPER_NO_SLASH = new PercentEscaper("-_.*/", false);
    private static final Escaper PARAMETER_ESCAPER = new PercentEscaper("-_.*", false);

    private UrlUtil() {
    }

    public static String sanitizeHeaderValue(String theHeader) {
        return theHeader.replace("\n", "").replace("\r", "");
    }

    public static String sanitizeBaseUrl(String theBaseUrl) {
        return theBaseUrl.replaceAll("[^a-zA-Z0-9:/._-]", "");
    }

    public static String constructAbsoluteUrl(String theBase, String theEndpoint) {
        if (theEndpoint == null) {
            return null;
        }
        if (UrlUtil.isAbsolute(theEndpoint)) {
            return theEndpoint;
        }
        if (theBase == null) {
            return theEndpoint;
        }
        try {
            return new URL(new URL(theBase), theEndpoint).toString();
        }
        catch (MalformedURLException e) {
            ourLog.warn("Failed to resolve relative URL[" + theEndpoint + "] against absolute base[" + theBase + "]", (Throwable)e);
            return theEndpoint;
        }
    }

    public static String constructRelativeUrl(String theParentExtensionUrl, String theExtensionUrl) {
        if (theParentExtensionUrl == null) {
            return theExtensionUrl;
        }
        if (theExtensionUrl == null) {
            return null;
        }
        int parentLastSlashIdx = theParentExtensionUrl.lastIndexOf(47);
        int childLastSlashIdx = theExtensionUrl.lastIndexOf(47);
        if (parentLastSlashIdx == -1 || childLastSlashIdx == -1) {
            return theExtensionUrl;
        }
        if (parentLastSlashIdx != childLastSlashIdx) {
            return theExtensionUrl;
        }
        if (!theParentExtensionUrl.substring(0, parentLastSlashIdx).equals(theExtensionUrl.substring(0, parentLastSlashIdx))) {
            return theExtensionUrl;
        }
        if (theExtensionUrl.length() > parentLastSlashIdx) {
            return theExtensionUrl.substring(parentLastSlashIdx + 1);
        }
        return theExtensionUrl;
    }

    @Nullable
    public static String determineResourceTypeInResourceUrl(FhirContext theFhirContext, String theUrl) {
        if (theUrl == null) {
            return null;
        }
        if (theUrl.startsWith("urn:")) {
            return null;
        }
        String resourceType = null;
        int qmIndex = theUrl.indexOf("?");
        if (qmIndex > 0) {
            String urlResourceType = theUrl.substring(0, qmIndex);
            int slashIdx = urlResourceType.lastIndexOf(47);
            if (slashIdx != -1) {
                urlResourceType = urlResourceType.substring(slashIdx + 1);
            }
            if (StringUtils.isNotBlank((CharSequence)urlResourceType)) {
                resourceType = urlResourceType;
            }
        } else {
            resourceType = theUrl;
            int slashIdx = resourceType.indexOf(47);
            if (slashIdx == 0) {
                resourceType = resourceType.substring(1);
            }
            if ((slashIdx = resourceType.indexOf(47)) != -1) {
                resourceType = new IdDt(resourceType).getResourceType();
            }
        }
        try {
            if (StringUtils.isNotBlank((CharSequence)resourceType)) {
                theFhirContext.getResourceDefinition(resourceType);
            }
        }
        catch (DataFormatException e) {
            return null;
        }
        return resourceType;
    }

    public static String escapeUrlParam(String theUnescaped) {
        return UrlUtil.escapeUrlParam(theUnescaped, true);
    }

    public static String escapeUrlParam(String theUnescaped, boolean theEscapeSlash) {
        if (theUnescaped == null) {
            return null;
        }
        if (theEscapeSlash) {
            return PARAMETER_ESCAPER.escape(theUnescaped);
        }
        return PARAMETER_ESCAPER_NO_SLASH.escape(theUnescaped);
    }

    public static List<String> escapeUrlParams(@Nonnull Collection<String> theUnescaped) {
        return theUnescaped.stream().map(t -> PARAMETER_ESCAPER.escape(t)).collect(Collectors.toList());
    }

    public static boolean isAbsolute(String theValue) {
        String value = theValue.toLowerCase();
        return value.startsWith("http://") || value.startsWith("https://");
    }

    public static boolean isNeedsSanitization(CharSequence theString) {
        if (theString != null) {
            for (int i = 0; i < theString.length(); ++i) {
                char nextChar = theString.charAt(i);
                switch (nextChar) {
                    case '\n': 
                    case '\r': 
                    case '\"': 
                    case '\'': 
                    case '<': 
                    case '>': {
                        return true;
                    }
                }
                if (nextChar >= ' ') continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isValid(String theUrl) {
        int slashOffset;
        if (theUrl == null || theUrl.length() < 8) {
            return false;
        }
        String url = theUrl.toLowerCase();
        if (url.charAt(0) != 'h') {
            return false;
        }
        if (url.charAt(1) != 't') {
            return false;
        }
        if (url.charAt(2) != 't') {
            return false;
        }
        if (url.charAt(3) != 'p') {
            return false;
        }
        if (url.charAt(4) == ':') {
            slashOffset = 5;
        } else if (url.charAt(4) == 's') {
            if (url.charAt(5) != ':') {
                return false;
            }
            slashOffset = 6;
        } else {
            return false;
        }
        if (url.charAt(slashOffset) != '/') {
            return false;
        }
        return url.charAt(slashOffset + 1) == '/';
    }

    public static RuntimeResourceDefinition parseUrlResourceType(FhirContext theCtx, String theUrl) throws DataFormatException {
        String resourceName;
        Object url = theUrl;
        int paramIndex = ((String)url).indexOf(63);
        if (paramIndex > 0 && ((String)url).charAt(paramIndex - 1) == '/') {
            url = ((String)url).substring(0, paramIndex - 1) + ((String)url).substring(paramIndex);
            --paramIndex;
        }
        if ((resourceName = ((String)url).substring(0, paramIndex)).contains("/")) {
            resourceName = resourceName.substring(resourceName.lastIndexOf(47) + 1);
        }
        return theCtx.getResourceDefinition(resourceName);
    }

    @Nonnull
    public static Map<String, String[]> parseQueryString(String theQueryString) {
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        UrlUtil.parseQueryString(theQueryString, map);
        return UrlUtil.toQueryStringMap(map);
    }

    private static void parseQueryString(String theQueryString, HashMap<String, List<String>> map) {
        String query = StringUtils.defaultString((String)theQueryString);
        if (query.startsWith("?")) {
            query = query.substring(1);
        }
        StringTokenizer tok = new StringTokenizer(query, "&");
        while (tok.hasMoreTokens()) {
            String nextValue;
            String nextKey;
            String nextToken = tok.nextToken();
            if (StringUtils.isBlank((CharSequence)nextToken)) continue;
            int equalsIndex = nextToken.indexOf(61);
            if (equalsIndex == -1) {
                nextKey = nextToken;
                nextValue = "";
            } else {
                nextKey = nextToken.substring(0, equalsIndex);
                nextValue = nextToken.substring(equalsIndex + 1);
            }
            nextKey = UrlUtil.unescape(nextKey);
            nextValue = UrlUtil.unescape(nextValue);
            List list = map.computeIfAbsent(nextKey, k -> new ArrayList());
            list.add(nextValue);
        }
    }

    public static Map<String, String[]> parseQueryStrings(String ... theQueryString) {
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        for (String next : theQueryString) {
            UrlUtil.parseQueryString(next, map);
        }
        return UrlUtil.toQueryStringMap(map);
    }

    public static String normalizeCanonicalUrlForComparison(String theUrl) {
        String retVal;
        try {
            retVal = new URI(theUrl).normalize().toString();
        }
        catch (URISyntaxException e) {
            retVal = theUrl;
        }
        while (StringUtils.endsWith((CharSequence)retVal, (CharSequence)"/")) {
            retVal = retVal.substring(0, retVal.length() - 1);
        }
        int hashOrPipeIndex = StringUtils.indexOfAny((CharSequence)retVal, (char[])new char[]{'#', '|'});
        if (hashOrPipeIndex != -1) {
            retVal = retVal.substring(0, hashOrPipeIndex);
        }
        return retVal;
    }

    public static UrlParts parseUrl(String theUrl) {
        String url = theUrl;
        UrlParts retVal = new UrlParts();
        if (url.startsWith("http")) {
            int qmIdx = url.indexOf(63);
            if (qmIdx != -1) {
                retVal.setParams((String)StringUtils.defaultIfBlank((CharSequence)url.substring(qmIdx + 1), null));
                url = url.substring(0, qmIdx);
            }
            IdDt id = new IdDt(url);
            retVal.setResourceType(id.getResourceType());
            retVal.setResourceId(id.getIdPart());
            retVal.setVersionId(id.getVersionIdPart());
            return retVal;
        }
        int parsingStart = 0;
        if (url.length() > 2 && url.charAt(0) == '/' && Character.isLetter(url.charAt(1))) {
            parsingStart = 1;
        }
        int nextStart = parsingStart;
        boolean nextIsHistory = false;
        for (int idx = parsingStart; idx < url.length(); ++idx) {
            boolean atEnd;
            char nextChar = url.charAt(idx);
            boolean bl = atEnd = idx + 1 == url.length();
            if (nextChar != '?' && nextChar != '/' && !atEnd) continue;
            int endIdx = atEnd && nextChar != '?' ? idx + 1 : idx;
            String nextSubstring = url.substring(nextStart, endIdx);
            if (retVal.getResourceType() == null) {
                retVal.setResourceType(nextSubstring);
            } else if (retVal.getResourceId() == null) {
                retVal.setResourceId(nextSubstring);
            } else if (nextIsHistory) {
                retVal.setVersionId(nextSubstring);
            } else if (nextSubstring.equals("_history")) {
                nextIsHistory = true;
            } else {
                throw new InvalidRequestException(Msg.code(1742) + "Invalid FHIR resource URL: " + url);
            }
            if (nextChar == '?') {
                if (url.length() <= idx + 1) break;
                retVal.setParams(url.substring(idx + 1));
                break;
            }
            nextStart = idx + 1;
        }
        return retVal;
    }

    public static String sanitizeUrlPart(IPrimitiveType<?> theString) {
        String retVal = null;
        if (theString != null) {
            retVal = UrlUtil.sanitizeUrlPart(theString.getValueAsString());
        }
        return retVal;
    }

    public static String sanitizeUrlPart(CharSequence theString) {
        if (theString == null) {
            return null;
        }
        boolean needsSanitization = UrlUtil.isNeedsSanitization(theString);
        if (needsSanitization) {
            StringBuilder buffer = new StringBuilder(theString.length() + 10);
            block8: for (int j = 0; j < theString.length(); ++j) {
                char nextChar = theString.charAt(j);
                switch (nextChar) {
                    case '\'': {
                        buffer.append("&apos;");
                        continue block8;
                    }
                    case '\"': {
                        buffer.append("&quot;");
                        continue block8;
                    }
                    case '<': {
                        buffer.append("&lt;");
                        continue block8;
                    }
                    case '>': {
                        buffer.append("&gt;");
                        continue block8;
                    }
                    case '\n': {
                        buffer.append("&#10;");
                        continue block8;
                    }
                    case '\r': {
                        buffer.append("&#13;");
                        continue block8;
                    }
                    default: {
                        if (nextChar < ' ') continue block8;
                        buffer.append(nextChar);
                    }
                }
            }
            return buffer.toString();
        }
        return theString.toString();
    }

    public static String[] sanitizeUrlPart(String[] theParameterValues) {
        String[] retVal = null;
        if (theParameterValues != null) {
            retVal = new String[theParameterValues.length];
            for (int i = 0; i < theParameterValues.length; ++i) {
                retVal[i] = UrlUtil.sanitizeUrlPart(theParameterValues[i]);
            }
        }
        return retVal;
    }

    private static Map<String, String[]> toQueryStringMap(HashMap<String, List<String>> map) {
        HashMap<String, String[]> retVal = new HashMap<String, String[]>();
        for (Map.Entry<String, List<String>> nextEntry : map.entrySet()) {
            retVal.put(nextEntry.getKey(), nextEntry.getValue().toArray(new String[0]));
        }
        return retVal;
    }

    public static String unescape(String theString) {
        if (theString == null) {
            return null;
        }
        boolean shouldEscapePlus = !theString.startsWith("application/");
        for (int i = 0; i < theString.length(); ++i) {
            char nextChar = theString.charAt(i);
            if (nextChar != '%' && (nextChar != '+' || !shouldEscapePlus)) continue;
            return URLDecoder.decode(theString, StandardCharsets.UTF_8);
        }
        return theString;
    }

    public static List<String> getAboveUriCandidates(String theUri) {
        try {
            URI uri = new URI(theUri);
            if (uri.getScheme() == null || uri.getHost() == null) {
                UrlUtil.throwInvalidRequestExceptionForNotValidUri(theUri, null);
            }
        }
        catch (URISyntaxException theCause) {
            UrlUtil.throwInvalidRequestExceptionForNotValidUri(theUri, theCause);
        }
        ArrayList<String> candidates = new ArrayList<String>();
        Path path = Paths.get(theUri, new String[0]);
        candidates.add(path.toString().replace(":/", "://"));
        while (path.getParent() != null && path.getParent().toString().contains("/")) {
            candidates.add(path.getParent().toString().replace(":/", "://"));
            path = path.getParent();
        }
        return candidates;
    }

    private static void throwInvalidRequestExceptionForNotValidUri(String theUri, Exception theCause) {
        throw new InvalidRequestException(Msg.code(2419) + String.format("Provided URI is not valid: %s", theUri), (Throwable)theCause);
    }

    public static class UrlParts {
        private String myParams;
        private String myResourceId;
        private String myResourceType;
        private String myVersionId;

        public String getParams() {
            return this.myParams;
        }

        public void setParams(String theParams) {
            this.myParams = theParams;
        }

        public String getResourceId() {
            return this.myResourceId;
        }

        public void setResourceId(String theResourceId) {
            this.myResourceId = theResourceId;
        }

        public String getResourceType() {
            return this.myResourceType;
        }

        public void setResourceType(String theResourceType) {
            this.myResourceType = theResourceType;
        }

        public String getVersionId() {
            return this.myVersionId;
        }

        public void setVersionId(String theVersionId) {
            this.myVersionId = theVersionId;
        }
    }
}

