/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.param;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.model.primitive.UriDt;
import ca.uhn.fhir.rest.param.BaseParam;
import ca.uhn.fhir.rest.param.ParameterUtil;
import ca.uhn.fhir.rest.param.StringParam;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpecialParam
extends BaseParam {
    private static final Logger ourLog = LoggerFactory.getLogger(StringParam.class);
    private String myValue;
    private boolean myContains;

    @Override
    String doGetQueryParameterQualifier() {
        if (this.myContains) {
            return ":contains";
        }
        return null;
    }

    @Override
    String doGetValueAsQueryToken() {
        return ParameterUtil.escape(this.getValue());
    }

    @Override
    void doSetValueAsQueryToken(FhirContext theContext, String theParamName, String theQualifier, String theParameter) {
        if (":contains".equals(theQualifier)) {
            if (theParamName.equalsIgnoreCase("_text") || theParamName.equalsIgnoreCase("_content")) {
                this.setContains(true);
            } else {
                ourLog.debug("Attempted to set the :contains modifier on a special search parameter that was not `_text` or `_content`. This is not supported.");
            }
        }
        this.setValue(ParameterUtil.unescape(theParameter));
    }

    public String getValue() {
        return this.myValue;
    }

    public String getValueNotNull() {
        return StringUtils.defaultString((String)this.myValue);
    }

    public SpecialParam setValue(String theValue) {
        this.myValue = theValue;
        return this;
    }

    public String toString() {
        ToStringBuilder builder = new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE);
        builder.append("value", (Object)this.getValue());
        if (this.getMissing() != null) {
            builder.append(":missing", (Object)this.getMissing());
        }
        return builder.toString();
    }

    private static String toSystemValue(UriDt theSystem) {
        return theSystem.getValueAsString();
    }

    public boolean isContains() {
        return this.myContains;
    }

    public SpecialParam setContains(boolean theContains) {
        this.myContains = theContains;
        if (this.myContains) {
            this.setMissing(null);
        }
        return this;
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder(17, 37).append(this.isContains()).append((Object)this.getValue()).append((Object)this.getMissing()).toHashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SpecialParam)) {
            return false;
        }
        SpecialParam other = (SpecialParam)obj;
        EqualsBuilder eb = new EqualsBuilder();
        eb.append(this.myContains, other.myContains);
        eb.append((Object)this.myValue, (Object)other.myValue);
        eb.append((Object)this.getMissing(), (Object)other.getMissing());
        return eb.isEquals();
    }
}

