/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.parser;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.parser.BaseParser;
import ca.uhn.fhir.parser.DataFormatException;
import ca.uhn.fhir.parser.IParser;
import ca.uhn.fhir.parser.IParserErrorHandler;
import ca.uhn.fhir.rest.api.EncodingEnum;
import ca.uhn.fhir.util.BundleBuilder;
import ca.uhn.fhir.util.BundleUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.List;
import org.hl7.fhir.instance.model.api.IBaseBundle;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NDJsonParser
extends BaseParser {
    private static final Logger ourLog = LoggerFactory.getLogger(NDJsonParser.class);
    private IParser myJsonParser;
    private FhirContext myFhirContext;

    public NDJsonParser(FhirContext theContext, IParserErrorHandler theParserErrorHandler) {
        super(theContext, theParserErrorHandler);
        this.myFhirContext = theContext;
        this.myJsonParser = theContext.newJsonParser().setPrettyPrint(false);
    }

    @Override
    public IParser setPrettyPrint(boolean thePrettyPrint) {
        return this;
    }

    @Override
    public EncodingEnum getEncoding() {
        return EncodingEnum.NDJSON;
    }

    @Override
    protected void doEncodeResourceToWriter(IBaseResource theResource, Writer theWriter, BaseParser.EncodeContext theEncodeContext) throws IOException {
        if (!IBaseBundle.class.isAssignableFrom(theResource.getClass())) {
            throw new IllegalArgumentException(Msg.code(1833) + "NDJsonParser can only encode Bundle types.  Received " + theResource.getClass().getName());
        }
        List<IBaseResource> theBundleResources = BundleUtil.toListOfResources(this.myFhirContext, (IBaseBundle)theResource);
        boolean isFirstResource = true;
        for (IBaseResource theBundleEntryResource : theBundleResources) {
            if (!isFirstResource) {
                theWriter.write("\n");
            }
            isFirstResource = false;
            this.myJsonParser.encodeResourceToWriter(theBundleEntryResource, theWriter);
        }
    }

    @Override
    public <T extends IBaseResource> T doParseResource(Class<T> theResourceType, Reader theReader) throws DataFormatException {
        if (theResourceType != null && !IBaseBundle.class.isAssignableFrom(theResourceType)) {
            throw new DataFormatException(Msg.code(1834) + "NDJsonParser can only parse to Bundle types.  Received " + theResourceType.getName());
        }
        try {
            BundleBuilder myBuilder = new BundleBuilder(this.myFhirContext);
            myBuilder.setType("collection");
            BufferedReader myBufferedReader = new BufferedReader(theReader);
            String jsonString = myBufferedReader.readLine();
            while (jsonString != null) {
                myBuilder.addCollectionEntry(this.myJsonParser.parseResource(jsonString.trim()));
                jsonString = myBufferedReader.readLine();
            }
            return (T)myBuilder.getBundle();
        }
        catch (IOException err) {
            throw new DataFormatException(Msg.code(1835) + err.getMessage());
        }
    }
}

