/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.i18n;

import jakarta.annotation.Nonnull;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.ResourceBundle;

public class MultiFileResourceBundleControl
extends ResourceBundle.Control {
    @Override
    public List<Locale> getCandidateLocales(String baseName, Locale locale) {
        return Collections.singletonList(Locale.ROOT);
    }

    @Override
    public Locale getFallbackLocale(String baseName, Locale locale) {
        return null;
    }

    @Override
    public ResourceBundle newBundle(String baseName, Locale locale, String format, ClassLoader loader, boolean reload) throws IOException, IllegalAccessException, InstantiationException {
        if (!"java.properties".equals(format) || locale != null && !locale.toString().isEmpty()) {
            return super.newBundle(baseName, locale, format, loader, reload);
        }
        String resourceName = this.toResourceName(this.toBundleName(baseName, locale), "properties");
        Properties mergedProperties = new Properties();
        Enumeration<URL> resources = loader.getResources(resourceName);
        while (resources.hasMoreElements()) {
            URL url = resources.nextElement();
            InputStream is = url.openStream();
            try {
                mergedProperties.load(is);
            }
            finally {
                if (is == null) continue;
                is.close();
            }
        }
        return new PropertiesResourceBundle(mergedProperties);
    }

    private static class PropertiesResourceBundle
    extends ResourceBundle {
        private final Properties properties;

        PropertiesResourceBundle(Properties properties) {
            this.properties = properties;
        }

        @Override
        protected Object handleGetObject(@Nonnull String key) {
            return this.properties.getProperty(key);
        }

        @Override
        @Nonnull
        public Enumeration<String> getKeys() {
            return Collections.enumeration(this.properties.stringPropertyNames());
        }
    }
}

