/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.util;

import com.google.common.annotations.VisibleForTesting;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Date;
import java.util.LinkedList;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.Validate;

public class StopWatch {
    private static Long ourNowForUnitTest;
    private long myStarted = StopWatch.now();
    private TaskTiming myCurrentTask;
    private LinkedList<TaskTiming> myTasks;

    public StopWatch() {
    }

    public StopWatch(Date theStart) {
        this.myStarted = theStart.getTime();
    }

    public StopWatch(long theStart) {
        this.myStarted = theStart;
    }

    private void addNewlineIfContentExists(StringBuilder theB) {
        if (theB.length() > 0) {
            theB.append("\n");
        }
    }

    public void endCurrentTask() {
        this.ensureTasksListExists();
        if (this.myCurrentTask != null) {
            this.myCurrentTask.setEnd(StopWatch.now());
        }
        this.myCurrentTask = null;
    }

    private void ensureTasksListExists() {
        if (this.myTasks == null) {
            this.myTasks = new LinkedList();
        }
    }

    public String formatMillisPerOperation(long theNumOperations) {
        double millisPerOperation = (double)this.getMillis() / Math.max(1.0, (double)theNumOperations);
        return StopWatch.formatMillis(millisPerOperation);
    }

    public String formatTaskDurations() {
        long delta;
        this.ensureTasksListExists();
        StringBuilder b = new StringBuilder();
        if (this.myTasks.size() > 0) {
            long delta2 = this.myTasks.getFirst().getStart() - this.myStarted;
            if (delta2 > 10L) {
                this.addNewlineIfContentExists(b);
                b.append("Before first task");
                b.append(": ");
                b.append(StopWatch.formatMillis(delta2));
            }
        } else {
            b.append("No tasks");
        }
        TaskTiming last = null;
        for (TaskTiming nextTask : this.myTasks) {
            long delta3;
            if (last != null && (delta3 = nextTask.getStart() - last.getEnd()) > 10L) {
                this.addNewlineIfContentExists(b);
                b.append("Between");
                b.append(": ");
                b.append(StopWatch.formatMillis(delta3));
            }
            this.addNewlineIfContentExists(b);
            b.append(nextTask.getTaskName());
            b.append(": ");
            delta3 = nextTask.getMillis();
            b.append(StopWatch.formatMillis(delta3));
            last = nextTask;
        }
        if (this.myTasks.size() > 0 && (delta = StopWatch.now() - this.myTasks.getLast().getEnd()) > 10L) {
            this.addNewlineIfContentExists(b);
            b.append("After last task");
            b.append(": ");
            b.append(StopWatch.formatMillis(delta));
        }
        return b.toString();
    }

    public String formatThroughput(long theNumOperations, TimeUnit theUnit) {
        double throughput = this.getThroughput(theNumOperations, theUnit);
        return StopWatch.formatThroughput(throughput);
    }

    public String getEstimatedTimeRemaining(double theCompleteToDate, double theTotal) {
        double millis = this.getMillis();
        return StopWatch.formatEstimatedTimeRemaining(theCompleteToDate, theTotal, millis);
    }

    public static String formatEstimatedTimeRemaining(double theCompleteToDate, double theTotal, double millis) {
        long millisRemaining = (long)(theTotal / theCompleteToDate * millis - millis);
        return StopWatch.formatMillis(millisRemaining);
    }

    public long getMillis(Date theNow) {
        return theNow.getTime() - this.myStarted;
    }

    public long getMillis() {
        long now = StopWatch.now();
        return now - this.myStarted;
    }

    public long getMillisAndRestart() {
        long now = StopWatch.now();
        long retVal = now - this.myStarted;
        this.myStarted = now;
        return retVal;
    }

    public long getMillisPerOperation(long theNumOperations) {
        return (long)((double)this.getMillis() / Math.max(1.0, (double)theNumOperations));
    }

    public Date getStartedDate() {
        return new Date(this.myStarted);
    }

    public double getThroughput(long theNumOperations, TimeUnit theUnit) {
        long millis = this.getMillis();
        return StopWatch.getThroughput(theNumOperations, millis, theUnit);
    }

    public void restart() {
        this.myStarted = StopWatch.now();
    }

    public void startTask(String theTaskName) {
        this.endCurrentTask();
        Validate.notBlank((CharSequence)theTaskName, (String)"Task name must not be blank", (Object[])new Object[0]);
        this.myCurrentTask = new TaskTiming().setTaskName(theTaskName).setStart(StopWatch.now());
        this.myTasks.add(this.myCurrentTask);
    }

    public String toString() {
        return StopWatch.formatMillis(this.getMillis());
    }

    public static String formatThroughput(double throughput) {
        return StopWatch.formatDouble(throughput);
    }

    static String formatDouble(double theDouble) {
        double abs = Math.abs(theDouble);
        if (abs > 1000.0) {
            return Long.toString(Math.round(theDouble));
        }
        if (abs > 100.0) {
            return Double.toString((double)Math.round(theDouble * 10.0) / 10.0);
        }
        return Double.toString((double)Math.round(theDouble * 100.0) / 100.0);
    }

    public static double getThroughput(long theNumOperations, long theMillisElapsed, TimeUnit theUnit) {
        long periodMillis;
        if (theNumOperations <= 0L) {
            return 0.0;
        }
        long millisElapsed = Math.max(1L, theMillisElapsed);
        double denominator = (double)millisElapsed / (double)(periodMillis = theUnit.toMillis(1L));
        double throughput = (double)theNumOperations / denominator;
        if (throughput > (double)theNumOperations) {
            throughput = theNumOperations;
        }
        return throughput;
    }

    private static NumberFormat getDayFormat() {
        return new DecimalFormat("0.0");
    }

    private static NumberFormat getTenDayFormat() {
        return new DecimalFormat("0");
    }

    private static NumberFormat getSubMillisecondMillisFormat() {
        return new DecimalFormat("0.000");
    }

    static void appendRightAlignedNumber(StringBuilder theStringBuilder, String thePrefix, int theNumberOfDigits, long theValueToAppend) {
        theStringBuilder.append(thePrefix);
        if (theNumberOfDigits > 1) {
            int pad = theNumberOfDigits - 1;
            for (long xa = theValueToAppend; xa > 9L && pad > 0; --pad, xa /= 10L) {
            }
            for (int xa = 0; xa < pad; ++xa) {
                theStringBuilder.append('0');
            }
        }
        theStringBuilder.append(theValueToAppend);
    }

    public static String formatMillis(long theMillis) {
        return StopWatch.formatMillis((double)theMillis);
    }

    public static String formatMillis(double theMillis) {
        StringBuilder buf = new StringBuilder(20);
        if (theMillis > 0.0 && theMillis < 1.0) {
            buf.append(StopWatch.getSubMillisecondMillisFormat().format(theMillis));
            buf.append("ms");
        } else if (theMillis < 10000.0) {
            buf.append((int)theMillis);
            buf.append("ms");
        } else if (theMillis >= 8.64E7) {
            double days = theMillis / 8.64E7;
            if (days >= 10.0) {
                buf.append(StopWatch.getTenDayFormat().format(days));
                buf.append(" days");
            } else if (days != 1.0) {
                buf.append(StopWatch.getDayFormat().format(days));
                buf.append(" days");
            } else {
                buf.append(StopWatch.getDayFormat().format(days));
                buf.append(" day");
            }
        } else {
            long millisAsLong = (long)theMillis;
            StopWatch.appendRightAlignedNumber(buf, "", 2, millisAsLong % 86400000L / 3600000L);
            StopWatch.appendRightAlignedNumber(buf, ":", 2, millisAsLong % 3600000L / 60000L);
            StopWatch.appendRightAlignedNumber(buf, ":", 2, millisAsLong % 60000L / 1000L);
            if (theMillis <= 60000.0) {
                StopWatch.appendRightAlignedNumber(buf, ".", 3, millisAsLong % 1000L);
            }
        }
        return buf.toString();
    }

    private static long now() {
        if (ourNowForUnitTest != null) {
            return ourNowForUnitTest;
        }
        return System.currentTimeMillis();
    }

    @VisibleForTesting
    public static void setNowForUnitTest(Long theNowForUnitTest) {
        ourNowForUnitTest = theNowForUnitTest;
    }

    private static class TaskTiming {
        private long myStart;
        private long myEnd;
        private String myTaskName;

        private TaskTiming() {
        }

        public long getEnd() {
            if (this.myEnd == 0L) {
                return StopWatch.now();
            }
            return this.myEnd;
        }

        public TaskTiming setEnd(long theEnd) {
            this.myEnd = theEnd;
            return this;
        }

        public long getMillis() {
            return this.getEnd() - this.getStart();
        }

        public long getStart() {
            return this.myStart;
        }

        public TaskTiming setStart(long theStart) {
            this.myStart = theStart;
            return this;
        }

        public String getTaskName() {
            return this.myTaskName;
        }

        public TaskTiming setTaskName(String theTaskName) {
            this.myTaskName = theTaskName;
            return this;
        }
    }
}

