/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.util;

import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.rest.server.exceptions.InternalErrorException;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.text.DecimalFormat;
import org.apache.commons.io.FileUtils;

public class FileUtil {
    private static final String[] UNITS = new String[]{"Bytes", "kB", "MB", "GB", "TB"};

    public static String formatFileSize(long theBytes) {
        if (theBytes <= 0L) {
            return "0 " + UNITS[0];
        }
        int digitGroups = (int)(Math.log10(theBytes) / Math.log10(1024.0));
        digitGroups = Math.min(digitGroups, UNITS.length - 1);
        return new DecimalFormat("###0.#").format((double)theBytes / Math.pow(1024.0, digitGroups)) + " " + UNITS[digitGroups];
    }

    public static String loadFileAsString(File theFile) throws InternalErrorException {
        try {
            return FileUtils.readFileToString((File)theFile, (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            throw new InternalErrorException(Msg.code(2592) + String.valueOf(e), (Throwable)e);
        }
    }
}

