/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.util;

import ca.uhn.fhir.context.BaseRuntimeChildDefinition;
import ca.uhn.fhir.context.BaseRuntimeElementDefinition;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.model.api.ICompositeElement;
import ca.uhn.fhir.model.api.IElement;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.function.Function;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IPrimitiveType;

public class ElementUtil {
    public static final Function<IBase, String> CONVERT_PRIMITIVE_TO_STRING = e -> ((IPrimitiveType)e).getValueAsString();
    public static final Function<IBase, IBaseResource> CAST_BASE_TO_RESOURCE = e -> (IBaseResource)e;
    public static final Function<IBase, IPrimitiveType<Date>> CAST_TO_PRIMITIVE_DATE = e -> (IPrimitiveType)e;

    public static boolean isEmpty(Object ... theElements) {
        if (theElements == null) {
            return true;
        }
        for (int i = 0; i < theElements.length; ++i) {
            Object next = theElements[i];
            if (next instanceof List) {
                if (ElementUtil.isEmpty((List)next)) continue;
                return false;
            }
            if (next instanceof String && !((String)next).isEmpty()) {
                return false;
            }
            if (next == null || ((IBase)next).isEmpty()) continue;
            return false;
        }
        return true;
    }

    public static boolean isEmpty(IBase ... theElements) {
        if (theElements == null) {
            return true;
        }
        for (int i = 0; i < theElements.length; ++i) {
            IBase next = theElements[i];
            if (next == null || next.isEmpty()) continue;
            return false;
        }
        return true;
    }

    public static boolean isEmpty(IElement ... theElements) {
        if (theElements == null) {
            return true;
        }
        for (int i = 0; i < theElements.length; ++i) {
            IElement next = theElements[i];
            if (next == null || next.isEmpty()) continue;
            return false;
        }
        return true;
    }

    public static boolean isEmpty(List<? extends IBase> theElements) {
        if (theElements == null) {
            return true;
        }
        for (int i = 0; i < theElements.size(); ++i) {
            IBase next;
            try {
                next = theElements.get(i);
            }
            catch (ClassCastException e) {
                List<? extends IBase> elements = theElements;
                String s = "Found instance of " + String.valueOf(elements.get(i).getClass()) + " - Did you set a field value to the incorrect type? Expected " + IBase.class.getName();
                throw new ClassCastException(Msg.code(1748) + s);
            }
            if (next == null || next.isEmpty()) continue;
            return false;
        }
        return true;
    }

    public static <T extends IElement> List<T> allPopulatedChildElements(Class<T> theType, Object ... theElements) {
        ArrayList retVal = new ArrayList();
        for (Object next : theElements) {
            if (next == null) continue;
            if (next instanceof IElement) {
                ElementUtil.addElement(retVal, (IElement)next, theType);
                continue;
            }
            if (next instanceof List) {
                for (Object nextElement : (List)next) {
                    if (!(nextElement instanceof IBase)) {
                        throw new IllegalArgumentException(Msg.code(1749) + "Found element of " + String.valueOf(nextElement.getClass()));
                    }
                    ElementUtil.addElement(retVal, (IElement)nextElement, theType);
                }
                continue;
            }
            throw new IllegalArgumentException(Msg.code(1750) + "Found element of " + String.valueOf(next.getClass()));
        }
        return retVal;
    }

    private static <T extends IElement> void addElement(ArrayList<T> retVal, IElement next, Class<T> theType) {
        if (theType != null && theType.isAssignableFrom(next.getClass())) {
            retVal.add((IElement)theType.cast(next));
        }
        if (next instanceof ICompositeElement) {
            ICompositeElement iCompositeElement = (ICompositeElement)next;
            retVal.addAll(iCompositeElement.getAllPopulatedChildElementsOfType(theType));
        }
    }

    public static IBase setValue(IBase theTarget, BaseRuntimeChildDefinition theChildDef, Object theValue) {
        BaseRuntimeElementDefinition<?> elementDefinition = theChildDef.getChildByName(theChildDef.getElementName());
        IBase value = theValue == null || elementDefinition.getImplementingClass().isInstance(theValue) ? (IBase)theValue : elementDefinition.newInstance(theValue);
        theChildDef.getMutator().setValue(theTarget, value);
        return value;
    }

    @Nullable
    public static <T> T getSingleValueOrNull(IBase theParentElement, BaseRuntimeChildDefinition theChildDefinition, Function<IBase, T> theConverter) {
        if (theParentElement == null) {
            return null;
        }
        return theChildDefinition.getAccessor().getFirstValueOrNull(theParentElement).map(theConverter).orElse(null);
    }
}

