/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.util;

import ca.uhn.fhir.context.BaseRuntimeChildDefinition;
import ca.uhn.fhir.context.BaseRuntimeElementCompositeDefinition;
import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.util.FhirTerser;
import java.util.List;
import java.util.Map;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IPrimitiveType;

public class CanonicalBundleEntry {
    private String myFullUrl;
    private IBaseResource myResource;
    private String myRequestMethod;
    private String myRequestUrl;
    private String myRequestIfNoneMatch;
    private String myRequestIfModifiedSince;
    private String myRequestIfMatch;
    private String myRequestIfNoneExist;
    private String myResponseStatus;
    private String myResponseLocation;
    private String myResponseEtag;
    private String myResponseLastModified;
    private String mySearchMode;
    private String mySearchScore;
    private List<Map<String, String>> myLinks;

    public String getFullUrl() {
        return this.myFullUrl;
    }

    public void setFullUrl(String theFullUrl) {
        this.myFullUrl = theFullUrl;
    }

    public IBaseResource getResource() {
        return this.myResource;
    }

    public void setResource(IBaseResource theResource) {
        this.myResource = theResource;
    }

    public String getRequestMethod() {
        return this.myRequestMethod;
    }

    public void setRequestMethod(String theRequestMethod) {
        this.myRequestMethod = theRequestMethod;
    }

    public String getRequestUrl() {
        return this.myRequestUrl;
    }

    public void setRequestUrl(String theRequestUrl) {
        this.myRequestUrl = theRequestUrl;
    }

    public String getRequestIfNoneMatch() {
        return this.myRequestIfNoneMatch;
    }

    public void setRequestIfNoneMatch(String theRequestIfNoneMatch) {
        this.myRequestIfNoneMatch = theRequestIfNoneMatch;
    }

    public String getRequestIfModifiedSince() {
        return this.myRequestIfModifiedSince;
    }

    public void setRequestIfModifiedSince(String theRequestIfModifiedSince) {
        this.myRequestIfModifiedSince = theRequestIfModifiedSince;
    }

    public String getRequestIfMatch() {
        return this.myRequestIfMatch;
    }

    public void setRequestIfMatch(String theRequestIfMatch) {
        this.myRequestIfMatch = theRequestIfMatch;
    }

    public String getRequestIfNoneExist() {
        return this.myRequestIfNoneExist;
    }

    public void setRequestIfNoneExist(String theRequestIfNoneExist) {
        this.myRequestIfNoneExist = theRequestIfNoneExist;
    }

    public String getResponseStatus() {
        return this.myResponseStatus;
    }

    public void setResponseStatus(String theResponseStatus) {
        this.myResponseStatus = theResponseStatus;
    }

    public String getResponseLocation() {
        return this.myResponseLocation;
    }

    public void setResponseLocation(String theResponseLocation) {
        this.myResponseLocation = theResponseLocation;
    }

    public String getResponseEtag() {
        return this.myResponseEtag;
    }

    public void setResponseEtag(String theResponseEtag) {
        this.myResponseEtag = theResponseEtag;
    }

    public String getResponseLastModified() {
        return this.myResponseLastModified;
    }

    public void setResponseLastModified(String theResponseLastModified) {
        this.myResponseLastModified = theResponseLastModified;
    }

    public String getSearchMode() {
        return this.mySearchMode;
    }

    public void setSearchMode(String theSearchMode) {
        this.mySearchMode = theSearchMode;
    }

    public String getSearchScore() {
        return this.mySearchScore;
    }

    public void setSearchScore(String theSearchScore) {
        this.mySearchScore = theSearchScore;
    }

    public List<Map<String, String>> getLinks() {
        return this.myLinks;
    }

    public void setLinks(List<Map<String, String>> theLinks) {
        this.myLinks = theLinks;
    }

    public static CanonicalBundleEntry fromBundleEntry(FhirContext theFhirContext, IBaseBackboneElement theEntry) {
        IBaseBackboneElement search;
        IBaseBackboneElement response;
        IBaseBackboneElement request;
        IBaseResource resource;
        CanonicalBundleEntry retVal = new CanonicalBundleEntry();
        FhirTerser terser = theFhirContext.newTerser();
        IPrimitiveType fullUrlElement = terser.getSingleValueOrNull(theEntry, "fullUrl", IPrimitiveType.class);
        if (fullUrlElement != null) {
            retVal.setFullUrl(fullUrlElement.getValueAsString());
        }
        if ((resource = terser.getSingleValueOrNull(theEntry, "resource", IBaseResource.class)) != null) {
            retVal.setResource(resource);
        }
        if ((request = terser.getSingleValueOrNull(theEntry, "request", IBaseBackboneElement.class)) != null) {
            IPrimitiveType ifNoneExist;
            IPrimitiveType ifMatch;
            IPrimitiveType ifModifiedSince;
            IPrimitiveType ifNoneMatch;
            IPrimitiveType url;
            IPrimitiveType method = terser.getSingleValueOrNull(request, "method", IPrimitiveType.class);
            if (method != null) {
                retVal.setRequestMethod(method.getValueAsString());
            }
            if ((url = terser.getSingleValueOrNull(request, "url", IPrimitiveType.class)) != null) {
                retVal.setRequestUrl(url.getValueAsString());
            }
            if ((ifNoneMatch = terser.getSingleValueOrNull(request, "ifNoneMatch", IPrimitiveType.class)) != null) {
                retVal.setRequestIfNoneMatch(ifNoneMatch.getValueAsString());
            }
            if ((ifModifiedSince = terser.getSingleValueOrNull(request, "ifModifiedSince", IPrimitiveType.class)) != null) {
                retVal.setRequestIfModifiedSince(ifModifiedSince.getValueAsString());
            }
            if ((ifMatch = terser.getSingleValueOrNull(request, "ifMatch", IPrimitiveType.class)) != null) {
                retVal.setRequestIfMatch(ifMatch.getValueAsString());
            }
            if ((ifNoneExist = terser.getSingleValueOrNull(request, "ifNoneExist", IPrimitiveType.class)) != null) {
                retVal.setRequestIfNoneExist(ifNoneExist.getValueAsString());
            }
        }
        if ((response = terser.getSingleValueOrNull(theEntry, "response", IBaseBackboneElement.class)) != null) {
            IPrimitiveType lastModified;
            IPrimitiveType etag;
            IPrimitiveType location;
            IPrimitiveType status = terser.getSingleValueOrNull(response, "status", IPrimitiveType.class);
            if (status != null) {
                retVal.setResponseStatus(status.getValueAsString());
            }
            if ((location = terser.getSingleValueOrNull(response, "location", IPrimitiveType.class)) != null) {
                retVal.setResponseLocation(location.getValueAsString());
            }
            if ((etag = terser.getSingleValueOrNull(response, "etag", IPrimitiveType.class)) != null) {
                retVal.setResponseEtag(etag.getValueAsString());
            }
            if ((lastModified = terser.getSingleValueOrNull(response, "lastModified", IPrimitiveType.class)) != null) {
                retVal.setResponseLastModified(lastModified.getValueAsString());
            }
        }
        if ((search = terser.getSingleValueOrNull(theEntry, "search", IBaseBackboneElement.class)) != null) {
            IPrimitiveType score;
            IPrimitiveType mode = terser.getSingleValueOrNull(search, "mode", IPrimitiveType.class);
            if (mode != null) {
                retVal.setSearchMode(mode.getValueAsString());
            }
            if ((score = terser.getSingleValueOrNull(search, "score", IPrimitiveType.class)) != null) {
                retVal.setSearchScore(score.getValueAsString());
            }
        }
        return retVal;
    }

    public <T extends IBase> T toBundleEntry(FhirContext theFhirContext, Class<T> theBundleEntryComponentClass) {
        BaseRuntimeChildDefinition searchChild;
        BaseRuntimeChildDefinition responseChild;
        BaseRuntimeChildDefinition requestChild;
        BaseRuntimeChildDefinition resourceChild;
        BaseRuntimeChildDefinition fullUrlChild;
        Object entry = theFhirContext.getElementDefinition(theBundleEntryComponentClass).newInstance();
        BaseRuntimeElementCompositeDefinition entryDef = (BaseRuntimeElementCompositeDefinition)theFhirContext.getElementDefinition(theBundleEntryComponentClass);
        if (this.myFullUrl != null && (fullUrlChild = entryDef.getChildByName("fullUrl")) != null) {
            IPrimitiveType fullUrlValue = (IPrimitiveType)fullUrlChild.getChildByName("fullUrl").newInstance();
            fullUrlValue.setValueAsString(this.myFullUrl);
            fullUrlChild.getMutator().setValue((IBase)entry, fullUrlValue);
        }
        if (this.myResource != null && (resourceChild = entryDef.getChildByName("resource")) != null) {
            resourceChild.getMutator().setValue((IBase)entry, this.myResource);
        }
        if ((this.myRequestMethod != null || this.myRequestUrl != null || this.myRequestIfNoneMatch != null || this.myRequestIfModifiedSince != null || this.myRequestIfMatch != null || this.myRequestIfNoneExist != null) && (requestChild = entryDef.getChildByName("request")) != null) {
            BaseRuntimeChildDefinition ifNoneExistChild;
            BaseRuntimeChildDefinition ifMatchChild;
            BaseRuntimeChildDefinition ifModifiedSinceChild;
            BaseRuntimeChildDefinition ifNoneMatchChild;
            BaseRuntimeChildDefinition urlChild;
            BaseRuntimeChildDefinition methodChild;
            Object request = requestChild.getChildByName("request").newInstance();
            requestChild.getMutator().setValue((IBase)entry, (IBase)request);
            BaseRuntimeElementCompositeDefinition requestDef = (BaseRuntimeElementCompositeDefinition)requestChild.getChildByName("request");
            if (this.myRequestMethod != null && (methodChild = requestDef.getChildByName("method")) != null) {
                IPrimitiveType methodValue = (IPrimitiveType)methodChild.getChildByName("method").newInstance(methodChild.getInstanceConstructorArguments());
                methodValue.setValueAsString(this.myRequestMethod);
                methodChild.getMutator().setValue((IBase)request, methodValue);
            }
            if (this.myRequestUrl != null && (urlChild = requestDef.getChildByName("url")) != null) {
                IPrimitiveType urlValue = (IPrimitiveType)urlChild.getChildByName("url").newInstance();
                urlValue.setValueAsString(this.myRequestUrl);
                urlChild.getMutator().setValue((IBase)request, urlValue);
            }
            if (this.myRequestIfNoneMatch != null && (ifNoneMatchChild = requestDef.getChildByName("ifNoneMatch")) != null) {
                IPrimitiveType ifNoneMatchValue = (IPrimitiveType)ifNoneMatchChild.getChildByName("ifNoneMatch").newInstance();
                ifNoneMatchValue.setValueAsString(this.myRequestIfNoneMatch);
                ifNoneMatchChild.getMutator().setValue((IBase)request, ifNoneMatchValue);
            }
            if (this.myRequestIfModifiedSince != null && (ifModifiedSinceChild = requestDef.getChildByName("ifModifiedSince")) != null) {
                IPrimitiveType ifModifiedSinceValue = (IPrimitiveType)ifModifiedSinceChild.getChildByName("ifModifiedSince").newInstance();
                ifModifiedSinceValue.setValueAsString(this.myRequestIfModifiedSince);
                ifModifiedSinceChild.getMutator().setValue((IBase)request, ifModifiedSinceValue);
            }
            if (this.myRequestIfMatch != null && (ifMatchChild = requestDef.getChildByName("ifMatch")) != null) {
                IPrimitiveType ifMatchValue = (IPrimitiveType)ifMatchChild.getChildByName("ifMatch").newInstance();
                ifMatchValue.setValueAsString(this.myRequestIfMatch);
                ifMatchChild.getMutator().setValue((IBase)request, ifMatchValue);
            }
            if (this.myRequestIfNoneExist != null && (ifNoneExistChild = requestDef.getChildByName("ifNoneExist")) != null) {
                IPrimitiveType ifNoneExistValue = (IPrimitiveType)ifNoneExistChild.getChildByName("ifNoneExist").newInstance();
                ifNoneExistValue.setValueAsString(this.myRequestIfNoneExist);
                ifNoneExistChild.getMutator().setValue((IBase)request, ifNoneExistValue);
            }
        }
        if ((this.myResponseStatus != null || this.myResponseLocation != null || this.myResponseEtag != null || this.myResponseLastModified != null) && (responseChild = entryDef.getChildByName("response")) != null) {
            BaseRuntimeChildDefinition lastModifiedChild;
            BaseRuntimeChildDefinition etagChild;
            BaseRuntimeChildDefinition locationChild;
            BaseRuntimeChildDefinition statusChild;
            Object response = responseChild.getChildByName("response").newInstance();
            responseChild.getMutator().setValue((IBase)entry, (IBase)response);
            BaseRuntimeElementCompositeDefinition responseDef = (BaseRuntimeElementCompositeDefinition)responseChild.getChildByName("response");
            if (this.myResponseStatus != null && (statusChild = responseDef.getChildByName("status")) != null) {
                IPrimitiveType statusValue = (IPrimitiveType)statusChild.getChildByName("status").newInstance();
                statusValue.setValueAsString(this.myResponseStatus);
                statusChild.getMutator().setValue((IBase)response, statusValue);
            }
            if (this.myResponseLocation != null && (locationChild = responseDef.getChildByName("location")) != null) {
                IPrimitiveType locationValue = (IPrimitiveType)locationChild.getChildByName("location").newInstance();
                locationValue.setValueAsString(this.myResponseLocation);
                locationChild.getMutator().setValue((IBase)response, locationValue);
            }
            if (this.myResponseEtag != null && (etagChild = responseDef.getChildByName("etag")) != null) {
                IPrimitiveType etagValue = (IPrimitiveType)etagChild.getChildByName("etag").newInstance();
                etagValue.setValueAsString(this.myResponseEtag);
                etagChild.getMutator().setValue((IBase)response, etagValue);
            }
            if (this.myResponseLastModified != null && (lastModifiedChild = responseDef.getChildByName("lastModified")) != null) {
                IPrimitiveType lastModifiedValue = (IPrimitiveType)lastModifiedChild.getChildByName("lastModified").newInstance();
                lastModifiedValue.setValueAsString(this.myResponseLastModified);
                lastModifiedChild.getMutator().setValue((IBase)response, lastModifiedValue);
            }
        }
        if ((this.mySearchMode != null || this.mySearchScore != null) && (searchChild = entryDef.getChildByName("search")) != null) {
            BaseRuntimeChildDefinition scoreChild;
            BaseRuntimeChildDefinition modeChild;
            Object search = searchChild.getChildByName("search").newInstance();
            searchChild.getMutator().setValue((IBase)entry, (IBase)search);
            BaseRuntimeElementCompositeDefinition searchDef = (BaseRuntimeElementCompositeDefinition)searchChild.getChildByName("search");
            if (this.mySearchMode != null && (modeChild = searchDef.getChildByName("mode")) != null) {
                IPrimitiveType modeValue = (IPrimitiveType)modeChild.getChildByName("mode").newInstance();
                modeValue.setValueAsString(this.mySearchMode);
                modeChild.getMutator().setValue((IBase)search, modeValue);
            }
            if (this.mySearchScore != null && (scoreChild = searchDef.getChildByName("score")) != null) {
                IPrimitiveType scoreValue = (IPrimitiveType)scoreChild.getChildByName("score").newInstance();
                scoreValue.setValueAsString(this.mySearchScore);
                scoreChild.getMutator().setValue((IBase)search, scoreValue);
            }
        }
        return (T)entry;
    }
}

