/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.serializer;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.parser.IParser;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import java.io.IOException;
import org.hl7.fhir.instance.model.api.IBaseResource;

public class FhirResourceDeserializer
extends StdDeserializer<IBaseResource> {
    private final IParser myParser;

    public FhirResourceDeserializer(FhirContext theFhirContext) {
        super(IBaseResource.class);
        this.myParser = theFhirContext.newJsonParser().setPrettyPrint(true);
    }

    public IBaseResource deserialize(JsonParser theJsonParser, DeserializationContext theContext) throws IOException {
        String json = theJsonParser.getCodec().readTree(theJsonParser).toString();
        return this.myParser.parseResource(json);
    }
}

