/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.client.api;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.rest.client.api.IHttpRequest;
import ca.uhn.fhir.rest.client.api.IHttpResponse;
import ca.uhn.fhir.rest.client.api.IRestfulClient;
import java.util.Objects;
import java.util.StringJoiner;
import org.hl7.fhir.instance.model.api.IBaseResource;

public class ClientResponseContext {
    private final IHttpRequest myHttpRequest;
    private IHttpResponse myHttpResponse;
    private final IRestfulClient myRestfulClient;
    private final FhirContext myFhirContext;
    private final Class<? extends IBaseResource> myReturnType;

    public ClientResponseContext(IHttpRequest myHttpRequest, IHttpResponse theHttpResponse, IRestfulClient myRestfulClient, FhirContext theFhirContext, Class<? extends IBaseResource> theReturnType) {
        this.myHttpRequest = myHttpRequest;
        this.myHttpResponse = theHttpResponse;
        this.myRestfulClient = myRestfulClient;
        this.myFhirContext = theFhirContext;
        this.myReturnType = theReturnType;
    }

    public IHttpRequest getHttpRequest() {
        return this.myHttpRequest;
    }

    public IHttpResponse getHttpResponse() {
        return this.myHttpResponse;
    }

    public IRestfulClient getRestfulClient() {
        return this.myRestfulClient;
    }

    public FhirContext getFhirContext() {
        return this.myFhirContext;
    }

    public Class<? extends IBaseResource> getReturnType() {
        return this.myReturnType;
    }

    public void setHttpResponse(IHttpResponse theHttpResponse) {
        this.myHttpResponse = theHttpResponse;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClientResponseContext that = (ClientResponseContext)o;
        return Objects.equals(this.myHttpRequest, that.myHttpRequest) && Objects.equals(this.myHttpResponse, that.myHttpResponse) && Objects.equals(this.myRestfulClient, that.myRestfulClient) && Objects.equals(this.myFhirContext, that.myFhirContext) && Objects.equals(this.myReturnType, that.myReturnType);
    }

    public int hashCode() {
        return Objects.hash(this.myHttpRequest, this.myHttpResponse, this.myRestfulClient, this.myFhirContext, this.myReturnType);
    }

    public String toString() {
        return new StringJoiner(", ", ClientResponseContext.class.getSimpleName() + "[", "]").add("myHttpRequest=" + String.valueOf(this.myHttpRequest)).add("myHttpResponse=" + String.valueOf(this.myHttpResponse)).add("myRestfulClient=" + String.valueOf(this.myRestfulClient)).add("myFhirContext=" + String.valueOf(this.myFhirContext)).add("myReturnType=" + String.valueOf(this.myReturnType)).toString();
    }
}

