/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.repository.impl;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.repository.IRepository;
import ca.uhn.fhir.repository.IRepositoryLoader;
import ca.uhn.fhir.util.Logs;
import com.google.common.annotations.Beta;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Objects;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;

@Beta
public class UrlRepositoryFactory {
    private static final Logger ourLog = Logs.getRepositoryTroubleshootingLog();
    public static final String FHIR_REPOSITORY_URL_SCHEME = "fhir-repository:";
    static final Pattern ourUrlPattern = Pattern.compile("^fhir-repository:([A-Za-z-]+):(.*)");

    public static boolean isRepositoryUrl(String theBaseUrl) {
        return theBaseUrl != null && theBaseUrl.startsWith(FHIR_REPOSITORY_URL_SCHEME) && ourUrlPattern.matcher(theBaseUrl).matches();
    }

    @Nonnull
    public static IRepository buildRepository(@Nullable FhirContext theFhirContext, @Nonnull String theRepositoryUrl) {
        ourLog.debug("Loading repository for url: {}", (Object)theRepositoryUrl);
        Objects.requireNonNull(theRepositoryUrl);
        if (!UrlRepositoryFactory.isRepositoryUrl(theRepositoryUrl)) {
            throw new IllegalArgumentException(Msg.code(2737) + "Base URL is not a valid repository URL: " + theRepositoryUrl);
        }
        ServiceLoader<IRepositoryLoader> load = ServiceLoader.load(IRepositoryLoader.class);
        IRepositoryLoader.IRepositoryRequest request = UrlRepositoryFactory.buildRequest(theRepositoryUrl, theFhirContext);
        for (IRepositoryLoader nextLoader : load) {
            UrlRepositoryFactory.logLoaderDetails(nextLoader);
            if (!nextLoader.canLoad(request)) continue;
            ourLog.debug("Loader {} can handle URL: {}.  Instantiating repository.", (Object)nextLoader.getClass().getName(), (Object)theRepositoryUrl);
            return nextLoader.loadRepository(request);
        }
        throw new IllegalArgumentException(Msg.code(2738) + "Unable to find a repository loader for URL: " + theRepositoryUrl);
    }

    private static void logLoaderDetails(IRepositoryLoader nextLoader) {
        Class<?> clazz = nextLoader.getClass();
        ourLog.debug("Checking repository loader {} from {}", (Object)clazz.getName(), (Object)clazz.getProtectionDomain().getCodeSource().getLocation());
    }

    @Nonnull
    public static IRepositoryLoader.IRepositoryRequest buildRequest(@Nonnull String theBaseUrl, @Nullable FhirContext theFhirContext) {
        Matcher matcher = ourUrlPattern.matcher(theBaseUrl);
        String subScheme = null;
        String details = null;
        boolean found = matcher.matches();
        if (found) {
            subScheme = matcher.group(1);
            details = matcher.group(2);
        }
        return new RepositoryRequest(theBaseUrl, subScheme, details, theFhirContext);
    }

    record RepositoryRequest(String url, String subScheme, String details, FhirContext fhirContext) implements IRepositoryLoader.IRepositoryRequest
    {
        @Override
        public String getUrl() {
            return this.url;
        }

        @Override
        public String getSubScheme() {
            return this.subScheme;
        }

        @Override
        public String getDetails() {
            return this.details;
        }

        @Override
        public Optional<FhirContext> getFhirContext() {
            return Optional.ofNullable(this.fhirContext);
        }
    }
}

