/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.context.support;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.context.support.DefaultProfileValidationSupportBundleStrategy;
import ca.uhn.fhir.context.support.IValidationSupport;
import ca.uhn.fhir.util.ILockable;
import ca.uhn.fhir.util.ReflectionUtil;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.Validate;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IPrimitiveType;

public class DefaultProfileValidationSupport
implements IValidationSupport {
    private static final Map<FhirVersionEnum, IValidationSupport> ourImplementations = Collections.synchronizedMap(new HashMap());
    public static final String SOURCE_PACKAGE_ID = DefaultProfileValidationSupport.class.getName() + "_SOURCE_PACKAGE_ID";
    private final FhirContext myCtx;
    private final IValidationSupport myDelegate;
    private final Runnable myFlush;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DefaultProfileValidationSupport(@Nonnull FhirContext theFhirContext) {
        IValidationSupport strategy;
        Validate.notNull((Object)theFhirContext, (String)"FhirContext must not be null", (Object[])new Object[0]);
        this.myCtx = theFhirContext;
        Map<FhirVersionEnum, IValidationSupport> map = ourImplementations;
        synchronized (map) {
            strategy = ourImplementations.get((Object)theFhirContext.getVersion().getVersion());
            if (strategy == null) {
                if (theFhirContext.getVersion().getVersion().isEqualOrNewerThan(FhirVersionEnum.R5)) {
                    strategy = ReflectionUtil.newInstance("org.hl7.fhir.common.hapi.validation.support.DefaultProfileValidationSupportNpmStrategy", IValidationSupport.class, new Class[]{FhirContext.class}, new Object[]{theFhirContext});
                    ((ILockable)((Object)strategy)).lock();
                } else {
                    strategy = new DefaultProfileValidationSupportBundleStrategy(theFhirContext);
                }
                ourImplementations.put(theFhirContext.getVersion().getVersion(), strategy);
            }
        }
        this.myDelegate = strategy;
        this.myFlush = this.myDelegate instanceof DefaultProfileValidationSupportBundleStrategy ? () -> ((DefaultProfileValidationSupportBundleStrategy)this.myDelegate).flush() : () -> {};
    }

    @Override
    public String getName() {
        return String.valueOf((Object)this.myCtx.getVersion().getVersion()) + " FHIR Standard Profile Validation Support";
    }

    @Override
    public List<IBaseResource> fetchAllConformanceResources() {
        List<IBaseResource> retVal = this.myDelegate.fetchAllConformanceResources();
        this.addPackageInformation(retVal);
        return retVal;
    }

    @Override
    public <T extends IBaseResource> List<T> fetchAllStructureDefinitions() {
        List retVal = this.myDelegate.fetchAllStructureDefinitions();
        this.addPackageInformation(retVal);
        return retVal;
    }

    @Override
    @Nullable
    public <T extends IBaseResource> List<T> fetchAllNonBaseStructureDefinitions() {
        List retVal = this.myDelegate.fetchAllNonBaseStructureDefinitions();
        this.addPackageInformation(retVal);
        return retVal;
    }

    @Override
    public IBaseResource fetchCodeSystem(String theSystem) {
        IBaseResource retVal = this.myDelegate.fetchCodeSystem(theSystem);
        this.addPackageInformation(retVal);
        return retVal;
    }

    @Override
    public IBaseResource fetchStructureDefinition(String theUrl) {
        IBaseResource retVal = this.myDelegate.fetchStructureDefinition(theUrl);
        this.addPackageInformation(retVal);
        return retVal;
    }

    @Override
    public IBaseResource fetchValueSet(String theUrl) {
        IBaseResource retVal = this.myDelegate.fetchValueSet(theUrl);
        this.addPackageInformation(retVal);
        return retVal;
    }

    @Override
    @Nullable
    public <T extends IBaseResource> List<T> fetchAllSearchParameters() {
        List retVal = this.myDelegate.fetchAllSearchParameters();
        this.addPackageInformation(retVal);
        return retVal;
    }

    public void flush() {
        this.myFlush.run();
    }

    @Override
    public FhirContext getFhirContext() {
        return this.myCtx;
    }

    @Nullable
    public static String getConformanceResourceUrl(FhirContext theFhirContext, IBaseResource theResource) {
        String urlValueString = null;
        Optional urlValue = theFhirContext.getResourceDefinition(theResource).getChildByName("url").getAccessor().getFirstValueOrNull(theResource);
        if (urlValue.isPresent()) {
            IPrimitiveType urlValueType = (IPrimitiveType)urlValue.get();
            urlValueString = urlValueType.getValueAsString();
        }
        return urlValueString;
    }

    private <T extends IBaseResource> void addPackageInformation(List<T> theResources) {
        if (theResources != null) {
            theResources.forEach(this::addPackageInformation);
        }
    }

    private void addPackageInformation(IBaseResource theResource) {
        if (theResource != null) {
            String sourcePackageId = null;
            switch (this.myCtx.getVersion().getVersion()) {
                case DSTU2: 
                case DSTU2_HL7ORG: {
                    sourcePackageId = "hl7.fhir.r2.core";
                    break;
                }
                case DSTU2_1: {
                    return;
                }
                case DSTU3: {
                    sourcePackageId = "hl7.fhir.r3.core";
                    break;
                }
                case R4: {
                    sourcePackageId = "hl7.fhir.r4.core";
                    break;
                }
                case R4B: {
                    sourcePackageId = "hl7.fhir.r4b.core";
                    break;
                }
                case R5: {
                    sourcePackageId = "hl7.fhir.r5.core";
                }
            }
            Validate.notNull((Object)sourcePackageId, (String)"Don't know how to handle package ID: %s", (Object[])new Object[]{this.myCtx.getVersion().getVersion()});
            theResource.setUserData(SOURCE_PACKAGE_ID, sourcePackageId);
        }
    }
}

