/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.context.api;

import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.util.ResourceReferenceInfo;
import java.util.Set;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum BundleInclusionRule {
    BASED_ON_INCLUDES{

        @Override
        public boolean shouldIncludeReferencedResource(ResourceReferenceInfo theReferenceInfo, Set<Include> theIncludes) {
            return theReferenceInfo.matchesIncludeSet(theIncludes);
        }
    }
    ,
    BASED_ON_RESOURCE_PRESENCE{

        @Override
        public boolean shouldIncludeReferencedResource(ResourceReferenceInfo theReferenceInfo, Set<Include> theIncludes) {
            return true;
        }
    };


    public abstract boolean shouldIncludeReferencedResource(ResourceReferenceInfo var1, Set<Include> var2);
}

