/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.util;

import ca.uhn.fhir.context.BaseRuntimeChildDefinition;
import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.RuntimeResourceDefinition;
import ca.uhn.fhir.rest.api.EncodingEnum;
import ca.uhn.fhir.util.BundleUtil;
import jakarta.annotation.Nonnull;
import java.io.IOException;
import org.hl7.fhir.instance.model.api.IBaseBundle;
import org.hl7.fhir.instance.model.api.IBaseResource;

public class ResourceUtil {
    private static final String ENCODING = "ENCODING_TYPE";
    private static final String RAW_ = "RAW_";

    private ResourceUtil() {
    }

    public static void removeNarrative(FhirContext theContext, IBaseResource theInput) {
        RuntimeResourceDefinition element;
        BaseRuntimeChildDefinition textElement;
        if (theInput instanceof IBaseBundle) {
            for (IBaseResource next : BundleUtil.toListOfResources(theContext, (IBaseBundle)theInput)) {
                ResourceUtil.removeNarrative(theContext, next);
            }
        }
        if ((textElement = (element = theContext.getResourceDefinition(theInput.getClass())).getChildByName("text")) != null) {
            textElement.getMutator().setValue(theInput, null);
        }
    }

    public static void addRawDataToResource(@Nonnull IBaseResource theResource, @Nonnull EncodingEnum theEncodingType, String theSerializedData) throws IOException {
        theResource.setUserData(ResourceUtil.getRawUserDataKey(theEncodingType), theSerializedData);
        theResource.setUserData(ENCODING, (Object)theEncodingType);
    }

    public static EncodingEnum getEncodingTypeFromUserData(@Nonnull IBaseResource theResource) {
        return (EncodingEnum)((Object)theResource.getUserData(ENCODING));
    }

    public static String getRawStringFromResourceOrNull(@Nonnull IBaseResource theResource) {
        EncodingEnum type = (EncodingEnum)((Object)theResource.getUserData(ENCODING));
        if (type != null) {
            return (String)theResource.getUserData(ResourceUtil.getRawUserDataKey(type));
        }
        return null;
    }

    private static String getRawUserDataKey(EncodingEnum theEncodingEnum) {
        return RAW_ + theEncodingEnum.name();
    }
}

