/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.system;

import java.util.concurrent.TimeUnit;

public final class HapiSystemProperties {
    static final String SUPPRESS_HAPI_FHIR_VERSION_LOG = "suppress_hapi_fhir_version_log";
    static final String DISABLE_STATUS_BASED_REINDEX = "disable_status_based_reindex";
    static final String VALIDATION_RESOURCE_CACHE_TIMEOUT_MILLIS = "VALIDATION_RESOURCE_CACHE_EXPIRY_MS";
    static final String UNIT_TEST_CAPTURE_STACK = "unit_test_capture_stack";
    static final String STACKFILTER_PATTERN_PROP = "log.stackfilter.pattern";
    static final String HAPI_CLIENT_KEEPRESPONSES = "hapi.client.keepresponses";
    static final String TEST_MODE = "test";
    static final String UNIT_TEST_MODE = "unit_test_mode";
    static final long DEFAULT_VALIDATION_RESOURCE_CACHE_TIMEOUT_MILLIS = TimeUnit.MINUTES.toMillis(10L);
    static final String PREVENT_INVALIDATING_CONDITIONAL_MATCH_CRITERIA = "hapi.storage.prevent_invalidating_conditional_match_criteria";
    static final String DISABLE_DATABASE_PARTITION_MODE_SCHEMA_CHECK = "hapi.storage.disable_database_partition_mode_schema_check";

    private HapiSystemProperties() {
    }

    public static void enableHapiClientKeepResponses() {
        System.setProperty(HAPI_CLIENT_KEEPRESPONSES, Boolean.TRUE.toString());
    }

    public static void disableHapiClientKeepResponses() {
        System.clearProperty(HAPI_CLIENT_KEEPRESPONSES);
    }

    public static boolean isHapiClientKeepResponsesEnabled() {
        return Boolean.parseBoolean(System.getProperty(HAPI_CLIENT_KEEPRESPONSES));
    }

    public static void setStackFilterPattern(String thePattern) {
        System.setProperty(STACKFILTER_PATTERN_PROP, thePattern);
    }

    public static void setValidationResourceCacheTimeoutMillis(long theMillis) {
        System.setProperty(VALIDATION_RESOURCE_CACHE_TIMEOUT_MILLIS, "" + theMillis);
    }

    public static long getValidationResourceCacheTimeoutMillis() {
        String property = System.getProperty(VALIDATION_RESOURCE_CACHE_TIMEOUT_MILLIS);
        if (property == null) {
            return DEFAULT_VALIDATION_RESOURCE_CACHE_TIMEOUT_MILLIS;
        }
        return Long.parseLong(property);
    }

    public static void enableTestMode() {
        System.setProperty(TEST_MODE, Boolean.TRUE.toString());
    }

    public static boolean isTestModeEnabled() {
        return Boolean.parseBoolean(System.getProperty(TEST_MODE));
    }

    public static void enableUnitTestMode() {
        System.setProperty(UNIT_TEST_MODE, Boolean.TRUE.toString());
    }

    public static void disableUnitTestMode() {
        System.setProperty(UNIT_TEST_MODE, Boolean.FALSE.toString());
    }

    public static boolean isUnitTestModeEnabled() {
        return Boolean.parseBoolean(System.getProperty(UNIT_TEST_MODE));
    }

    public static void enableUnitTestCaptureStack() {
        System.setProperty(UNIT_TEST_CAPTURE_STACK, Boolean.TRUE.toString());
    }

    public static void disableUnitTestCaptureStack() {
        System.clearProperty(UNIT_TEST_CAPTURE_STACK);
    }

    public static boolean isUnitTestCaptureStackEnabled() {
        return Boolean.parseBoolean(System.getProperty(UNIT_TEST_CAPTURE_STACK));
    }

    public static boolean isDisableStatusBasedReindex() {
        return Boolean.parseBoolean(System.getProperty(DISABLE_STATUS_BASED_REINDEX));
    }

    public static void disableStatusBasedReindex() {
        System.setProperty(DISABLE_STATUS_BASED_REINDEX, Boolean.TRUE.toString());
    }

    public static void enableStatusBasedReindex() {
        System.clearProperty(DISABLE_STATUS_BASED_REINDEX);
    }

    public static void enableSuppressHapiFhirVersionLog() {
        System.setProperty(SUPPRESS_HAPI_FHIR_VERSION_LOG, Boolean.TRUE.toString());
    }

    public static boolean isSuppressHapiFhirVersionLogEnabled() {
        return Boolean.parseBoolean(System.getProperty(SUPPRESS_HAPI_FHIR_VERSION_LOG));
    }

    public static boolean isPreventInvalidatingConditionalMatchCriteria() {
        return Boolean.parseBoolean(System.getProperty(PREVENT_INVALIDATING_CONDITIONAL_MATCH_CRITERIA, Boolean.FALSE.toString()));
    }

    public static boolean isDisableDatabasePartitionModeSchemaCheck() {
        return Boolean.parseBoolean(System.getProperty(DISABLE_DATABASE_PARTITION_MODE_SCHEMA_CHECK, Boolean.FALSE.toString()));
    }
}

