/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.interceptor.executor;

import ca.uhn.fhir.interceptor.api.IBaseInterceptorBroadcaster;
import java.util.function.Supplier;

public class SupplierFilterHookWrapper<T>
implements Supplier<T> {
    private final IBaseInterceptorBroadcaster.IInterceptorFilterHook myAdvice;
    private final Supplier<T> myTarget;
    private final Supplier<String> myMessageSupplier;

    public SupplierFilterHookWrapper(Supplier<T> theTarget, IBaseInterceptorBroadcaster.IInterceptorFilterHook theAdvice, Supplier<String> theCauseDescriptionSupplier) {
        this.myAdvice = theAdvice;
        this.myTarget = theTarget;
        this.myMessageSupplier = theCauseDescriptionSupplier;
    }

    @Override
    public T get() {
        SupplierRunnable<T> trackingSupplierWrapper = new SupplierRunnable<T>(this.myTarget);
        this.myAdvice.wrapCall(trackingSupplierWrapper);
        if (!trackingSupplierWrapper.wasExecuted()) {
            throw new IllegalStateException("Supplier was not executed in filter produced by " + this.myMessageSupplier.get());
        }
        return trackingSupplierWrapper.getResult();
    }

    static class SupplierRunnable<T>
    implements Runnable {
        private final Supplier<T> myTarget;
        private boolean myExecutedFlag = false;
        private T myResult = null;

        SupplierRunnable(Supplier<T> theTarget) {
            this.myTarget = theTarget;
        }

        @Override
        public void run() {
            this.myExecutedFlag = true;
            this.myResult = this.myTarget.get();
        }

        public boolean wasExecuted() {
            return this.myExecutedFlag;
        }

        public T getResult() {
            return this.myResult;
        }
    }
}

