/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.tls;

import ca.uhn.fhir.i18n.Msg;
import java.util.Arrays;
import java.util.List;

public enum KeyStoreType {
    PKCS12("p12", "pfx"),
    JKS("jks");

    private List<String> myFileExtensions;

    private KeyStoreType(String ... theFileExtensions) {
        this.myFileExtensions = Arrays.asList(theFileExtensions);
    }

    public List<String> getFileExtensions() {
        return this.myFileExtensions;
    }

    public static KeyStoreType fromFileExtension(String theFileExtension) {
        for (KeyStoreType type : KeyStoreType.values()) {
            if (!type.getFileExtensions().contains(theFileExtension.toLowerCase())) continue;
            return type;
        }
        throw new IllegalArgumentException(Msg.code(2121) + "Invalid KeyStore Type");
    }
}

