/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.model.valueset;

import ca.uhn.fhir.model.api.IValueSetEnumBinder;
import ca.uhn.fhir.util.CoverageIgnore;
import java.util.HashMap;
import java.util.Map;

@CoverageIgnore
public enum BundleEntrySearchModeEnum {
    MATCH("match", "http://hl7.org/fhir/search-entry-mode"),
    INCLUDE("include", "http://hl7.org/fhir/search-entry-mode"),
    OUTCOME("outcome", "http://hl7.org/fhir/search-entry-mode");

    public static final String VALUESET_IDENTIFIER = "http://hl7.org/fhir/bundle-entry-status";
    public static final String VALUESET_NAME = "BundleEntryStatus";
    private static Map<String, BundleEntrySearchModeEnum> CODE_TO_ENUM;
    private static Map<String, Map<String, BundleEntrySearchModeEnum>> SYSTEM_TO_CODE_TO_ENUM;
    private final String myCode;
    private final String mySystem;
    public static final IValueSetEnumBinder<BundleEntrySearchModeEnum> VALUESET_BINDER;

    public String getCode() {
        return this.myCode;
    }

    public String getSystem() {
        return this.mySystem;
    }

    public static BundleEntrySearchModeEnum forCode(String theCode) {
        BundleEntrySearchModeEnum retVal = CODE_TO_ENUM.get(theCode);
        return retVal;
    }

    private BundleEntrySearchModeEnum(String theCode, String theSystem) {
        this.myCode = theCode;
        this.mySystem = theSystem;
    }

    static {
        CODE_TO_ENUM = new HashMap<String, BundleEntrySearchModeEnum>();
        SYSTEM_TO_CODE_TO_ENUM = new HashMap<String, Map<String, BundleEntrySearchModeEnum>>();
        for (BundleEntrySearchModeEnum next : BundleEntrySearchModeEnum.values()) {
            CODE_TO_ENUM.put(next.getCode(), next);
            if (!SYSTEM_TO_CODE_TO_ENUM.containsKey(next.getSystem())) {
                SYSTEM_TO_CODE_TO_ENUM.put(next.getSystem(), new HashMap());
            }
            SYSTEM_TO_CODE_TO_ENUM.get(next.getSystem()).put(next.getCode(), next);
        }
        VALUESET_BINDER = new IValueSetEnumBinder<BundleEntrySearchModeEnum>(){
            private static final long serialVersionUID = -3836039426814809083L;

            @Override
            public String toCodeString(BundleEntrySearchModeEnum theEnum) {
                return theEnum.getCode();
            }

            @Override
            public String toSystemString(BundleEntrySearchModeEnum theEnum) {
                return theEnum.getSystem();
            }

            @Override
            public BundleEntrySearchModeEnum fromCodeString(String theCodeString) {
                return CODE_TO_ENUM.get(theCodeString);
            }

            @Override
            public BundleEntrySearchModeEnum fromCodeString(String theCodeString, String theSystemString) {
                Map<String, BundleEntrySearchModeEnum> map = SYSTEM_TO_CODE_TO_ENUM.get(theSystemString);
                if (map == null) {
                    return null;
                }
                return map.get(theCodeString);
            }
        };
    }
}

