/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.util.adapters;

import ca.uhn.fhir.util.adapters.IAdapterFactory;
import ca.uhn.fhir.util.adapters.IAdapterManager;
import jakarta.annotation.Nonnull;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;

public class AdapterManager
implements IAdapterManager {
    public static final AdapterManager INSTANCE = new AdapterManager();
    Set<IAdapterFactory> myAdapterFactories = new HashSet<IAdapterFactory>();

    AdapterManager() {
    }

    @Override
    @Nonnull
    public <T> Optional<T> getAdapter(Object theObject, Class<T> theTargetType) {
        return this.myAdapterFactories.stream().filter(nextFactory -> nextFactory.getAdapters().stream().anyMatch(theTargetType::isAssignableFrom)).flatMap(nextFactory -> {
            Optional adapter = nextFactory.getAdapter(theObject, theTargetType);
            if (adapter.isPresent()) {
                return Stream.of(adapter.get());
            }
            return Stream.empty();
        }).findFirst();
    }

    public void registerFactory(@Nonnull IAdapterFactory theFactory) {
        this.myAdapterFactories.add(theFactory);
    }

    public void unregisterFactory(@Nonnull IAdapterFactory theFactory) {
        this.myAdapterFactories.remove(theFactory);
    }
}

