/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.api;

import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.rest.server.exceptions.InvalidRequestException;
import ca.uhn.fhir.util.UrlUtil;
import java.util.HashMap;
import java.util.Map;

public enum SearchContainedModeEnum {
    FALSE("false"),
    TRUE("true"),
    BOTH("both");

    private static volatile Map<String, SearchContainedModeEnum> ourCodeToEnum;
    private final String myCode;

    private SearchContainedModeEnum(String theCode) {
        this.myCode = theCode;
    }

    public String getCode() {
        return this.myCode;
    }

    public static SearchContainedModeEnum fromCode(String theCode) {
        SearchContainedModeEnum retVal;
        Map<String, SearchContainedModeEnum> codeToEnum = ourCodeToEnum;
        if (codeToEnum == null) {
            codeToEnum = new HashMap<String, SearchContainedModeEnum>();
            for (SearchContainedModeEnum next : SearchContainedModeEnum.values()) {
                codeToEnum.put(next.getCode(), next);
            }
            ourCodeToEnum = codeToEnum;
        }
        if ((retVal = codeToEnum.get(theCode)) == null) {
            throw new InvalidRequestException(Msg.code(1963) + "Invalid contained mode: " + UrlUtil.sanitizeUrlPart(theCode));
        }
        return retVal;
    }
}

