/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.narrative;

import ca.uhn.fhir.narrative.BaseThymeleafNarrativeGenerator;
import ca.uhn.fhir.narrative2.NarrativeTemplateManifest;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.Validate;

public class CustomThymeleafNarrativeGenerator
extends BaseThymeleafNarrativeGenerator {
    private volatile List<String> myPropertyFile;
    private volatile NarrativeTemplateManifest myManifest;

    public CustomThymeleafNarrativeGenerator() {
    }

    public CustomThymeleafNarrativeGenerator(String ... theNarrativePropertyFiles) {
        this();
        this.setPropertyFile(theNarrativePropertyFiles);
    }

    public CustomThymeleafNarrativeGenerator(List<String> theNarrativePropertyFiles) {
        this(theNarrativePropertyFiles.toArray(new String[0]));
    }

    @Override
    public NarrativeTemplateManifest getManifest() {
        NarrativeTemplateManifest retVal = this.myManifest;
        if (this.myManifest == null) {
            Validate.isTrue((this.myPropertyFile != null ? 1 : 0) != 0, (String)"Neither a property file or a manifest has been provided", (Object[])new Object[0]);
            retVal = NarrativeTemplateManifest.forManifestFileLocation(this.myPropertyFile);
            this.setManifest(retVal);
        }
        return retVal;
    }

    public void setManifest(NarrativeTemplateManifest theManifest) {
        this.myManifest = theManifest;
    }

    public void setPropertyFile(String ... thePropertyFile) {
        Validate.notNull((Object)thePropertyFile, (String)"Property file can not be null", (Object[])new Object[0]);
        this.myPropertyFile = Arrays.asList(thePropertyFile);
        this.myManifest = null;
    }
}

