/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.validation.schematron;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.rest.api.EncodingEnum;
import ca.uhn.fhir.rest.server.exceptions.InternalErrorException;
import ca.uhn.fhir.util.BundleUtil;
import ca.uhn.fhir.validation.FhirValidator;
import ca.uhn.fhir.validation.IValidationContext;
import ca.uhn.fhir.validation.IValidatorModule;
import ca.uhn.fhir.validation.ResultSeverityEnum;
import ca.uhn.fhir.validation.SingleValidationMessage;
import ca.uhn.fhir.validation.ValidationContext;
import com.helger.commons.error.IError;
import com.helger.commons.error.list.IErrorList;
import com.helger.commons.io.resource.ClassPathResource;
import com.helger.commons.io.resource.IReadableResource;
import com.helger.schematron.ISchematronResource;
import com.helger.schematron.SchematronHelper;
import com.helger.schematron.sch.SchematronResourceSCH;
import com.helger.schematron.svrl.jaxb.SchematronOutputType;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.hl7.fhir.instance.model.api.IBaseBundle;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchematronBaseValidator
implements IValidatorModule {
    private static final Logger ourLog = LoggerFactory.getLogger(SchematronBaseValidator.class);
    private final Map<Class<? extends IBaseResource>, ISchematronResource> myClassToSchematron = new HashMap<Class<? extends IBaseResource>, ISchematronResource>();
    private FhirContext myCtx;

    public SchematronBaseValidator(FhirContext theContext) {
        this.myCtx = theContext;
    }

    @Override
    public void validateResource(IValidationContext<IBaseResource> theCtx) {
        SchematronOutputType results;
        if (theCtx.getResource() instanceof IBaseBundle) {
            IBaseBundle bundle = (IBaseBundle)theCtx.getResource();
            List<IBaseResource> subResources = BundleUtil.toListOfResources(this.myCtx, bundle);
            for (IBaseResource nextSubResource : subResources) {
                this.validateResource(ValidationContext.subContext(theCtx, nextSubResource, theCtx.getOptions()));
            }
        }
        ISchematronResource sch = this.getSchematron(theCtx);
        String resourceAsString = theCtx.getResourceAsStringEncoding() == EncodingEnum.XML ? theCtx.getResourceAsString() : theCtx.getFhirContext().newXmlParser().encodeResourceToString(theCtx.getResource());
        StreamSource source = new StreamSource(new StringReader(resourceAsString));
        try {
            results = sch.applySchematronValidationToSVRL((Source)source);
        }
        catch (Exception e) {
            throw new InternalErrorException(Msg.code(2433) + e.getMessage(), (Throwable)e);
        }
        if (results == null) {
            return;
        }
        IErrorList errors = SchematronHelper.convertToErrorList((SchematronOutputType)results, (String)theCtx.getFhirContext().getResourceDefinition(theCtx.getResource()).getBaseDefinition().getName());
        if (errors.getAllErrors().containsOnlySuccess()) {
            return;
        }
        for (IError next : errors) {
            ResultSeverityEnum severity;
            if (next.isFailure()) {
                severity = ResultSeverityEnum.ERROR;
            } else if (next.isError()) {
                severity = ResultSeverityEnum.FATAL;
            } else {
                if (!next.isNoError()) continue;
                severity = ResultSeverityEnum.WARNING;
            }
            String details = next.getAsString(Locale.getDefault());
            SingleValidationMessage message = new SingleValidationMessage();
            message.setMessage(details);
            message.setLocationLine(next.getErrorLocation().getLineNumber());
            message.setLocationCol(next.getErrorLocation().getColumnNumber());
            message.setLocationString(next.getErrorLocation().getAsString());
            message.setSeverity(severity);
            theCtx.addValidationMessage(message);
        }
    }

    private ISchematronResource getSchematron(IValidationContext<IBaseResource> theCtx) {
        Class<?> resource = theCtx.getResource().getClass();
        Class baseResourceClass = theCtx.getFhirContext().getResourceDefinition(resource).getBaseDefinition().getImplementingClass();
        return this.getSchematronAndCache(theCtx, baseResourceClass);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ISchematronResource getSchematronAndCache(IValidationContext<IBaseResource> theCtx, Class<? extends IBaseResource> theClass) {
        Map<Class<? extends IBaseResource>, ISchematronResource> map = this.myClassToSchematron;
        synchronized (map) {
            ISchematronResource retVal = this.myClassToSchematron.get(theClass);
            if (retVal != null) {
                return retVal;
            }
            String pathToBase = this.myCtx.getVersion().getPathToSchemaDefinitions() + "/" + theCtx.getFhirContext().getResourceDefinition(theCtx.getResource()).getBaseDefinition().getName().toLowerCase() + ".sch";
            try (InputStream baseIs = FhirValidator.class.getResourceAsStream(pathToBase);){
                if (baseIs == null) {
                    throw new InternalErrorException(Msg.code(1972) + "Failed to load schematron for resource '" + theCtx.getFhirContext().getResourceDefinition(theCtx.getResource()).getBaseDefinition().getName() + "'. Note that as of HAPI FHIR 1.2, DSTU2 validation files are kept in a separate JAR (hapi-fhir-validation-resources-XXX.jar) which must be added to your classpath. See the HAPI FHIR download page for more information.");
                }
            }
            catch (IOException e) {
                ourLog.error("Failed to close stream", (Throwable)e);
            }
            ClassPathResource schResource = new ClassPathResource(pathToBase, this.getClass().getClassLoader());
            retVal = new SchematronResourceSCH((IReadableResource)schResource);
            this.myClassToSchematron.put(theClass, retVal);
            return retVal;
        }
    }
}

