/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.context.support;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.support.ConceptValidationOptions;
import ca.uhn.fhir.context.support.LookupCodeRequest;
import ca.uhn.fhir.context.support.TranslateConceptResults;
import ca.uhn.fhir.context.support.ValidationSupportContext;
import ca.uhn.fhir.context.support.ValueSetExpansionOptions;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.rest.server.exceptions.ResourceNotFoundException;
import ca.uhn.fhir.util.ParametersUtil;
import ca.uhn.fhir.util.UrlUtil;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IBaseCoding;
import org.hl7.fhir.instance.model.api.IBaseParameters;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;
import org.hl7.fhir.instance.model.api.IPrimitiveType;

public interface IValidationSupport {
    public static final String URL_PREFIX_VALUE_SET = "http://hl7.org/fhir/ValueSet/";
    public static final String TYPE_STRING = "string";
    public static final String TYPE_CODING = "Coding";

    @Nullable
    default public ValueSetExpansionOutcome expandValueSet(ValidationSupportContext theValidationSupportContext, @Nullable ValueSetExpansionOptions theExpansionOptions, @Nonnull IBaseResource theValueSetToExpand) {
        return null;
    }

    @Nullable
    default public ValueSetExpansionOutcome expandValueSet(ValidationSupportContext theValidationSupportContext, @Nullable ValueSetExpansionOptions theExpansionOptions, @Nonnull String theValueSetUrlToExpand) throws ResourceNotFoundException {
        Validate.notBlank((CharSequence)theValueSetUrlToExpand, (String)"theValueSetUrlToExpand must not be null or blank", (Object[])new Object[0]);
        IBaseResource valueSet = this.fetchValueSet(theValueSetUrlToExpand);
        if (valueSet == null) {
            throw new ResourceNotFoundException(Msg.code(2024) + "Unknown ValueSet: " + UrlUtil.escapeUrlParam(theValueSetUrlToExpand));
        }
        return this.expandValueSet(theValidationSupportContext, theExpansionOptions, valueSet);
    }

    @Nullable
    default public List<IBaseResource> fetchAllConformanceResources() {
        return null;
    }

    @Nullable
    default public <T extends IBaseResource> List<T> fetchAllSearchParameters() {
        return null;
    }

    @Nullable
    default public <T extends IBaseResource> List<T> fetchAllStructureDefinitions() {
        return null;
    }

    @Nullable
    default public <T extends IBaseResource> List<T> fetchAllNonBaseStructureDefinitions() {
        List<T> retVal = this.fetchAllStructureDefinitions();
        if (retVal != null) {
            ArrayList<T> newList = new ArrayList<T>(retVal.size());
            for (IBaseResource next : retVal) {
                String url = StringUtils.defaultString((String)this.getFhirContext().newTerser().getSinglePrimitiveValueOrNull(next, "url"));
                if (url.startsWith("http://hl7.org/fhir/StructureDefinition/")) {
                    String lastPart = url.substring("http://hl7.org/fhir/StructureDefinition/".length());
                    if (this.getFhirContext().getResourceTypes().contains(lastPart)) continue;
                }
                newList.add(next);
            }
            retVal = newList;
        }
        return retVal;
    }

    @Nullable
    default public IBaseResource fetchCodeSystem(String theSystem) {
        return null;
    }

    @Nullable
    default public <T extends IBaseResource> T fetchResource(@Nullable Class<T> theClass, String theUri) {
        Validate.notBlank((CharSequence)theUri, (String)"theUri must not be null or blank", (Object[])new Object[0]);
        if (theClass == null) {
            Supplier[] sources = new Supplier[]{() -> this.fetchStructureDefinition(theUri), () -> this.fetchValueSet(theUri), () -> this.fetchCodeSystem(theUri)};
            return (T)((IBaseResource)Arrays.stream(sources).map(t -> (IBaseResource)t.get()).filter(t -> t != null).findFirst().orElse(null));
        }
        switch (this.getFhirContext().getResourceType(theClass)) {
            case "StructureDefinition": {
                return (T)((IBaseResource)theClass.cast(this.fetchStructureDefinition(theUri)));
            }
            case "ValueSet": {
                return (T)((IBaseResource)theClass.cast(this.fetchValueSet(theUri)));
            }
            case "CodeSystem": {
                return (T)((IBaseResource)theClass.cast(this.fetchCodeSystem(theUri)));
            }
        }
        if (theUri.startsWith(URL_PREFIX_VALUE_SET)) {
            return (T)((IBaseResource)theClass.cast(this.fetchValueSet(theUri)));
        }
        return null;
    }

    @Nullable
    default public IBaseResource fetchStructureDefinition(String theUrl) {
        return null;
    }

    default public boolean isCodeSystemSupported(ValidationSupportContext theValidationSupportContext, String theSystem) {
        return false;
    }

    default public boolean isRemoteTerminologyServiceConfigured() {
        return false;
    }

    @Nullable
    default public IBaseResource fetchValueSet(String theValueSetUrl) {
        return null;
    }

    default public byte[] fetchBinary(String binaryKey) {
        return null;
    }

    @Nullable
    default public CodeValidationResult validateCode(ValidationSupportContext theValidationSupportContext, ConceptValidationOptions theOptions, String theCodeSystem, String theCode, String theDisplay, String theValueSetUrl) {
        return null;
    }

    @Nullable
    default public CodeValidationResult validateCodeInValueSet(ValidationSupportContext theValidationSupportContext, ConceptValidationOptions theOptions, String theCodeSystem, String theCode, String theDisplay, @Nonnull IBaseResource theValueSet) {
        return null;
    }

    @Deprecated
    @Nullable
    default public LookupCodeResult lookupCode(ValidationSupportContext theValidationSupportContext, String theSystem, String theCode, String theDisplayLanguage) {
        return null;
    }

    @Deprecated
    @Nullable
    default public LookupCodeResult lookupCode(ValidationSupportContext theValidationSupportContext, String theSystem, String theCode) {
        return this.lookupCode(theValidationSupportContext, theSystem, theCode, null);
    }

    @Nullable
    default public LookupCodeResult lookupCode(ValidationSupportContext theValidationSupportContext, @Nonnull LookupCodeRequest theLookupCodeRequest) {
        return this.lookupCode(theValidationSupportContext, theLookupCodeRequest.getSystem(), theLookupCodeRequest.getCode(), theLookupCodeRequest.getDisplayLanguage());
    }

    default public boolean isValueSetSupported(ValidationSupportContext theValidationSupportContext, String theValueSetUrl) {
        return false;
    }

    @Nullable
    default public IBaseResource generateSnapshot(ValidationSupportContext theValidationSupportContext, IBaseResource theInput, String theUrl, String theWebUrl, String theProfileName) {
        return null;
    }

    public FhirContext getFhirContext();

    default public void invalidateCaches() {
    }

    @Nullable
    default public TranslateConceptResults translateConcept(TranslateCodeRequest theRequest) {
        return null;
    }

    default public String getName() {
        return "Unknown " + this.getFhirContext().getVersion().getVersion() + " Validation Support";
    }

    default public boolean isEnabledValidationForCodingsLogicalAnd() {
        return false;
    }

    public static class ValueSetExpansionOutcome {
        private final IBaseResource myValueSet;
        private final String myError;

        public ValueSetExpansionOutcome(String theError) {
            this.myValueSet = null;
            this.myError = theError;
        }

        public ValueSetExpansionOutcome(IBaseResource theValueSet) {
            this.myValueSet = theValueSet;
            this.myError = null;
        }

        public String getError() {
            return this.myError;
        }

        public IBaseResource getValueSet() {
            return this.myValueSet;
        }
    }

    public static class LookupCodeResult {
        private String myCodeDisplay;
        private boolean myCodeIsAbstract;
        private String myCodeSystemDisplayName;
        private String myCodeSystemVersion;
        private boolean myFound;
        private String mySearchedForCode;
        private String mySearchedForSystem;
        private List<BaseConceptProperty> myProperties;
        private List<ConceptDesignation> myDesignations;
        private String myErrorMessage;

        public List<BaseConceptProperty> getProperties() {
            if (this.myProperties == null) {
                this.myProperties = new ArrayList<BaseConceptProperty>();
            }
            return this.myProperties;
        }

        public void setProperties(List<BaseConceptProperty> theProperties) {
            this.myProperties = theProperties;
        }

        @Nonnull
        public List<ConceptDesignation> getDesignations() {
            if (this.myDesignations == null) {
                this.myDesignations = new ArrayList<ConceptDesignation>();
            }
            return this.myDesignations;
        }

        public String getCodeDisplay() {
            return this.myCodeDisplay;
        }

        public void setCodeDisplay(String theCodeDisplay) {
            this.myCodeDisplay = theCodeDisplay;
        }

        public String getCodeSystemDisplayName() {
            return this.myCodeSystemDisplayName;
        }

        public void setCodeSystemDisplayName(String theCodeSystemDisplayName) {
            this.myCodeSystemDisplayName = theCodeSystemDisplayName;
        }

        public String getCodeSystemVersion() {
            return this.myCodeSystemVersion;
        }

        public void setCodeSystemVersion(String theCodeSystemVersion) {
            this.myCodeSystemVersion = theCodeSystemVersion;
        }

        public String getSearchedForCode() {
            return this.mySearchedForCode;
        }

        public LookupCodeResult setSearchedForCode(String theSearchedForCode) {
            this.mySearchedForCode = theSearchedForCode;
            return this;
        }

        public String getSearchedForSystem() {
            return this.mySearchedForSystem;
        }

        public LookupCodeResult setSearchedForSystem(String theSearchedForSystem) {
            this.mySearchedForSystem = theSearchedForSystem;
            return this;
        }

        public boolean isCodeIsAbstract() {
            return this.myCodeIsAbstract;
        }

        public void setCodeIsAbstract(boolean theCodeIsAbstract) {
            this.myCodeIsAbstract = theCodeIsAbstract;
        }

        public boolean isFound() {
            return this.myFound;
        }

        public LookupCodeResult setFound(boolean theFound) {
            this.myFound = theFound;
            return this;
        }

        public void throwNotFoundIfAppropriate() {
            if (!this.isFound()) {
                throw new ResourceNotFoundException(Msg.code(1738) + "Unable to find code[" + this.getSearchedForCode() + "] in system[" + this.getSearchedForSystem() + "]");
            }
        }

        public IBaseParameters toParameters(FhirContext theContext, List<? extends IPrimitiveType<String>> thePropertyNames) {
            IBaseParameters retVal = ParametersUtil.newInstance(theContext);
            if (StringUtils.isNotBlank((CharSequence)this.getCodeSystemDisplayName())) {
                ParametersUtil.addParameterToParametersString(theContext, retVal, "name", this.getCodeSystemDisplayName());
            }
            if (StringUtils.isNotBlank((CharSequence)this.getCodeSystemVersion())) {
                ParametersUtil.addParameterToParametersString(theContext, retVal, "version", this.getCodeSystemVersion());
            }
            ParametersUtil.addParameterToParametersString(theContext, retVal, "display", this.getCodeDisplay());
            ParametersUtil.addParameterToParametersBoolean(theContext, retVal, "abstract", this.isCodeIsAbstract());
            if (this.myProperties != null) {
                Set properties = Collections.emptySet();
                if (thePropertyNames != null) {
                    properties = thePropertyNames.stream().map(IPrimitiveType::getValueAsString).collect(Collectors.toSet());
                }
                block8: for (BaseConceptProperty next : this.myProperties) {
                    String propertyType;
                    String propertyName = next.getPropertyName();
                    if (!properties.isEmpty() && !properties.contains(propertyName)) continue;
                    IBase property = ParametersUtil.addParameterToParameters(theContext, retVal, "property");
                    ParametersUtil.addPartCode(theContext, property, "code", propertyName);
                    switch (propertyType = next.getType()) {
                        case "string": {
                            StringConceptProperty stringConceptProperty = (StringConceptProperty)next;
                            ParametersUtil.addPartString(theContext, property, "value", stringConceptProperty.getValue());
                            continue block8;
                        }
                        case "Coding": {
                            CodingConceptProperty codingConceptProperty = (CodingConceptProperty)next;
                            ParametersUtil.addPartCoding(theContext, property, "value", codingConceptProperty.getCodeSystem(), codingConceptProperty.getCode(), codingConceptProperty.getDisplay());
                            continue block8;
                        }
                    }
                    throw new IllegalStateException(Msg.code(1739) + "Don't know how to handle " + next.getClass());
                }
            }
            if (this.myDesignations != null) {
                for (ConceptDesignation next : this.myDesignations) {
                    IBase property = ParametersUtil.addParameterToParameters(theContext, retVal, "designation");
                    ParametersUtil.addPartCode(theContext, property, "language", next.getLanguage());
                    ParametersUtil.addPartCoding(theContext, property, "use", next.getUseSystem(), next.getUseCode(), next.getUseDisplay());
                    ParametersUtil.addPartString(theContext, property, "value", next.getValue());
                }
            }
            return retVal;
        }

        public void setErrorMessage(String theErrorMessage) {
            this.myErrorMessage = theErrorMessage;
        }

        public String getErrorMessage() {
            return this.myErrorMessage;
        }

        public static LookupCodeResult notFound(String theSearchedForSystem, String theSearchedForCode) {
            return new LookupCodeResult().setFound(false).setSearchedForSystem(theSearchedForSystem).setSearchedForCode(theSearchedForCode);
        }
    }

    public static class TranslateCodeRequest {
        private final String myTargetSystemUrl;
        private final String myConceptMapUrl;
        private final String myConceptMapVersion;
        private final String mySourceValueSetUrl;
        private final String myTargetValueSetUrl;
        private final IIdType myResourceId;
        private final boolean myReverse;
        private List<IBaseCoding> myCodings;

        public TranslateCodeRequest(List<IBaseCoding> theCodings, String theTargetSystemUrl) {
            this.myCodings = theCodings;
            this.myTargetSystemUrl = theTargetSystemUrl;
            this.myConceptMapUrl = null;
            this.myConceptMapVersion = null;
            this.mySourceValueSetUrl = null;
            this.myTargetValueSetUrl = null;
            this.myResourceId = null;
            this.myReverse = false;
        }

        public TranslateCodeRequest(List<IBaseCoding> theCodings, String theTargetSystemUrl, String theConceptMapUrl, String theConceptMapVersion, String theSourceValueSetUrl, String theTargetValueSetUrl, IIdType theResourceId, boolean theReverse) {
            this.myCodings = theCodings;
            this.myTargetSystemUrl = theTargetSystemUrl;
            this.myConceptMapUrl = theConceptMapUrl;
            this.myConceptMapVersion = theConceptMapVersion;
            this.mySourceValueSetUrl = theSourceValueSetUrl;
            this.myTargetValueSetUrl = theTargetValueSetUrl;
            this.myResourceId = theResourceId;
            this.myReverse = theReverse;
        }

        public boolean equals(Object theO) {
            if (this == theO) {
                return true;
            }
            if (theO == null || this.getClass() != theO.getClass()) {
                return false;
            }
            TranslateCodeRequest that = (TranslateCodeRequest)theO;
            return new EqualsBuilder().append(this.myCodings, that.myCodings).append((Object)this.myTargetSystemUrl, (Object)that.myTargetSystemUrl).append((Object)this.myConceptMapUrl, (Object)that.myConceptMapUrl).append((Object)this.myConceptMapVersion, (Object)that.myConceptMapVersion).append((Object)this.mySourceValueSetUrl, (Object)that.mySourceValueSetUrl).append((Object)this.myTargetValueSetUrl, (Object)that.myTargetValueSetUrl).append((Object)this.myResourceId, (Object)that.myResourceId).append(this.myReverse, that.myReverse).isEquals();
        }

        public int hashCode() {
            return new HashCodeBuilder(17, 37).append(this.myCodings).append((Object)this.myTargetSystemUrl).append((Object)this.myConceptMapUrl).append((Object)this.myConceptMapVersion).append((Object)this.mySourceValueSetUrl).append((Object)this.myTargetValueSetUrl).append((Object)this.myResourceId).append(this.myReverse).toHashCode();
        }

        public List<IBaseCoding> getCodings() {
            return this.myCodings;
        }

        public String getTargetSystemUrl() {
            return this.myTargetSystemUrl;
        }

        public String getConceptMapUrl() {
            return this.myConceptMapUrl;
        }

        public String getConceptMapVersion() {
            return this.myConceptMapVersion;
        }

        public String getSourceValueSetUrl() {
            return this.mySourceValueSetUrl;
        }

        public String getTargetValueSetUrl() {
            return this.myTargetValueSetUrl;
        }

        public IIdType getResourceId() {
            return this.myResourceId;
        }

        public boolean isReverse() {
            return this.myReverse;
        }

        public String toString() {
            return new ToStringBuilder((Object)this).append("sourceValueSetUrl", (Object)this.mySourceValueSetUrl).append("targetSystemUrl", (Object)this.myTargetSystemUrl).append("targetValueSetUrl", (Object)this.myTargetValueSetUrl).append("reverse", this.myReverse).toString();
        }
    }

    public static class CodeValidationResult {
        public static final String SOURCE_DETAILS = "sourceDetails";
        public static final String RESULT = "result";
        public static final String MESSAGE = "message";
        public static final String DISPLAY = "display";
        private String myCode;
        private String myMessage;
        private IssueSeverity mySeverity;
        private String myCodeSystemName;
        private String myCodeSystemVersion;
        private List<BaseConceptProperty> myProperties;
        private String myDisplay;
        private String mySourceDetails;

        public String getSourceDetails() {
            return this.mySourceDetails;
        }

        public CodeValidationResult setSourceDetails(String theSourceDetails) {
            this.mySourceDetails = theSourceDetails;
            return this;
        }

        public String getDisplay() {
            return this.myDisplay;
        }

        public CodeValidationResult setDisplay(String theDisplay) {
            this.myDisplay = theDisplay;
            return this;
        }

        public String getCode() {
            return this.myCode;
        }

        public CodeValidationResult setCode(String theCode) {
            this.myCode = theCode;
            return this;
        }

        String getCodeSystemName() {
            return this.myCodeSystemName;
        }

        public CodeValidationResult setCodeSystemName(String theCodeSystemName) {
            this.myCodeSystemName = theCodeSystemName;
            return this;
        }

        public String getCodeSystemVersion() {
            return this.myCodeSystemVersion;
        }

        public CodeValidationResult setCodeSystemVersion(String theCodeSystemVersion) {
            this.myCodeSystemVersion = theCodeSystemVersion;
            return this;
        }

        public String getMessage() {
            return this.myMessage;
        }

        public CodeValidationResult setMessage(String theMessage) {
            this.myMessage = theMessage;
            return this;
        }

        public List<BaseConceptProperty> getProperties() {
            return this.myProperties;
        }

        public void setProperties(List<BaseConceptProperty> theProperties) {
            this.myProperties = theProperties;
        }

        public IssueSeverity getSeverity() {
            return this.mySeverity;
        }

        public CodeValidationResult setSeverity(IssueSeverity theSeverity) {
            this.mySeverity = theSeverity;
            return this;
        }

        public boolean isOk() {
            return StringUtils.isNotBlank((CharSequence)this.myCode);
        }

        public LookupCodeResult asLookupCodeResult(String theSearchedForSystem, String theSearchedForCode) {
            LookupCodeResult retVal = new LookupCodeResult();
            retVal.setSearchedForSystem(theSearchedForSystem);
            retVal.setSearchedForCode(theSearchedForCode);
            if (this.isOk()) {
                retVal.setFound(true);
                retVal.setCodeDisplay(this.myDisplay);
                retVal.setCodeSystemDisplayName(this.getCodeSystemName());
                retVal.setCodeSystemVersion(this.getCodeSystemVersion());
            }
            return retVal;
        }

        public String getSeverityCode() {
            String retVal = null;
            if (this.getSeverity() != null) {
                retVal = this.getSeverity().name().toLowerCase();
            }
            return retVal;
        }

        public CodeValidationResult setSeverityCode(@Nonnull String theIssueSeverity) {
            this.setSeverity(IssueSeverity.valueOf(theIssueSeverity.toUpperCase()));
            return this;
        }

        public IBaseParameters toParameters(FhirContext theContext) {
            IBaseParameters retVal = ParametersUtil.newInstance(theContext);
            ParametersUtil.addParameterToParametersBoolean(theContext, retVal, RESULT, this.isOk());
            if (StringUtils.isNotBlank((CharSequence)this.getMessage())) {
                ParametersUtil.addParameterToParametersString(theContext, retVal, MESSAGE, this.getMessage());
            }
            if (StringUtils.isNotBlank((CharSequence)this.getDisplay())) {
                ParametersUtil.addParameterToParametersString(theContext, retVal, DISPLAY, this.getDisplay());
            }
            if (StringUtils.isNotBlank((CharSequence)this.getSourceDetails())) {
                ParametersUtil.addParameterToParametersString(theContext, retVal, SOURCE_DETAILS, this.getSourceDetails());
            }
            return retVal;
        }
    }

    public static class CodingConceptProperty
    extends BaseConceptProperty {
        private final String myCode;
        private final String myCodeSystem;
        private final String myDisplay;

        public CodingConceptProperty(String theName, String theCodeSystem, String theCode, String theDisplay) {
            super(theName);
            this.myCodeSystem = theCodeSystem;
            this.myCode = theCode;
            this.myDisplay = theDisplay;
        }

        public String getCode() {
            return this.myCode;
        }

        public String getCodeSystem() {
            return this.myCodeSystem;
        }

        public String getDisplay() {
            return this.myDisplay;
        }

        @Override
        public String getType() {
            return IValidationSupport.TYPE_CODING;
        }
    }

    public static class StringConceptProperty
    extends BaseConceptProperty {
        private final String myValue;

        public StringConceptProperty(String theName, String theValue) {
            super(theName);
            this.myValue = theValue;
        }

        public String getValue() {
            return this.myValue;
        }

        @Override
        public String getType() {
            return IValidationSupport.TYPE_STRING;
        }
    }

    public static abstract class BaseConceptProperty {
        private final String myPropertyName;

        protected BaseConceptProperty(String thePropertyName) {
            this.myPropertyName = thePropertyName;
        }

        public String getPropertyName() {
            return this.myPropertyName;
        }

        public abstract String getType();
    }

    public static class ConceptDesignation {
        private String myLanguage;
        private String myUseSystem;
        private String myUseCode;
        private String myUseDisplay;
        private String myValue;

        public String getLanguage() {
            return this.myLanguage;
        }

        public ConceptDesignation setLanguage(String theLanguage) {
            this.myLanguage = theLanguage;
            return this;
        }

        public String getUseSystem() {
            return this.myUseSystem;
        }

        public ConceptDesignation setUseSystem(String theUseSystem) {
            this.myUseSystem = theUseSystem;
            return this;
        }

        public String getUseCode() {
            return this.myUseCode;
        }

        public ConceptDesignation setUseCode(String theUseCode) {
            this.myUseCode = theUseCode;
            return this;
        }

        public String getUseDisplay() {
            return this.myUseDisplay;
        }

        public ConceptDesignation setUseDisplay(String theUseDisplay) {
            this.myUseDisplay = theUseDisplay;
            return this;
        }

        public String getValue() {
            return this.myValue;
        }

        public ConceptDesignation setValue(String theValue) {
            this.myValue = theValue;
            return this;
        }
    }

    public static enum IssueSeverity {
        FATAL,
        ERROR,
        WARNING,
        INFORMATION;

    }
}

