/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.parser.json.jackson;

import ca.uhn.fhir.parser.json.BaseJsonLikeWriter;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.util.DefaultIndenter;
import com.fasterxml.jackson.core.util.DefaultPrettyPrinter;
import com.fasterxml.jackson.core.util.Separators;
import java.io.IOException;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.BigInteger;

public class JacksonWriter
extends BaseJsonLikeWriter {
    private JsonGenerator myJsonGenerator;

    public JacksonWriter(JsonFactory theJsonFactory, Writer theWriter) throws IOException {
        this.myJsonGenerator = theJsonFactory.createGenerator(theWriter);
        this.setWriter(theWriter);
    }

    public JacksonWriter() {
    }

    @Override
    public BaseJsonLikeWriter init() {
        if (this.isPrettyPrint()) {
            DefaultPrettyPrinter prettyPrinter = new DefaultPrettyPrinter(){

                public DefaultPrettyPrinter withSeparators(Separators separators) {
                    this._separators = separators;
                    this._objectFieldValueSeparatorWithSpaces = separators.getObjectFieldValueSeparator() + " ";
                    return this;
                }
            };
            prettyPrinter = prettyPrinter.withObjectIndenter((DefaultPrettyPrinter.Indenter)new DefaultIndenter("  ", "\n"));
            this.myJsonGenerator.setPrettyPrinter((PrettyPrinter)prettyPrinter);
        }
        return this;
    }

    @Override
    public BaseJsonLikeWriter flush() {
        return this;
    }

    @Override
    public void close() throws IOException {
        this.myJsonGenerator.close();
    }

    @Override
    public BaseJsonLikeWriter beginObject() throws IOException {
        this.myJsonGenerator.writeStartObject();
        return this;
    }

    @Override
    public BaseJsonLikeWriter beginObject(String name) throws IOException {
        this.myJsonGenerator.writeObjectFieldStart(name);
        return this;
    }

    @Override
    public BaseJsonLikeWriter beginArray(String name) throws IOException {
        this.myJsonGenerator.writeArrayFieldStart(name);
        return this;
    }

    @Override
    public BaseJsonLikeWriter write(String value) throws IOException {
        this.myJsonGenerator.writeObject((Object)value);
        return this;
    }

    @Override
    public BaseJsonLikeWriter write(BigInteger value) throws IOException {
        this.myJsonGenerator.writeObject((Object)value);
        return this;
    }

    @Override
    public BaseJsonLikeWriter write(BigDecimal value) throws IOException {
        this.myJsonGenerator.writeObject((Object)value);
        return this;
    }

    @Override
    public BaseJsonLikeWriter write(long value) throws IOException {
        this.myJsonGenerator.writeObject((Object)value);
        return this;
    }

    @Override
    public BaseJsonLikeWriter write(double value) throws IOException {
        this.myJsonGenerator.writeObject((Object)value);
        return this;
    }

    @Override
    public BaseJsonLikeWriter write(Boolean value) throws IOException {
        this.myJsonGenerator.writeObject((Object)value);
        return this;
    }

    @Override
    public BaseJsonLikeWriter write(boolean value) throws IOException {
        this.myJsonGenerator.writeObject((Object)value);
        return this;
    }

    @Override
    public BaseJsonLikeWriter writeNull() throws IOException {
        this.myJsonGenerator.writeNull();
        return this;
    }

    @Override
    public BaseJsonLikeWriter write(String name, String value) throws IOException {
        this.myJsonGenerator.writeObjectField(name, (Object)value);
        return this;
    }

    @Override
    public BaseJsonLikeWriter write(String name, BigInteger value) throws IOException {
        this.myJsonGenerator.writeObjectField(name, (Object)value);
        return this;
    }

    @Override
    public BaseJsonLikeWriter write(String name, BigDecimal value) throws IOException {
        this.myJsonGenerator.writeObjectField(name, (Object)value);
        return this;
    }

    @Override
    public BaseJsonLikeWriter write(String name, long value) throws IOException {
        this.myJsonGenerator.writeObjectField(name, (Object)value);
        return this;
    }

    @Override
    public BaseJsonLikeWriter write(String name, double value) throws IOException {
        this.myJsonGenerator.writeObjectField(name, (Object)value);
        return this;
    }

    @Override
    public BaseJsonLikeWriter write(String name, Boolean value) throws IOException {
        this.myJsonGenerator.writeObjectField(name, (Object)value);
        return this;
    }

    @Override
    public BaseJsonLikeWriter write(String name, boolean value) throws IOException {
        this.myJsonGenerator.writeObjectField(name, (Object)value);
        return this;
    }

    @Override
    public BaseJsonLikeWriter endObject() throws IOException {
        this.myJsonGenerator.writeEndObject();
        return this;
    }

    @Override
    public BaseJsonLikeWriter endArray() throws IOException {
        this.myJsonGenerator.writeEndArray();
        return this;
    }

    @Override
    public BaseJsonLikeWriter endBlock() throws IOException {
        this.myJsonGenerator.writeEndObject();
        return this;
    }
}

