/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.util;

import ca.uhn.fhir.context.BaseRuntimeChildDefinition;
import ca.uhn.fhir.context.BaseRuntimeElementCompositeDefinition;
import ca.uhn.fhir.context.BaseRuntimeElementDefinition;
import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.RuntimeResourceDefinition;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.rest.api.PatchTypeEnum;
import ca.uhn.fhir.rest.api.RequestTypeEnum;
import ca.uhn.fhir.rest.server.exceptions.InvalidRequestException;
import ca.uhn.fhir.util.ResourceReferenceInfo;
import ca.uhn.fhir.util.TerserUtil;
import ca.uhn.fhir.util.bundle.BundleEntryMutator;
import ca.uhn.fhir.util.bundle.BundleEntryParts;
import ca.uhn.fhir.util.bundle.EntryListAccumulator;
import ca.uhn.fhir.util.bundle.ModifiableBundleEntry;
import ca.uhn.fhir.util.bundle.SearchBundleEntryParts;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IBaseBinary;
import org.hl7.fhir.instance.model.api.IBaseBundle;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IPrimitiveType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BundleUtil {
    private static final Logger ourLog = LoggerFactory.getLogger(BundleUtil.class);
    static int WHITE = 1;
    static int GRAY = 2;
    static int BLACK = 3;

    public static String getLinkUrlOfType(FhirContext theContext, IBaseBundle theBundle, String theLinkRelation) {
        RuntimeResourceDefinition def = theContext.getResourceDefinition(theBundle);
        BaseRuntimeChildDefinition entryChild = def.getChildByName("link");
        List<IBase> links = entryChild.getAccessor().getValues(theBundle);
        for (IBase nextLink : links) {
            boolean isRightRel = false;
            BaseRuntimeElementCompositeDefinition relDef = (BaseRuntimeElementCompositeDefinition)theContext.getElementDefinition(nextLink.getClass());
            BaseRuntimeChildDefinition relChild = relDef.getChildByName("relation");
            List<IBase> relValues = relChild.getAccessor().getValues(nextLink);
            for (IBase next : relValues) {
                IPrimitiveType nextValue = (IPrimitiveType)next;
                if (!theLinkRelation.equals(nextValue.getValueAsString())) continue;
                isRightRel = true;
            }
            if (!isRightRel) continue;
            BaseRuntimeElementCompositeDefinition linkDef = (BaseRuntimeElementCompositeDefinition)theContext.getElementDefinition(nextLink.getClass());
            BaseRuntimeChildDefinition urlChild = linkDef.getChildByName("url");
            List<IBase> values = urlChild.getAccessor().getValues(nextLink);
            for (IBase nextUrl : values) {
                IPrimitiveType nextValue = (IPrimitiveType)nextUrl;
                if (!StringUtils.isNotBlank((CharSequence)nextValue.getValueAsString())) continue;
                return nextValue.getValueAsString();
            }
        }
        return null;
    }

    public static List<Pair<String, IBaseResource>> getBundleEntryUrlsAndResources(FhirContext theContext, IBaseBundle theBundle) {
        RuntimeResourceDefinition def = theContext.getResourceDefinition(theBundle);
        BaseRuntimeChildDefinition entryChild = def.getChildByName("entry");
        List<IBase> entries = entryChild.getAccessor().getValues(theBundle);
        BaseRuntimeElementCompositeDefinition entryChildElem = (BaseRuntimeElementCompositeDefinition)entryChild.getChildByName("entry");
        BaseRuntimeChildDefinition resourceChild = entryChildElem.getChildByName("resource");
        BaseRuntimeChildDefinition requestChild = entryChildElem.getChildByName("request");
        BaseRuntimeElementCompositeDefinition requestDef = (BaseRuntimeElementCompositeDefinition)requestChild.getChildByName("request");
        BaseRuntimeChildDefinition urlChild = requestDef.getChildByName("url");
        ArrayList<Pair<String, IBaseResource>> retVal = new ArrayList<Pair<String, IBaseResource>>(entries.size());
        for (IBase nextEntry : entries) {
            String url = null;
            IBaseResource resource = null;
            for (IBase nextEntryValue : requestChild.getAccessor().getValues(nextEntry)) {
                for (IBase nextUrlValue : urlChild.getAccessor().getValues(nextEntryValue)) {
                    url = (String)((IPrimitiveType)nextUrlValue).getValue();
                }
            }
            for (IBase nextValue : resourceChild.getAccessor().getValues(nextEntry)) {
                resource = (IBaseResource)nextValue;
            }
            retVal.add((Pair<String, IBaseResource>)Pair.of(url, resource));
        }
        return retVal;
    }

    public static String getBundleType(FhirContext theContext, IBaseBundle theBundle) {
        RuntimeResourceDefinition def = theContext.getResourceDefinition(theBundle);
        BaseRuntimeChildDefinition entryChild = def.getChildByName("type");
        List<IBase> entries = entryChild.getAccessor().getValues(theBundle);
        if (entries.size() > 0) {
            IPrimitiveType typeElement = (IPrimitiveType)entries.get(0);
            return typeElement.getValueAsString();
        }
        return null;
    }

    public static void setBundleType(FhirContext theContext, IBaseBundle theBundle, String theType) {
        RuntimeResourceDefinition def = theContext.getResourceDefinition(theBundle);
        BaseRuntimeChildDefinition entryChild = def.getChildByName("type");
        BaseRuntimeElementDefinition<?> element = entryChild.getChildByName("type");
        IPrimitiveType typeInstance = (IPrimitiveType)element.newInstance(entryChild.getInstanceConstructorArguments());
        typeInstance.setValueAsString(theType);
        entryChild.getMutator().setValue(theBundle, typeInstance);
    }

    public static Integer getTotal(FhirContext theContext, IBaseBundle theBundle) {
        IPrimitiveType typeElement;
        RuntimeResourceDefinition def = theContext.getResourceDefinition(theBundle);
        BaseRuntimeChildDefinition entryChild = def.getChildByName("total");
        List<IBase> entries = entryChild.getAccessor().getValues(theBundle);
        if (entries.size() > 0 && (typeElement = (IPrimitiveType)entries.get(0)) != null && typeElement.getValue() != null) {
            return ((Number)typeElement.getValue()).intValue();
        }
        return null;
    }

    public static void setTotal(FhirContext theContext, IBaseBundle theBundle, Integer theTotal) {
        RuntimeResourceDefinition def = theContext.getResourceDefinition(theBundle);
        BaseRuntimeChildDefinition entryChild = def.getChildByName("total");
        IPrimitiveType value = (IPrimitiveType)entryChild.getChildByName("total").newInstance();
        value.setValue(theTotal);
        entryChild.getMutator().setValue(theBundle, value);
    }

    public static List<BundleEntryParts> toListOfEntries(FhirContext theContext, IBaseBundle theBundle) {
        EntryListAccumulator entryListAccumulator = new EntryListAccumulator();
        BundleUtil.processEntries(theContext, theBundle, entryListAccumulator);
        return entryListAccumulator.getList();
    }

    public static void sortEntriesIntoProcessingOrder(FhirContext theContext, IBaseBundle theBundle) throws IllegalStateException {
        Map<BundleEntryParts, IBase> partsToIBaseMap = BundleUtil.getPartsToIBaseMap(theContext, theBundle);
        LinkedHashSet<IBase> retVal = new LinkedHashSet<IBase>();
        LinkedHashSet<IBase> deleteParts = BundleUtil.sortEntriesOfTypeIntoProcessingOrder(theContext, RequestTypeEnum.DELETE, partsToIBaseMap);
        BundleUtil.validatePartsNotNull(deleteParts);
        retVal.addAll(deleteParts);
        LinkedHashSet<IBase> createParts = BundleUtil.sortEntriesOfTypeIntoProcessingOrder(theContext, RequestTypeEnum.POST, partsToIBaseMap);
        BundleUtil.validatePartsNotNull(createParts);
        retVal.addAll(createParts);
        LinkedHashSet<IBase> updateParts = BundleUtil.sortEntriesOfTypeIntoProcessingOrder(theContext, RequestTypeEnum.PUT, partsToIBaseMap);
        BundleUtil.validatePartsNotNull(updateParts);
        retVal.addAll(updateParts);
        retVal.addAll(partsToIBaseMap.values());
        TerserUtil.clearField(theContext, theBundle, "entry");
        TerserUtil.setField(theContext, "entry", theBundle, retVal.toArray(new IBase[0]));
    }

    private static void validatePartsNotNull(LinkedHashSet<IBase> theDeleteParts) {
        if (theDeleteParts == null) {
            throw new IllegalStateException(Msg.code(1745) + "This transaction contains a cycle, so it cannot be sorted.");
        }
    }

    /*
     * WARNING - void declaration
     */
    private static LinkedHashSet<IBase> sortEntriesOfTypeIntoProcessingOrder(FhirContext theContext, RequestTypeEnum theRequestTypeEnum, Map<BundleEntryParts, IBase> thePartsToIBaseMap) {
        String resourceId;
        IBaseResource resource;
        SortLegality legality = new SortLegality();
        HashMap<String, Integer> color = new HashMap<String, Integer>();
        HashMap<String, List<String>> adjList = new HashMap<String, List<String>>();
        ArrayList<String> topologicalOrder = new ArrayList<String>();
        Set bundleEntryParts = thePartsToIBaseMap.keySet().stream().filter(part -> part.getRequestType().equals((Object)theRequestTypeEnum)).collect(Collectors.toSet());
        HashMap<String, BundleEntryParts> resourceIdToBundleEntryMap = new HashMap<String, BundleEntryParts>();
        for (BundleEntryParts bundleEntryParts2 : bundleEntryParts) {
            resource = bundleEntryParts2.getResource();
            if (resource == null) continue;
            resourceId = resource.getIdElement().toVersionless().toString();
            resourceIdToBundleEntryMap.put(resourceId, bundleEntryParts2);
            if (resourceId == null && bundleEntryParts2.getFullUrl() != null) {
                resourceId = bundleEntryParts2.getFullUrl();
            }
            color.put(resourceId, WHITE);
        }
        for (BundleEntryParts bundleEntryParts3 : bundleEntryParts) {
            resource = bundleEntryParts3.getResource();
            if (resource == null) continue;
            resourceId = resource.getIdElement().toVersionless().toString();
            resourceIdToBundleEntryMap.put(resourceId, bundleEntryParts3);
            if (resourceId == null && bundleEntryParts3.getFullUrl() != null) {
                resourceId = bundleEntryParts3.getFullUrl();
            }
            List<ResourceReferenceInfo> allResourceReferences = theContext.newTerser().getAllResourceReferences(resource);
            String finalResourceId = resourceId;
            allResourceReferences.forEach(refInfo -> {
                String referencedResourceId = refInfo.getResourceReference().getReferenceElement().toVersionless().getValue();
                if (color.containsKey(referencedResourceId)) {
                    if (!adjList.containsKey(finalResourceId)) {
                        adjList.put(finalResourceId, new ArrayList());
                    }
                    ((List)adjList.get(finalResourceId)).add(referencedResourceId);
                }
            });
        }
        for (Map.Entry entry : color.entrySet()) {
            if ((Integer)entry.getValue() != WHITE) continue;
            BundleUtil.depthFirstSearch((String)entry.getKey(), color, adjList, topologicalOrder, legality);
        }
        if (legality.isLegal()) {
            void var10_16;
            if (ourLog.isDebugEnabled()) {
                ourLog.debug("Topological order is: {}", (Object)String.join((CharSequence)",", topologicalOrder));
            }
            LinkedHashSet<IBase> orderedEntries = new LinkedHashSet<IBase>();
            boolean bl = false;
            while (var10_16 < topologicalOrder.size()) {
                BundleEntryParts bep;
                if (theRequestTypeEnum.equals((Object)RequestTypeEnum.DELETE)) {
                    int index = topologicalOrder.size() - var10_16 - 1;
                    bep = (BundleEntryParts)resourceIdToBundleEntryMap.get(topologicalOrder.get(index));
                } else {
                    bep = (BundleEntryParts)resourceIdToBundleEntryMap.get(topologicalOrder.get((int)var10_16));
                }
                IBase base = thePartsToIBaseMap.get(bep);
                orderedEntries.add(base);
                ++var10_16;
            }
            return orderedEntries;
        }
        return null;
    }

    private static void depthFirstSearch(String theResourceId, HashMap<String, Integer> theResourceIdToColor, HashMap<String, List<String>> theAdjList, List<String> theTopologicalOrder, SortLegality theLegality) {
        if (!theLegality.isLegal()) {
            ourLog.debug("Found a cycle while trying to sort bundle entries. This bundle is not sortable.");
            return;
        }
        theResourceIdToColor.put(theResourceId, GRAY);
        for (String neighbourResourceId : (List)theAdjList.getOrDefault(theResourceId, new ArrayList())) {
            if (theResourceIdToColor.get(neighbourResourceId) == WHITE) {
                BundleUtil.depthFirstSearch(neighbourResourceId, theResourceIdToColor, theAdjList, theTopologicalOrder, theLegality);
                continue;
            }
            if (theResourceIdToColor.get(neighbourResourceId) != GRAY) continue;
            theLegality.setLegal(false);
            return;
        }
        theResourceIdToColor.put(theResourceId, BLACK);
        theTopologicalOrder.add(theResourceId);
    }

    private static Map<BundleEntryParts, IBase> getPartsToIBaseMap(FhirContext theContext, IBaseBundle theBundle) {
        RuntimeResourceDefinition bundleDef = theContext.getResourceDefinition(theBundle);
        BaseRuntimeChildDefinition entryChildDef = bundleDef.getChildByName("entry");
        List<IBase> entries = entryChildDef.getAccessor().getValues(theBundle);
        BaseRuntimeElementCompositeDefinition entryChildContentsDef = (BaseRuntimeElementCompositeDefinition)entryChildDef.getChildByName("entry");
        BaseRuntimeChildDefinition fullUrlChildDef = entryChildContentsDef.getChildByName("fullUrl");
        BaseRuntimeChildDefinition resourceChildDef = entryChildContentsDef.getChildByName("resource");
        BaseRuntimeChildDefinition requestChildDef = entryChildContentsDef.getChildByName("request");
        BaseRuntimeElementCompositeDefinition requestChildContentsDef = (BaseRuntimeElementCompositeDefinition)requestChildDef.getChildByName("request");
        BaseRuntimeChildDefinition requestUrlChildDef = requestChildContentsDef.getChildByName("url");
        BaseRuntimeChildDefinition requestIfNoneExistChildDef = requestChildContentsDef.getChildByName("ifNoneExist");
        BaseRuntimeChildDefinition methodChildDef = requestChildContentsDef.getChildByName("method");
        HashMap<BundleEntryParts, IBase> map = new HashMap<BundleEntryParts, IBase>();
        for (IBase nextEntry : entries) {
            BundleEntryParts parts = BundleUtil.getBundleEntryParts(fullUrlChildDef, resourceChildDef, requestChildDef, requestUrlChildDef, requestIfNoneExistChildDef, methodChildDef, nextEntry);
            map.put(parts, nextEntry);
        }
        return map;
    }

    public static List<SearchBundleEntryParts> getSearchBundleEntryParts(FhirContext theContext, IBaseBundle theBundle) {
        RuntimeResourceDefinition bundleDef = theContext.getResourceDefinition(theBundle);
        BaseRuntimeChildDefinition entryChildDef = bundleDef.getChildByName("entry");
        List<IBase> entries = entryChildDef.getAccessor().getValues(theBundle);
        BaseRuntimeElementCompositeDefinition entryChildContentsDef = (BaseRuntimeElementCompositeDefinition)entryChildDef.getChildByName("entry");
        BaseRuntimeChildDefinition fullUrlChildDef = entryChildContentsDef.getChildByName("fullUrl");
        BaseRuntimeChildDefinition resourceChildDef = entryChildContentsDef.getChildByName("resource");
        BaseRuntimeChildDefinition searchChildDef = entryChildContentsDef.getChildByName("search");
        BaseRuntimeElementCompositeDefinition searchChildContentsDef = (BaseRuntimeElementCompositeDefinition)searchChildDef.getChildByName("search");
        BaseRuntimeChildDefinition searchModeChildDef = searchChildContentsDef.getChildByName("mode");
        ArrayList<SearchBundleEntryParts> retVal = new ArrayList<SearchBundleEntryParts>();
        for (IBase nextEntry : entries) {
            SearchBundleEntryParts parts = BundleUtil.getSearchBundleEntryParts(fullUrlChildDef, resourceChildDef, searchChildDef, searchModeChildDef, nextEntry);
            retVal.add(parts);
        }
        return retVal;
    }

    private static SearchBundleEntryParts getSearchBundleEntryParts(BaseRuntimeChildDefinition fullUrlChildDef, BaseRuntimeChildDefinition resourceChildDef, BaseRuntimeChildDefinition searchChildDef, BaseRuntimeChildDefinition searchModeChildDef, IBase entry) {
        IBaseResource resource = null;
        String matchMode = null;
        String fullUrl = fullUrlChildDef.getAccessor().getFirstValueOrNull(entry).map(t -> ((IPrimitiveType)t).getValueAsString()).orElse(null);
        for (IBase nextResource : resourceChildDef.getAccessor().getValues(entry)) {
            resource = (IBaseResource)nextResource;
        }
        for (IBase nextSearch : searchChildDef.getAccessor().getValues(entry)) {
            for (IBase nextUrl : searchModeChildDef.getAccessor().getValues(nextSearch)) {
                matchMode = ((IPrimitiveType)nextUrl).getValueAsString();
            }
        }
        SearchBundleEntryParts parts = new SearchBundleEntryParts(fullUrl, resource, matchMode);
        return parts;
    }

    public static void processEntries(FhirContext theContext, IBaseBundle theBundle, Consumer<ModifiableBundleEntry> theProcessor) {
        RuntimeResourceDefinition bundleDef = theContext.getResourceDefinition(theBundle);
        BaseRuntimeChildDefinition entryChildDef = bundleDef.getChildByName("entry");
        List<IBase> entries = entryChildDef.getAccessor().getValues(theBundle);
        BaseRuntimeElementCompositeDefinition entryChildContentsDef = (BaseRuntimeElementCompositeDefinition)entryChildDef.getChildByName("entry");
        BaseRuntimeChildDefinition fullUrlChildDef = entryChildContentsDef.getChildByName("fullUrl");
        BaseRuntimeChildDefinition resourceChildDef = entryChildContentsDef.getChildByName("resource");
        BaseRuntimeChildDefinition requestChildDef = entryChildContentsDef.getChildByName("request");
        BaseRuntimeElementCompositeDefinition requestChildContentsDef = (BaseRuntimeElementCompositeDefinition)requestChildDef.getChildByName("request");
        BaseRuntimeChildDefinition requestUrlChildDef = requestChildContentsDef.getChildByName("url");
        BaseRuntimeChildDefinition requestIfNoneExistChildDef = requestChildContentsDef.getChildByName("ifNoneExist");
        BaseRuntimeChildDefinition methodChildDef = requestChildContentsDef.getChildByName("method");
        for (IBase nextEntry : entries) {
            BundleEntryParts parts = BundleUtil.getBundleEntryParts(fullUrlChildDef, resourceChildDef, requestChildDef, requestUrlChildDef, requestIfNoneExistChildDef, methodChildDef, nextEntry);
            BundleEntryMutator mutator = new BundleEntryMutator(theContext, nextEntry, requestChildDef, requestChildContentsDef, entryChildContentsDef);
            ModifiableBundleEntry entry = new ModifiableBundleEntry(parts, mutator);
            theProcessor.accept(entry);
        }
    }

    private static BundleEntryParts getBundleEntryParts(BaseRuntimeChildDefinition fullUrlChildDef, BaseRuntimeChildDefinition resourceChildDef, BaseRuntimeChildDefinition requestChildDef, BaseRuntimeChildDefinition requestUrlChildDef, BaseRuntimeChildDefinition requestIfNoneExistChildDef, BaseRuntimeChildDefinition methodChildDef, IBase nextEntry) {
        IBaseResource resource = null;
        String url = null;
        Enum requestType = null;
        String conditionalUrl = null;
        String fullUrl = fullUrlChildDef.getAccessor().getFirstValueOrNull(nextEntry).map(t -> ((IPrimitiveType)t).getValueAsString()).orElse(null);
        for (IBase nextResource : resourceChildDef.getAccessor().getValues(nextEntry)) {
            resource = (IBaseResource)nextResource;
        }
        for (IBase nextRequest : requestChildDef.getAccessor().getValues(nextEntry)) {
            for (IBase nextUrl : requestUrlChildDef.getAccessor().getValues(nextRequest)) {
                url = ((IPrimitiveType)nextUrl).getValueAsString();
            }
            for (IBase nextMethod : methodChildDef.getAccessor().getValues(nextRequest)) {
                String methodString = ((IPrimitiveType)nextMethod).getValueAsString();
                if (!StringUtils.isNotBlank((CharSequence)methodString)) continue;
                requestType = RequestTypeEnum.valueOf(methodString);
            }
            if (requestType == null) continue;
            switch (1.$SwitchMap$ca$uhn$fhir$rest$api$RequestTypeEnum[requestType.ordinal()]) {
                case 1: {
                    conditionalUrl = url != null && url.contains("?") ? url : null;
                    break;
                }
                case 2: {
                    List<IBase> ifNoneExistReps = requestIfNoneExistChildDef.getAccessor().getValues(nextRequest);
                    if (ifNoneExistReps.size() <= 0) break;
                    IPrimitiveType ifNoneExist = (IPrimitiveType)ifNoneExistReps.get(0);
                    conditionalUrl = ifNoneExist.getValueAsString();
                }
            }
        }
        BundleEntryParts parts = new BundleEntryParts(fullUrl, (RequestTypeEnum)requestType, url, resource, conditionalUrl);
        return parts;
    }

    public static List<IBaseResource> toListOfResources(FhirContext theContext, IBaseBundle theBundle) {
        return BundleUtil.toListOfResourcesOfType(theContext, theBundle, IBaseResource.class);
    }

    public static List<String> toListOfResourceIds(FhirContext theContext, IBaseBundle theBundle) {
        return BundleUtil.toListOfResourcesOfType(theContext, theBundle, IBaseResource.class).stream().map(resource -> resource.getIdElement().getIdPart()).collect(Collectors.toList());
    }

    public static <T extends IBaseResource> List<T> toListOfResourcesOfType(FhirContext theContext, IBaseBundle theBundle, Class<T> theTypeToInclude) {
        Objects.requireNonNull(theTypeToInclude, "ResourceType must not be null");
        ArrayList<IBaseResource> retVal = new ArrayList<IBaseResource>();
        RuntimeResourceDefinition def = theContext.getResourceDefinition(theBundle);
        BaseRuntimeChildDefinition entryChild = def.getChildByName("entry");
        List<IBase> entries = entryChild.getAccessor().getValues(theBundle);
        BaseRuntimeElementCompositeDefinition entryChildElem = (BaseRuntimeElementCompositeDefinition)entryChild.getChildByName("entry");
        BaseRuntimeChildDefinition resourceChild = entryChildElem.getChildByName("resource");
        for (IBase nextEntry : entries) {
            for (IBase next : resourceChild.getAccessor().getValues(nextEntry)) {
                if (!theTypeToInclude.isAssignableFrom(next.getClass())) continue;
                retVal.add((IBaseResource)next);
            }
        }
        return retVal;
    }

    public static boolean isDstu3TransactionPatch(FhirContext theContext, IBaseResource thePayloadResource) {
        boolean isPatch = false;
        if (thePayloadResource instanceof IBaseBinary) {
            String contentType = ((IBaseBinary)thePayloadResource).getContentType();
            try {
                PatchTypeEnum.forContentTypeOrThrowInvalidRequestException(theContext, contentType);
                isPatch = true;
            }
            catch (InvalidRequestException invalidRequestException) {
                // empty catch block
            }
        }
        return isPatch;
    }

    public static IBase createNewBundleEntryWithSingleField(FhirContext theContext, String theFieldName, IBase ... theValues) {
        IBaseBundle newBundle = (IBaseBundle)TerserUtil.newResource(theContext, "Bundle");
        BaseRuntimeChildDefinition entryChildDef = theContext.getResourceDefinition(newBundle).getChildByName("entry");
        BaseRuntimeElementCompositeDefinition entryChildElem = (BaseRuntimeElementCompositeDefinition)entryChildDef.getChildByName("entry");
        BaseRuntimeChildDefinition resourceChild = entryChildElem.getChildByName(theFieldName);
        Object bundleEntry = entryChildElem.newInstance();
        for (IBase value : theValues) {
            try {
                resourceChild.getMutator().addValue((IBase)bundleEntry, value);
            }
            catch (UnsupportedOperationException e) {
                ourLog.warn("Resource {} does not support multiple values, but an attempt to set {} was made. Setting the first item only", bundleEntry, (Object)theValues);
                resourceChild.getMutator().setValue((IBase)bundleEntry, value);
                break;
            }
        }
        return bundleEntry;
    }

    private static class SortLegality {
        private boolean myIsLegal = true;

        SortLegality() {
        }

        private void setLegal(boolean theLegal) {
            this.myIsLegal = theLegal;
        }

        public boolean isLegal() {
            return this.myIsLegal;
        }
    }
}

