/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.model.api;

import ca.uhn.fhir.i18n.Msg;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import java.util.function.Consumer;

public class PagingIterator<T>
implements Iterator<T> {
    static final int PAGE_SIZE = 100;
    private int myPage;
    private boolean myIsFinished;
    private final LinkedList<T> myCurrentBatch = new LinkedList();
    private final PageFetcher<T> myFetcher;

    public PagingIterator(PageFetcher<T> theFetcher) {
        this.myFetcher = theFetcher;
    }

    @Override
    public boolean hasNext() {
        this.fetchNextBatch();
        return !this.myCurrentBatch.isEmpty();
    }

    @Override
    public T next() {
        this.fetchNextBatch();
        if (this.myCurrentBatch.isEmpty()) {
            throw new NoSuchElementException(Msg.code(2098) + " Nothing to fetch");
        }
        return this.myCurrentBatch.remove(0);
    }

    private void fetchNextBatch() {
        if (!this.myIsFinished && this.myCurrentBatch.isEmpty()) {
            this.myFetcher.fetchNextPage(this.myPage, 100, this.myCurrentBatch::add);
            ++this.myPage;
            this.myIsFinished = this.myCurrentBatch.size() < 100;
        }
    }

    public static interface PageFetcher<T> {
        public void fetchNextPage(int var1, int var2, Consumer<T> var3);
    }
}

