/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.util;

import ca.uhn.fhir.context.BaseRuntimeChildDefinition;
import ca.uhn.fhir.context.BaseRuntimeElementDefinition;
import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.context.RuntimeResourceDefinition;
import ca.uhn.fhir.model.primitive.IdDt;
import ca.uhn.fhir.util.FhirTerser;
import java.util.Date;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.Validate;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.instance.model.api.IBaseBundle;
import org.hl7.fhir.instance.model.api.IBaseParameters;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;
import org.hl7.fhir.instance.model.api.IPrimitiveType;

public class BundleBuilder {
    private final FhirContext myContext;
    private final IBaseBundle myBundle;
    private final RuntimeResourceDefinition myBundleDef;
    private final BaseRuntimeChildDefinition myEntryChild;
    private final BaseRuntimeChildDefinition myMetaChild;
    private final BaseRuntimeChildDefinition mySearchChild;
    private final BaseRuntimeElementDefinition<?> myEntryDef;
    private final BaseRuntimeElementDefinition<?> myMetaDef;
    private final BaseRuntimeElementDefinition mySearchDef;
    private final BaseRuntimeChildDefinition myEntryResourceChild;
    private final BaseRuntimeChildDefinition myEntryFullUrlChild;
    private final BaseRuntimeChildDefinition myEntryRequestChild;
    private final BaseRuntimeElementDefinition<?> myEntryRequestDef;
    private final BaseRuntimeChildDefinition myEntryRequestUrlChild;
    private final BaseRuntimeChildDefinition myEntryRequestMethodChild;
    private final BaseRuntimeElementDefinition<?> myEntryRequestMethodDef;
    private final BaseRuntimeChildDefinition myEntryRequestIfNoneExistChild;

    public BundleBuilder(FhirContext theContext) {
        this.myContext = theContext;
        this.myBundleDef = this.myContext.getResourceDefinition("Bundle");
        this.myBundle = (IBaseBundle)this.myBundleDef.newInstance();
        this.myEntryChild = this.myBundleDef.getChildByName("entry");
        this.myEntryDef = this.myEntryChild.getChildByName("entry");
        this.mySearchChild = this.myEntryDef.getChildByName("search");
        this.mySearchDef = this.mySearchChild.getChildByName("search");
        if (this.myContext.getVersion().getVersion().isEqualOrNewerThan(FhirVersionEnum.DSTU3)) {
            this.myMetaChild = this.myBundleDef.getChildByName("meta");
            this.myMetaDef = this.myMetaChild.getChildByName("meta");
        } else {
            this.myMetaChild = null;
            this.myMetaDef = null;
        }
        this.myEntryResourceChild = this.myEntryDef.getChildByName("resource");
        this.myEntryFullUrlChild = this.myEntryDef.getChildByName("fullUrl");
        this.myEntryRequestChild = this.myEntryDef.getChildByName("request");
        this.myEntryRequestDef = this.myEntryRequestChild.getChildByName("request");
        this.myEntryRequestUrlChild = this.myEntryRequestDef.getChildByName("url");
        this.myEntryRequestMethodChild = this.myEntryRequestDef.getChildByName("method");
        this.myEntryRequestMethodDef = this.myEntryRequestMethodChild.getChildByName("method");
        this.myEntryRequestIfNoneExistChild = this.myEntryRequestDef.getChildByName("ifNoneExist");
    }

    public BundleBuilder setBundleField(String theFieldName, String theFieldValue) {
        BaseRuntimeChildDefinition typeChild = this.myBundleDef.getChildByName(theFieldName);
        Validate.notNull((Object)typeChild, (String)"Unable to find field %s", (Object[])new Object[]{theFieldName});
        IPrimitiveType type = (IPrimitiveType)typeChild.getChildByName(theFieldName).newInstance(typeChild.getInstanceConstructorArguments());
        type.setValueAsString(theFieldValue);
        typeChild.getMutator().setValue(this.myBundle, type);
        return this;
    }

    public BundleBuilder setSearchField(IBase theSearch, String theFieldName, String theFieldValue) {
        BaseRuntimeChildDefinition typeChild = this.mySearchDef.getChildByName(theFieldName);
        Validate.notNull((Object)typeChild, (String)"Unable to find field %s", (Object[])new Object[]{theFieldName});
        IPrimitiveType type = (IPrimitiveType)typeChild.getChildByName(theFieldName).newInstance(typeChild.getInstanceConstructorArguments());
        type.setValueAsString(theFieldValue);
        typeChild.getMutator().setValue(theSearch, type);
        return this;
    }

    public BundleBuilder setSearchField(IBase theSearch, String theFieldName, IPrimitiveType<?> theFieldValue) {
        BaseRuntimeChildDefinition typeChild = this.mySearchDef.getChildByName(theFieldName);
        Validate.notNull((Object)typeChild, (String)"Unable to find field %s", (Object[])new Object[]{theFieldName});
        typeChild.getMutator().setValue(theSearch, theFieldValue);
        return this;
    }

    public PatchBuilder addTransactionFhirPatchEntry(IIdType theTarget, IBaseParameters thePatch) {
        Validate.notNull((Object)theTarget, (String)"theTarget must not be null", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)theTarget.getResourceType(), (String)"theTarget must contain a resource type", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)theTarget.getIdPart(), (String)"theTarget must contain an ID", (Object[])new Object[0]);
        IPrimitiveType<?> url = this.addAndPopulateTransactionBundleEntryRequest(thePatch, theTarget.getValue(), theTarget.toUnqualifiedVersionless().getValue(), "PATCH");
        return new PatchBuilder(url);
    }

    public PatchBuilder addTransactionFhirPatchEntry(IBaseParameters thePatch) {
        IPrimitiveType<?> url = this.addAndPopulateTransactionBundleEntryRequest(thePatch, null, null, "PATCH");
        return new PatchBuilder(url);
    }

    public UpdateBuilder addTransactionUpdateEntry(IBaseResource theResource) {
        Validate.notNull((Object)theResource, (String)"theResource must not be null", (Object[])new Object[0]);
        IIdType id = theResource.getIdElement();
        if (id.hasIdPart() && !id.hasResourceType()) {
            String resourceType = this.myContext.getResourceType(theResource);
            id = id.withResourceType(resourceType);
        }
        String requestUrl = id.toUnqualifiedVersionless().getValue();
        String fullUrl = id.getValue();
        String verb = "PUT";
        IPrimitiveType<?> url = this.addAndPopulateTransactionBundleEntryRequest(theResource, fullUrl, requestUrl, verb);
        return new UpdateBuilder(url);
    }

    @Nonnull
    private IPrimitiveType<?> addAndPopulateTransactionBundleEntryRequest(IBaseResource theResource, String theFullUrl, String theRequestUrl, String theHttpVerb) {
        this.setBundleField("type", "transaction");
        IBase request = this.addEntryAndReturnRequest(theResource, theFullUrl);
        IPrimitiveType url = (IPrimitiveType)this.myContext.getElementDefinition("uri").newInstance();
        url.setValueAsString(theRequestUrl);
        this.myEntryRequestUrlChild.getMutator().setValue(request, url);
        IPrimitiveType method = (IPrimitiveType)this.myEntryRequestMethodDef.newInstance(this.myEntryRequestMethodChild.getInstanceConstructorArguments());
        method.setValueAsString(theHttpVerb);
        this.myEntryRequestMethodChild.getMutator().setValue(request, method);
        return url;
    }

    public CreateBuilder addTransactionCreateEntry(IBaseResource theResource) {
        this.setBundleField("type", "transaction");
        IBase request = this.addEntryAndReturnRequest(theResource, theResource.getIdElement().getValue());
        String resourceType = this.myContext.getResourceType(theResource);
        IPrimitiveType url = (IPrimitiveType)this.myContext.getElementDefinition("uri").newInstance();
        url.setValueAsString(resourceType);
        this.myEntryRequestUrlChild.getMutator().setValue(request, url);
        IPrimitiveType method = (IPrimitiveType)this.myEntryRequestMethodDef.newInstance(this.myEntryRequestMethodChild.getInstanceConstructorArguments());
        method.setValueAsString("POST");
        this.myEntryRequestMethodChild.getMutator().setValue(request, method);
        return new CreateBuilder(request);
    }

    public DeleteBuilder addTransactionDeleteConditionalEntry(String theCondition) {
        Validate.notBlank((CharSequence)theCondition, (String)"theCondition must not be blank", (Object[])new Object[0]);
        this.setBundleField("type", "transaction");
        return this.addDeleteEntry(theCondition);
    }

    public DeleteBuilder addTransactionDeleteEntry(IBaseResource theResource) {
        String resourceType = this.myContext.getResourceType(theResource);
        String idPart = theResource.getIdElement().toUnqualifiedVersionless().getIdPart();
        return this.addTransactionDeleteEntry(resourceType, idPart);
    }

    public DeleteBuilder addTransactionDeleteEntry(IIdType theResourceId) {
        String resourceType = theResourceId.getResourceType();
        String idPart = theResourceId.getIdPart();
        return this.addTransactionDeleteEntry(resourceType, idPart);
    }

    public DeleteBuilder addTransactionDeleteEntry(String theResourceType, String theIdPart) {
        this.setBundleField("type", "transaction");
        IdDt idDt = new IdDt(theIdPart);
        String deleteUrl = idDt.toUnqualifiedVersionless().withResourceType(theResourceType).getValue();
        return this.addDeleteEntry(deleteUrl);
    }

    public BaseOperationBuilder addTransactionDeleteEntryConditional(String theMatchUrl) {
        Validate.notBlank((CharSequence)theMatchUrl, (String)"theMatchUrl must not be null or blank", (Object[])new Object[0]);
        return this.addDeleteEntry(theMatchUrl);
    }

    @Nonnull
    private DeleteBuilder addDeleteEntry(String theDeleteUrl) {
        IBase request = this.addEntryAndReturnRequest();
        IPrimitiveType url = (IPrimitiveType)this.myContext.getElementDefinition("uri").newInstance();
        url.setValueAsString(theDeleteUrl);
        this.myEntryRequestUrlChild.getMutator().setValue(request, url);
        IPrimitiveType method = (IPrimitiveType)this.myEntryRequestMethodDef.newInstance(this.myEntryRequestMethodChild.getInstanceConstructorArguments());
        method.setValueAsString("DELETE");
        this.myEntryRequestMethodChild.getMutator().setValue(request, method);
        return new DeleteBuilder();
    }

    public void addCollectionEntry(IBaseResource theResource) {
        this.setType("collection");
        this.addEntryAndReturnRequest(theResource, theResource.getIdElement().getValue());
    }

    public void addDocumentEntry(IBaseResource theResource) {
        this.setType("document");
        this.addEntryAndReturnRequest(theResource, theResource.getIdElement().getValue());
    }

    public IBase addEntry() {
        Object entry = this.myEntryDef.newInstance();
        this.myEntryChild.getMutator().addValue(this.myBundle, (IBase)entry);
        return entry;
    }

    public IBaseBackboneElement addSearch(IBase entry) {
        Validate.isTrue((boolean)this.myContext.getVersion().getVersion().isEqualOrNewerThan(FhirVersionEnum.DSTU3), (String)"This method may only be called for FHIR version DSTU3 and above", (Object[])new Object[0]);
        Object searchInstance = this.mySearchDef.newInstance();
        this.mySearchChild.getMutator().setValue(entry, (IBase)searchInstance);
        return (IBaseBackboneElement)searchInstance;
    }

    private IBase addEntryAndReturnRequest(IBaseResource theResource, String theFullUrl) {
        Validate.notNull((Object)theResource, (String)"theResource must not be null", (Object[])new Object[0]);
        IBase entry = this.addEntry();
        IPrimitiveType fullUrl = (IPrimitiveType)this.myContext.getElementDefinition("uri").newInstance();
        fullUrl.setValueAsString(theFullUrl);
        this.myEntryFullUrlChild.getMutator().setValue(entry, fullUrl);
        this.myEntryResourceChild.getMutator().setValue(entry, theResource);
        Object request = this.myEntryRequestDef.newInstance();
        this.myEntryRequestChild.getMutator().setValue(entry, (IBase)request);
        return request;
    }

    public IBase addEntryAndReturnRequest() {
        IBase entry = this.addEntry();
        Object request = this.myEntryRequestDef.newInstance();
        this.myEntryRequestChild.getMutator().setValue(entry, (IBase)request);
        return request;
    }

    public IBaseBundle getBundle() {
        return this.myBundle;
    }

    public <T extends IBaseBundle> T getBundleTyped() {
        return (T)this.myBundle;
    }

    public BundleBuilder setMetaField(String theFieldName, IBase theFieldValue) {
        Validate.isTrue((boolean)this.myContext.getVersion().getVersion().isEqualOrNewerThan(FhirVersionEnum.DSTU3), (String)"This method may only be called for FHIR version DSTU3 and above", (Object[])new Object[0]);
        BaseRuntimeChildDefinition.IMutator mutator = this.myMetaDef.getChildByName(theFieldName).getMutator();
        mutator.setValue(this.myBundle.getMeta(), theFieldValue);
        return this;
    }

    public void addToEntry(IBase theEntry, String theEntryChildName, IBase theValue) {
        this.addToBase(theEntry, theEntryChildName, theValue, this.myEntryDef);
    }

    public void addToSearch(IBase theSearch, String theSearchFieldName, IBase theSearchFieldValue) {
        this.addToBase(theSearch, theSearchFieldName, theSearchFieldValue, this.mySearchDef);
    }

    private void addToBase(IBase theBase, String theSearchChildName, IBase theValue, BaseRuntimeElementDefinition mySearchDef) {
        BaseRuntimeChildDefinition defn = mySearchDef.getChildByName(theSearchChildName);
        Validate.notNull((Object)defn, (String)"Unable to get child definition %s from %s", (Object[])new Object[]{theSearchChildName, theBase});
        defn.getMutator().addValue(theBase, theValue);
    }

    public <T> IPrimitiveType<T> newPrimitive(String theTypeName) {
        BaseRuntimeElementDefinition<?> primitiveDefinition = this.myContext.getElementDefinition(theTypeName);
        Validate.notNull(primitiveDefinition, (String)"Unable to find definition for %s", (Object[])new Object[]{theTypeName});
        return (IPrimitiveType)primitiveDefinition.newInstance();
    }

    public <T> IPrimitiveType<T> newPrimitive(String theTypeName, T theInitialValue) {
        IPrimitiveType<T> retVal = this.newPrimitive(theTypeName);
        retVal.setValue(theInitialValue);
        return retVal;
    }

    public void setType(String theType) {
        this.setBundleField("type", theType);
    }

    public void setIdentifier(@Nullable String theSystem, @Nullable String theValue) {
        FhirTerser terser = this.myContext.newTerser();
        Object identifier = terser.addElement(this.myBundle, "identifier");
        terser.setElement((IBase)identifier, "system", theSystem);
        terser.setElement((IBase)identifier, "value", theValue);
    }

    public void setTimestamp(@Nonnull IPrimitiveType<Date> theTimestamp) {
        FhirTerser terser = this.myContext.newTerser();
        terser.setElement(this.myBundle, "Bundle.timestamp", theTimestamp.getValueAsString());
    }

    public class PatchBuilder
    extends BaseOperationBuilderWithConditionalUrl<PatchBuilder> {
        PatchBuilder(IPrimitiveType<?> theUrl) {
            super(theUrl);
        }
    }

    public class UpdateBuilder
    extends BaseOperationBuilderWithConditionalUrl<UpdateBuilder> {
        UpdateBuilder(IPrimitiveType<?> theUrl) {
            super(theUrl);
        }
    }

    public class CreateBuilder
    extends BaseOperationBuilder {
        private final IBase myRequest;

        CreateBuilder(IBase theRequest) {
            this.myRequest = theRequest;
        }

        public CreateBuilder conditional(String theConditionalUrl) {
            BaseRuntimeElementDefinition<?> stringDefinition = Objects.requireNonNull(BundleBuilder.this.myContext.getElementDefinition("string"));
            IPrimitiveType ifNoneExist = (IPrimitiveType)stringDefinition.newInstance();
            ifNoneExist.setValueAsString(theConditionalUrl);
            BundleBuilder.this.myEntryRequestIfNoneExistChild.getMutator().setValue(this.myRequest, ifNoneExist);
            return this;
        }
    }

    public class DeleteBuilder
    extends BaseOperationBuilder {
    }

    public abstract class BaseOperationBuilderWithConditionalUrl<T extends BaseOperationBuilder>
    extends BaseOperationBuilder {
        private final IPrimitiveType<?> myUrl;

        BaseOperationBuilderWithConditionalUrl(IPrimitiveType<?> theUrl) {
            this.myUrl = theUrl;
        }

        public T conditional(String theConditionalUrl) {
            this.myUrl.setValueAsString(theConditionalUrl);
            return (T)this;
        }
    }

    public abstract class BaseOperationBuilder {
        public BundleBuilder andThen() {
            return BundleBuilder.this;
        }
    }
}

