/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.api;

import ca.uhn.fhir.util.CoverageIgnore;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.Validate;

@CoverageIgnore
public enum RestOperationTypeEnum {
    BATCH("batch", true, false, false),
    ADD_TAGS("add-tags", false, false, true),
    DELETE_TAGS("delete-tags", false, false, true),
    GET_TAGS("get-tags", false, true, true),
    GET_PAGE("get-page", false, false, false),
    GRAPHQL_REQUEST("graphql-request", false, false, false),
    EXTENDED_OPERATION_SERVER("extended-operation-server", false, false, false),
    EXTENDED_OPERATION_TYPE("extended-operation-type", false, false, false),
    EXTENDED_OPERATION_INSTANCE("extended-operation-instance", false, false, false),
    CREATE("create", false, true, false),
    DELETE("delete", false, false, true),
    HISTORY_INSTANCE("history-instance", false, false, true),
    HISTORY_SYSTEM("history-system", true, false, false),
    HISTORY_TYPE("history-type", false, true, false),
    READ("read", false, false, true),
    SEARCH_SYSTEM("search-system", true, false, false),
    SEARCH_TYPE("search-type", false, true, false),
    TRANSACTION("transaction", true, false, false),
    UPDATE("update", false, false, true),
    VALIDATE("validate", false, true, true),
    VREAD("vread", false, false, true),
    METADATA("metadata", false, false, false),
    META_ADD("$meta-add", false, false, false),
    META("$meta", false, false, false),
    META_DELETE("$meta-delete", false, false, false),
    PATCH("patch", false, false, true),
    UPDATE_REWRITE_HISTORY("update-rewrite-history", false, false, true);

    private static final Map<String, RestOperationTypeEnum> CODE_TO_ENUM;
    public static final String VALUESET_IDENTIFIER = "http://hl7.org/fhir/vs/type-restful-operation";
    public static final String VALUESET_NAME = "RestfulOperationType";
    private final String myCode;
    private final boolean mySystemLevel;
    private final boolean myTypeLevel;
    private final boolean myInstanceLevel;

    private RestOperationTypeEnum(String theCode, boolean theSystemLevel, boolean theTypeLevel, boolean theInstanceLevel) {
        this.myCode = theCode;
        this.mySystemLevel = theSystemLevel;
        this.myTypeLevel = theTypeLevel;
        this.myInstanceLevel = theInstanceLevel;
    }

    public static RestOperationTypeEnum forCode(@Nonnull String theCode) {
        Validate.notNull((Object)theCode, (String)"theCode must not be null", (Object[])new Object[0]);
        return CODE_TO_ENUM.get(theCode);
    }

    @Nonnull
    public String getCode() {
        return this.myCode;
    }

    public boolean isSystemLevel() {
        return this.mySystemLevel;
    }

    public boolean isTypeLevel() {
        return this.myTypeLevel;
    }

    public boolean isInstanceLevel() {
        return this.myInstanceLevel;
    }

    static {
        CODE_TO_ENUM = new HashMap<String, RestOperationTypeEnum>();
        for (RestOperationTypeEnum next : RestOperationTypeEnum.values()) {
            CODE_TO_ENUM.put(next.getCode(), next);
        }
    }
}

